/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber6jvm;

import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.TestCase;
import io.qameta.allure.SeverityLevel;
import java.util.Arrays;

class TagParser {
    private static final String FLAKY = "@FLAKY";
    private static final String KNOWN = "@KNOWN";
    private static final String MUTED = "@MUTED";
    private final Messages.GherkinDocument.Feature feature;
    private final TestCase scenario;

    TagParser(Messages.GherkinDocument.Feature feature, TestCase scenario) {
        this.feature = feature;
        this.scenario = scenario;
    }

    public boolean isFlaky() {
        return this.getStatusDetailByTag(FLAKY);
    }

    public boolean isMuted() {
        return this.getStatusDetailByTag(MUTED);
    }

    public boolean isKnown() {
        return this.getStatusDetailByTag(KNOWN);
    }

    private boolean getStatusDetailByTag(String tagName) {
        return this.scenario.getTags().stream().anyMatch(tag -> tag.equalsIgnoreCase(tagName)) || this.feature.getTagsList().stream().anyMatch(tag -> tag.getName().equalsIgnoreCase(tagName));
    }

    public boolean isResultTag(String tag) {
        return Arrays.asList(FLAKY, KNOWN, MUTED).contains(tag.toUpperCase());
    }

    public boolean isPureSeverityTag(String tag) {
        return Arrays.stream(SeverityLevel.values()).map(SeverityLevel::value).map(value -> "@" + value).anyMatch(value -> value.equalsIgnoreCase(tag));
    }
}

