/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api;

import io.qase.api.config.QaseConfig;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiClient;
import io.qase.client.api.RunsApi;
import io.qase.client.model.RunCreate;
import java.util.Map;
import org.aeonbits.owner.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QaseClient {
    private static final Logger logger = LoggerFactory.getLogger(QaseClient.class);
    private static final QaseConfig qaseConfig = (QaseConfig)ConfigFactory.create(QaseConfig.class, (Map[])new Map[0]);
    private static boolean isEnabled = qaseConfig.isEnabled();
    private static final ThreadLocal<ApiClient> apiClient = new InheritableThreadLocal<ApiClient>();

    private static ApiClient initApiClient() {
        ApiClient client = new ApiClient();
        String apiToken = QaseClient.getConfig().apiToken();
        if (apiToken == null) {
            isEnabled = false;
            logger.info("Required parameter '{}' isn't specified", (Object)"QASE_API_TOKEN");
        }
        client.setBasePath(QaseClient.getConfig().baseUrl());
        client.setApiKey(apiToken);
        if (QaseClient.getConfig().projectCode() == null) {
            isEnabled = false;
            logger.info("Required parameter '{}' isn't specified", (Object)"QASE_PROJECT_CODE");
        }
        logger.info("Qase project code - {}", (Object)QaseClient.getConfig().projectCode());
        if (QaseClient.getConfig().runId() == null) {
            if (QaseClient.getConfig().runName() == null) {
                isEnabled = false;
                logger.info("Required parameters '{}' or '{}' aren't specified", (Object)"QASE_RUN_ID", (Object)"QASE_RUN_NAME");
            } else {
                Long id;
                try {
                    id = new RunsApi(client).createRun(QaseClient.getConfig().projectCode(), new RunCreate().title(QaseClient.getConfig().runName()).description(QaseClient.getConfig().runDescription()).isAutotest(true)).getResult().getId();
                }
                catch (QaseException e) {
                    throw new IllegalStateException(e);
                }
                QaseClient.getConfig().setProperty("QASE_RUN_ID", String.valueOf(id));
            }
        }
        logger.info("Qase run id - {}", (Object)QaseClient.getConfig().runId());
        return client;
    }

    public static QaseConfig getConfig() {
        return qaseConfig;
    }

    public static ApiClient getApiClient() {
        if (apiClient.get() == null) {
            apiClient.set(QaseClient.initApiClient());
        }
        return apiClient.get();
    }

    public static void setApiClient(ApiClient client) {
        apiClient.set(client);
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void setEnabled(boolean isEnabled) {
        QaseClient.isEnabled = isEnabled;
    }
}

