/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.AttachmentListResponse;
import io.qase.client.model.AttachmentResponse;
import io.qase.client.model.AttachmentUploadsResponse;
import io.qase.client.model.HashResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class AttachmentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AttachmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttachmentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteAttachmentCall(String hash, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/attachment/{hash}".replace("{hash}", this.localVarApiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAttachmentValidateBeforeCall(String hash, ApiCallback _callback) throws QaseException {
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling deleteAttachment(Async)");
        }
        return this.deleteAttachmentCall(hash, _callback);
    }

    public HashResponse deleteAttachment(String hash) throws QaseException {
        ApiResponse<HashResponse> localVarResp = this.deleteAttachmentWithHttpInfo(hash);
        return localVarResp.getData();
    }

    public ApiResponse<HashResponse> deleteAttachmentWithHttpInfo(String hash) throws QaseException {
        Call localVarCall = this.deleteAttachmentValidateBeforeCall(hash, null);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteAttachmentAsync(String hash, ApiCallback<HashResponse> _callback) throws QaseException {
        Call localVarCall = this.deleteAttachmentValidateBeforeCall(hash, _callback);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAttachmentCall(String hash, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/attachment/{hash}".replace("{hash}", this.localVarApiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentValidateBeforeCall(String hash, ApiCallback _callback) throws QaseException {
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling getAttachment(Async)");
        }
        return this.getAttachmentCall(hash, _callback);
    }

    public AttachmentResponse getAttachment(String hash) throws QaseException {
        ApiResponse<AttachmentResponse> localVarResp = this.getAttachmentWithHttpInfo(hash);
        return localVarResp.getData();
    }

    public ApiResponse<AttachmentResponse> getAttachmentWithHttpInfo(String hash) throws QaseException {
        Call localVarCall = this.getAttachmentValidateBeforeCall(hash, null);
        Type localVarReturnType = new TypeToken<AttachmentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAttachmentAsync(String hash, ApiCallback<AttachmentResponse> _callback) throws QaseException {
        Call localVarCall = this.getAttachmentValidateBeforeCall(hash, _callback);
        Type localVarReturnType = new TypeToken<AttachmentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAttachmentsCall(Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/attachment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentsValidateBeforeCall(Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        return this.getAttachmentsCall(limit, offset, _callback);
    }

    public AttachmentListResponse getAttachments(Integer limit, Integer offset) throws QaseException {
        ApiResponse<AttachmentListResponse> localVarResp = this.getAttachmentsWithHttpInfo(limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<AttachmentListResponse> getAttachmentsWithHttpInfo(Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getAttachmentsValidateBeforeCall(limit, offset, null);
        Type localVarReturnType = new TypeToken<AttachmentListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAttachmentsAsync(Integer limit, Integer offset, ApiCallback<AttachmentListResponse> _callback) throws QaseException {
        Call localVarCall = this.getAttachmentsValidateBeforeCall(limit, offset, _callback);
        Type localVarReturnType = new TypeToken<AttachmentListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadAttachmentCall(String code, List<File> _file, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/attachment/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadAttachmentValidateBeforeCall(String code, List<File> _file, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling uploadAttachment(Async)");
        }
        return this.uploadAttachmentCall(code, _file, _callback);
    }

    public AttachmentUploadsResponse uploadAttachment(String code, List<File> _file) throws QaseException {
        ApiResponse<AttachmentUploadsResponse> localVarResp = this.uploadAttachmentWithHttpInfo(code, _file);
        return localVarResp.getData();
    }

    public ApiResponse<AttachmentUploadsResponse> uploadAttachmentWithHttpInfo(String code, List<File> _file) throws QaseException {
        Call localVarCall = this.uploadAttachmentValidateBeforeCall(code, _file, null);
        Type localVarReturnType = new TypeToken<AttachmentUploadsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadAttachmentAsync(String code, List<File> _file, ApiCallback<AttachmentUploadsResponse> _callback) throws QaseException {
        Call localVarCall = this.uploadAttachmentValidateBeforeCall(code, _file, _callback);
        Type localVarReturnType = new TypeToken<AttachmentUploadsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

