/*
 * Decompiled with CFR 0.152.
 */
package io.qase.utils;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CommonUtils {
    @SafeVarargs
    public static <T> Optional<T> getFirstNonNullResult(Supplier<T> ... suppliers) {
        Iterable wrappedSuppliers = Arrays.stream(suppliers).map(CommonUtils::convertSupplierToFunction).collect(Collectors.toList());
        return CommonUtils.getFirstNonNullResult(null, wrappedSuppliers);
    }

    @SafeVarargs
    public static <I, O> Optional<O> getFirstNonNullResult(I inputFunctionsArgument, Function<I, O> ... argumentFunctions) {
        return CommonUtils.getFirstNonNullResult(inputFunctionsArgument, Arrays.asList(argumentFunctions));
    }

    public static <I, O> Optional<O> getFirstNonNullResult(I inputFunctionsArgument, Iterable<Function<I, O>> argumentFunctions) {
        for (Function<I, O> function : argumentFunctions) {
            O outputResult = function.apply(inputFunctionsArgument);
            if (outputResult == null) continue;
            return Optional.of(outputResult);
        }
        return Optional.empty();
    }

    private static <O> Function<Void, O> convertSupplierToFunction(Supplier<O> supplier) {
        return aVoid -> supplier.get();
    }

    private CommonUtils() {
    }
}

