/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.runtime;

import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkus.amazon.common.runtime.RuntimeConfigurationError;
import io.quarkus.amazon.common.runtime.SdkBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.utils.StringUtils;

@Recorder
public class AmazonClientCommonRecorder {
    private static final Log LOG = LogFactory.getLog(AmazonClientCommonRecorder.class);

    public RuntimeValue<AwsClientBuilder> configure(RuntimeValue<? extends AwsClientBuilder> clientBuilder, RuntimeValue<AwsConfig> awsConfig, RuntimeValue<SdkConfig> sdkConfig, HasSdkBuildTimeConfig sdkBuildTimeConfig, ScheduledExecutorService scheduledExecutorService, String awsServiceName) {
        AwsClientBuilder builder = (AwsClientBuilder)clientBuilder.getValue();
        this.initAwsClient(builder, awsServiceName, (AwsConfig)awsConfig.getValue());
        this.initSdkClient((SdkClientBuilder)builder, awsServiceName, (SdkConfig)sdkConfig.getValue(), sdkBuildTimeConfig.sdk(), scheduledExecutorService);
        return new RuntimeValue((Object)builder);
    }

    public void initAwsClient(AwsClientBuilder builder, String extension, AwsConfig config) {
        config.region().ifPresent(arg_0 -> ((AwsClientBuilder)builder).region(arg_0));
        builder.credentialsProvider(config.credentials().type().create(config.credentials(), "quarkus." + extension));
    }

    public void initSdkClient(SdkClientBuilder builder, String extension, SdkConfig config, SdkBuildTimeConfig buildConfig, ScheduledExecutorService scheduledExecutorService) {
        URI endpointOverride;
        if (config.endpointOverride().isPresent() && StringUtils.isBlank((CharSequence)(endpointOverride = config.endpointOverride().get()).getScheme())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.endpoint-override (%s) - scheme must be specified", extension, endpointOverride.toString()));
        }
        config.endpointOverride().filter(URI::isAbsolute).ifPresent(arg_0 -> ((SdkClientBuilder)builder).endpointOverride(arg_0));
        ClientOverrideConfiguration.Builder overrides = ClientOverrideConfiguration.builder();
        if (config.advanced().useQuarkusScheduledExecutorService()) {
            overrides.scheduledExecutorService(scheduledExecutorService);
        }
        config.apiCallTimeout().ifPresent(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).apiCallTimeout(arg_0));
        config.apiCallAttemptTimeout().ifPresent(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).apiCallAttemptTimeout(arg_0));
        buildConfig.interceptors().orElse(Collections.emptyList()).stream().map(String::trim).map(this::createInterceptor).filter(Objects::nonNull).forEach(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).addExecutionInterceptor(arg_0));
        builder.overrideConfiguration((ClientOverrideConfiguration)overrides.build());
    }

    public RuntimeValue<SdkPresigner.Builder> configurePresigner(RuntimeValue<? extends SdkPresigner.Builder> clientBuilder, RuntimeValue<AwsConfig> awsConfig, RuntimeValue<SdkConfig> sdkConfig, String awsServiceName) {
        SdkPresigner.Builder builder = (SdkPresigner.Builder)clientBuilder.getValue();
        this.initAwsPresigner(builder, awsServiceName, (AwsConfig)awsConfig.getValue());
        this.initSdkPresigner(builder, awsServiceName, (SdkConfig)sdkConfig.getValue());
        return new RuntimeValue((Object)builder);
    }

    public void initAwsPresigner(SdkPresigner.Builder builder, String extension, AwsConfig config) {
        config.region().ifPresent(arg_0 -> ((SdkPresigner.Builder)builder).region(arg_0));
        builder.credentialsProvider(config.credentials().type().create(config.credentials(), "quarkus." + extension));
    }

    public void initSdkPresigner(SdkPresigner.Builder builder, String extension, SdkConfig config) {
        URI endpointOverride;
        if (config.endpointOverride().isPresent() && StringUtils.isBlank((CharSequence)(endpointOverride = config.endpointOverride().get()).getScheme())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.endpoint-override (%s) - scheme must be specified", extension, endpointOverride.toString()));
        }
        config.endpointOverride().filter(URI::isAbsolute).ifPresent(arg_0 -> ((SdkPresigner.Builder)builder).endpointOverride(arg_0));
    }

    private ExecutionInterceptor createInterceptor(String interceptorClassName) {
        try {
            Class<?> classObj = Thread.currentThread().getContextClassLoader().loadClass(interceptorClassName);
            try {
                return (ExecutionInterceptor)CDI.current().select(classObj, new Annotation[0]).get();
            }
            catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
                return (ExecutionInterceptor)classObj.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.error((Object)("Unable to create interceptor " + interceptorClassName), (Throwable)e);
            return null;
        }
    }
}

