/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.core.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import java.util.Optional;

@ConfigGroup
public interface ArtemisRuntimeConfig {
    public Optional<String> url();

    public Optional<String> username();

    public Optional<String> password();

    public Optional<Boolean> healthExclude();

    default public String getUrl() {
        return this.url().orElse(null);
    }

    default public String getUsername() {
        return this.username().orElse(null);
    }

    default public String getPassword() {
        return this.password().orElse(null);
    }

    default public boolean isHealthExclude() {
        return this.healthExclude().orElse(false);
    }

    default public boolean isHealthInclude() {
        return !this.isHealthExclude();
    }

    default public boolean isEmpty() {
        return this.url().isEmpty() && this.username().isEmpty() && this.password().isEmpty() && this.healthExclude().isEmpty();
    }

    default public boolean isPresent() {
        return !this.isEmpty();
    }
}

