/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.core.runtime;

import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import io.smallrye.config.WithUnnamedKey;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@ConfigMapping(prefix="quarkus.artemis")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface ArtemisRuntimeConfigs {
    @WithParentName
    @WithDefaults
    @WithUnnamedKey(value="<default>")
    public @WithUnnamedKey(value="<default>") Map<String, ArtemisRuntimeConfig> configs();

    @WithName(value="health.external.enabled")
    public Optional<Boolean> healthExternalEnabled();

    default public Set<String> getNames() {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry<String, ArtemisRuntimeConfig> entry : this.configs().entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            names.add(entry.getKey());
        }
        return names;
    }

    default public boolean getHealthExternalEnabled() {
        return this.healthExternalEnabled().orElse(true);
    }

    default public boolean isEmpty() {
        Boolean hasNoConfig = this.configs().values().stream().map(ArtemisRuntimeConfig::isEmpty).reduce(true, Boolean::logicalAnd);
        return hasNoConfig != false && this.healthExternalEnabled().isEmpty();
    }
}

