/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.core.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfigs;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

public class ArtemisUtil {
    public static final String DEFAULT_CONFIG_NAME = "<default>";

    private ArtemisUtil() {
    }

    public static boolean isDefault(String configName) {
        return DEFAULT_CONFIG_NAME.equals(configName);
    }

    public static void validateIntegrity(String name, ArtemisRuntimeConfig runtimeConfig, ArtemisBuildTimeConfig buildTimeConfig) {
        boolean devServiceEnabled = buildTimeConfig.getDevservices().isEnabled();
        if (runtimeConfig.getUrl() == null && devServiceEnabled) {
            throw new IllegalStateException(String.format("Configuration %s: url is not set and devservices is activated. This is a bug. Please report it.", name));
        }
        if ((runtimeConfig.isPresent() || buildTimeConfig.isPresent()) && buildTimeConfig.isEnabled() && runtimeConfig.getUrl() == null) {
            throw new IllegalStateException(String.format("Configuration %s: the configuration is enabled, but no URL is configured. Please either disable the configuration or set the URL.", name));
        }
    }

    public static <T> Set<String> extractIdentifiers(Class<T> clazz, Set<String> namesToIgnore) {
        HashSet<String> names = new HashSet<String>();
        for (InstanceHandle handle : Arc.container().listAll(clazz, new Annotation[]{Any.Literal.INSTANCE})) {
            String name = ArtemisUtil.extractIdentifier(handle);
            if (name == null || namesToIgnore.contains(name)) continue;
            names.add(name);
        }
        return names;
    }

    private static String extractIdentifier(InstanceHandle<?> handle) {
        for (Annotation qualifier : handle.getBean().getQualifiers()) {
            if (!(qualifier instanceof Identifier)) continue;
            Identifier identifier = (Identifier)qualifier;
            return identifier.value();
        }
        return null;
    }

    public static <T> Set<String> getExternalNames(Class<T> type, ArtemisRuntimeConfigs runtimeConfigs, ArtemisBuildTimeConfigs buildTimeConfigs) {
        HashSet<String> externalNames = new HashSet<String>();
        if (runtimeConfigs.getHealthExternalEnabled()) {
            HashSet<String> namesToIgnore = new HashSet<String>(runtimeConfigs.getNames());
            namesToIgnore.addAll(buildTimeConfigs.getNames());
            externalNames.addAll(ArtemisUtil.extractIdentifiers(type, namesToIgnore));
        }
        return externalNames;
    }

    public static Annotation toIdentifier(String name) {
        if (ArtemisUtil.isDefault(name)) {
            return Default.Literal.INSTANCE;
        }
        return Identifier.Literal.of((String)name);
    }
}

