/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.logging.runtime;

import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.Payload;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.quarkiverse.googlecloudservices.logging.runtime.LoggingConfiguration;
import io.quarkiverse.googlecloudservices.logging.runtime.TraceInfo;
import io.quarkiverse.googlecloudservices.logging.runtime.TraceInfoExtractor;
import io.quarkiverse.googlecloudservices.logging.runtime.format.InternalHandler;
import io.quarkiverse.googlecloudservices.logging.runtime.format.JsonHandler;
import io.quarkiverse.googlecloudservices.logging.runtime.format.TextHandler;
import io.quarkiverse.googlecloudservices.logging.runtime.util.LevelTransformer;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import java.lang.annotation.Annotation;
import java.util.Collections;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class LoggingHandler
extends ExtHandler {
    private final LoggingConfiguration config;
    private volatile Logging log;
    private Logging.WriteOption[] defaultWriteOptions;
    private InternalHandler internalHandler;
    private TraceInfoExtractor traceExtractor;

    public LoggingHandler(LoggingConfiguration config) {
        this.config = config;
    }

    public void close() throws SecurityException {
    }

    public void doPublish(ExtLogRecord record) {
        try {
            Logging l = this.initGetLogging();
            if (l == null) {
                return;
            }
            TraceInfo trace = this.traceExtractor.extract(record);
            LogEntry logEntry = this.transform(record, trace);
            if (logEntry != null) {
                switch (this.config.logTarget) {
                    case STDOUT: {
                        System.out.println(logEntry.toStructuredJsonString());
                        break;
                    }
                    case STDERR: {
                        System.err.println(logEntry.toStructuredJsonString());
                        break;
                    }
                    case CLOUD_LOGGING: {
                        l.write((Iterable)ImmutableList.of((Object)logEntry), this.defaultWriteOptions);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.getErrorManager().error("Failed to write logs", ex, 1);
        }
    }

    private LogEntry transform(ExtLogRecord record, TraceInfo trace) {
        Payload<?> payload = this.internalHandler.transform(record, trace);
        if (payload != null) {
            LogEntry.Builder builder = LogEntry.newBuilder(payload).setSeverity(LevelTransformer.toSeverity(record.getLevel())).setTimestamp(record.getInstant());
            if (this.config.gcpTracing.enabled && trace != null && !Strings.isNullOrEmpty((String)trace.getTraceId())) {
                builder = builder.setTrace(this.composeTraceString(trace.getTraceId()));
            }
            return builder.build();
        }
        return null;
    }

    private String composeTraceString(String traceId) {
        return String.format("projects/%s/traces/%s", this.config.gcpTracing.projectId.orElse(null), traceId);
    }

    public void flush() {
        try {
            this.initGetLogging().flush();
        }
        catch (Exception ex) {
            this.getErrorManager().error("Failed to fluch GCP logger", ex, 2);
        }
    }

    private synchronized Logging initGetLogging() {
        if (this.log == null) {
            if (!this.initLogger()) {
                return null;
            }
            this.initDefaultWriteOptions();
            this.initInternalHandler();
            this.initTraceExtractor();
        }
        return this.log;
    }

    private void initInternalHandler() {
        this.internalHandler = this.config.format == LoggingConfiguration.LogFormat.JSON ? new JsonHandler(this.config, this.getErrorManager()) : new TextHandler();
    }

    private void initTraceExtractor() {
        InstanceHandle handle = Arc.container().instance(TraceInfoExtractor.class, new Annotation[0]);
        this.traceExtractor = handle.isAvailable() ? (TraceInfoExtractor)handle.get() : r -> null;
    }

    private void initDefaultWriteOptions() {
        this.defaultWriteOptions = new Logging.WriteOption[]{Logging.WriteOption.logName((String)this.config.defaultLog), Logging.WriteOption.resource((MonitoredResource)this.createMonitoredResource()), Logging.WriteOption.labels(this.config.defaultLabel == null ? Collections.emptyMap() : this.config.defaultLabel)};
    }

    private MonitoredResource createMonitoredResource() {
        MonitoredResource.Builder b = MonitoredResource.newBuilder((String)this.config.resource.type);
        if (this.config.resource.label != null) {
            this.config.resource.label.forEach((arg_0, arg_1) -> ((MonitoredResource.Builder)b).addLabel(arg_0, arg_1));
        }
        return b.build();
    }

    private boolean initLogger() {
        ArcContainer container = Arc.container();
        if (container != null) {
            this.log = (Logging)container.instance(Logging.class, new Annotation[0]).get();
            return true;
        }
        return false;
    }
}

