/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.opentelemetry.exporter.gcp.runtime.graal;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.ChannelPrimer;
import com.google.api.gax.grpc.GrpcHeaderInterceptor;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.quarkiverse.opentelemetry.exporter.gcp.runtime.graal.GrpcChannelUUIDInterceptorTarget;
import io.quarkiverse.opentelemetry.exporter.gcp.runtime.graal.GrpcMetadataHandlerInterceptorTarget;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.threeten.bp.Duration;

@TargetClass(value=InstantiatingGrpcChannelProvider.class)
final class InstantiatingGrpcChannelProviderSubstitutions {
    @Alias
    private Executor executor;
    @Alias
    private HeaderProvider headerProvider;
    @Alias
    private GrpcInterceptorProvider interceptorProvider;
    @Alias
    private String endpoint;
    @Alias
    private Integer maxInboundMessageSize;
    @Alias
    private Integer maxInboundMetadataSize;
    @Alias
    private Duration keepAliveTime;
    @Alias
    private Duration keepAliveTimeout;
    @Alias
    private Boolean keepAliveWithoutCalls;
    @Alias
    private ChannelPrimer channelPrimer;
    @Alias
    private ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;

    InstantiatingGrpcChannelProviderSubstitutions() {
    }

    @Substitute
    private ManagedChannel createSingleChannel() throws IOException {
        ChannelCredentials channelCredentials;
        GrpcHeaderInterceptor headerInterceptor = new GrpcHeaderInterceptor(this.headerProvider.getHeaders());
        GrpcMetadataHandlerInterceptorTarget metadataHandlerInterceptor = new GrpcMetadataHandlerInterceptorTarget();
        int colon = this.endpoint.lastIndexOf(58);
        if (colon < 0) {
            throw new IllegalStateException("invalid endpoint - should have been validated: " + this.endpoint);
        }
        int port = Integer.parseInt(this.endpoint.substring(colon + 1));
        String serviceAddress = this.endpoint.substring(0, colon);
        try {
            channelCredentials = this.createMtlsChannelCredentials();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        ManagedChannelBuilder builder = channelCredentials != null ? Grpc.newChannelBuilder((String)this.endpoint, (ChannelCredentials)channelCredentials) : ManagedChannelBuilder.forAddress((String)serviceAddress, (int)port);
        builder.disableServiceConfigLookUp();
        builder = builder.intercept(new ClientInterceptor[]{new GrpcChannelUUIDInterceptorTarget()}).intercept(new ClientInterceptor[]{headerInterceptor}).intercept(new ClientInterceptor[]{metadataHandlerInterceptor}).userAgent(headerInterceptor.getUserAgentHeader()).executor(this.executor);
        if (this.maxInboundMetadataSize != null) {
            builder.maxInboundMetadataSize(this.maxInboundMetadataSize.intValue());
        }
        if (this.maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(this.maxInboundMessageSize.intValue());
        }
        if (this.keepAliveTime != null) {
            builder.keepAliveTime(this.keepAliveTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveTimeout != null) {
            builder.keepAliveTimeout(this.keepAliveTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveWithoutCalls != null) {
            builder.keepAliveWithoutCalls(this.keepAliveWithoutCalls.booleanValue());
        }
        if (this.interceptorProvider != null) {
            builder.intercept(this.interceptorProvider.getInterceptors());
        }
        if (this.channelConfigurator != null) {
            builder = (ManagedChannelBuilder)this.channelConfigurator.apply((Object)builder);
        }
        ManagedChannel managedChannel = builder.build();
        if (this.channelPrimer != null) {
            this.channelPrimer.primeChannel(managedChannel);
        }
        return managedChannel;
    }

    @Alias
    ChannelCredentials createMtlsChannelCredentials() throws IOException, GeneralSecurityException {
        throw new UnsupportedOperationException();
    }
}

