/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.CRDUtils;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.Version;
import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OperatorProducer {
    private static final Logger log = LoggerFactory.getLogger(OperatorProducer.class);

    @Produces
    @DefaultBean
    @ApplicationScoped
    Operator operator(QuarkusConfigurationService configuration, Instance<Reconciler<? extends HasMetadata>> reconcilers) {
        CRDGenerationInfo crdInfo;
        if (configuration.getVersion() instanceof Version) {
            Version version = (Version)configuration.getVersion();
            log.info("Quarkus Java Operator SDK extension {}", (Object)version.getExtensionCompleteVersion());
        }
        if ((crdInfo = configuration.getCRDGenerationInfo()).isApplyCRDs()) {
            for (String generatedCrdName : crdInfo.getGenerated()) {
                CRDUtils.applyCRD(configuration.getKubernetesClient(), crdInfo, generatedCrdName);
            }
        }
        Operator operator = new Operator((ConfigurationService)configuration);
        for (Reconciler reconciler : reconcilers) {
            operator.register(reconciler);
        }
        return operator;
    }
}

