/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.CustomAlterableContexts;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.Collection;
import org.jboss.logging.Logger;

class CustomAlterableContextsGenerator
extends AbstractGenerator {
    private static final Logger LOGGER = Logger.getLogger(CustomAlterableContextsGenerator.class);

    CustomAlterableContextsGenerator(boolean generateSources) {
        super(generateSources);
    }

    Collection<ResourceOutput.Resource> generate(CustomAlterableContexts.CustomAlterableContextInfo info) {
        ResourceClassOutput classOutput = new ResourceClassOutput(info.isApplicationClass, this.generateSources);
        this.createInjectableContextSubclass(classOutput, info);
        return classOutput.getResources();
    }

    private void createInjectableContextSubclass(ClassOutput classOutput, CustomAlterableContexts.CustomAlterableContextInfo info) {
        String generatedName = info.generatedName.replace('.', '/');
        ClassCreator injectableContextSubclass = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(info.contextClass).interfaces(new Class[]{InjectableContext.class}).build();
        MethodCreator constructor = injectableContextSubclass.getMethodCreator("<init>", Void.TYPE, new Class[0]);
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(info.contextClass, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
        constructor.returnVoid();
        if (info.isNormal != null) {
            MethodCreator isNormal = injectableContextSubclass.getMethodCreator("isNormal", Boolean.TYPE, new Class[0]);
            isNormal.returnBoolean(info.isNormal.booleanValue());
        }
        MethodCreator destroy = injectableContextSubclass.getMethodCreator("destroy", Void.TYPE, new Class[0]);
        destroy.throwException(UnsupportedOperationException.class, "Custom AlterableContext cannot destroy all instances");
        destroy.returnVoid();
        MethodCreator getState = injectableContextSubclass.getMethodCreator("getState", InjectableContext.ContextState.class, new Class[0]);
        getState.throwException(UnsupportedOperationException.class, "Custom AlterableContext has no state");
        getState.returnNull();
        MethodCreator destroyState = injectableContextSubclass.getMethodCreator("destroy", Void.TYPE, new Class[]{InjectableContext.ContextState.class});
        destroyState.throwException(UnsupportedOperationException.class, "Custom AlterableContext has no state");
        destroyState.returnVoid();
        injectableContextSubclass.close();
        LOGGER.debugf("InjectableContext subclass generated: %s", (Object)info.generatedName);
    }
}

