/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.KotlinDotNames;
import java.lang.reflect.Modifier;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class KotlinUtils {
    public static boolean isKotlinClass(ClassInfo clazz) {
        return clazz.hasDeclaredAnnotation(KotlinDotNames.METADATA);
    }

    public static boolean isKotlinMethod(MethodInfo method) {
        return KotlinUtils.isKotlinClass(method.declaringClass());
    }

    public static boolean isKotlinSuspendMethod(MethodInfo method) {
        if (!KotlinUtils.isKotlinMethod(method)) {
            return false;
        }
        if (method.parametersCount() == 0) {
            return false;
        }
        Type lastParameter = method.parameterType(method.parametersCount() - 1);
        return KotlinDotNames.CONTINUATION.equals((Object)lastParameter.name());
    }

    public static boolean isKotlinContinuationParameter(MethodParameterInfo parameter) {
        return KotlinUtils.isKotlinSuspendMethod(parameter.method()) && KotlinDotNames.CONTINUATION.equals((Object)parameter.type().name());
    }

    public static boolean isNoninterceptableKotlinMethod(MethodInfo method) {
        return KotlinUtils.isKotlinSuspendMethod(method) && (Modifier.isFinal(method.flags()) || Modifier.isFinal(method.declaringClass().flags()));
    }

    public static Type getKotlinSuspendMethodResult(MethodInfo method) {
        if (!KotlinUtils.isKotlinSuspendMethod(method)) {
            throw new IllegalArgumentException("Not a suspend function: " + method);
        }
        Type lastParameter = method.parameterType(method.parametersCount() - 1);
        if (lastParameter.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            throw new IllegalArgumentException("Continuation parameter type not parameterized: " + lastParameter);
        }
        Type resultType = (Type)lastParameter.asParameterizedType().arguments().get(0);
        if (resultType.kind() != Type.Kind.WILDCARD_TYPE) {
            throw new IllegalArgumentException("Continuation parameter type argument not wildcard: " + resultType);
        }
        Type lowerBound = resultType.asWildcardType().superBound();
        if (lowerBound == null) {
            throw new IllegalArgumentException("Continuation parameter type argument without lower bound: " + resultType);
        }
        return lowerBound;
    }
}

