/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.dynamodb.runtime;

import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.NettyHttpClientConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.dynamodb.runtime.DynamodbClientProducer;
import io.quarkus.amazon.dynamodb.runtime.DynamodbConfig;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

@Recorder
public class DynamodbRecorder {
    public RuntimeValue<SyncHttpClientConfig> getSyncConfig(DynamodbConfig config) {
        return new RuntimeValue((Object)config.syncClient);
    }

    public RuntimeValue<NettyHttpClientConfig> getAsyncConfig(DynamodbConfig config) {
        return new RuntimeValue((Object)config.asyncClient);
    }

    public RuntimeValue<AwsConfig> getAwsConfig(DynamodbConfig config) {
        return new RuntimeValue((Object)config.aws);
    }

    public RuntimeValue<SdkConfig> getSdkConfig(DynamodbConfig config) {
        return new RuntimeValue((Object)config.sdk);
    }

    public RuntimeValue<AwsClientBuilder> createSyncBuilder(DynamodbConfig config, RuntimeValue<SdkHttpClient.Builder> transport) {
        DynamoDbClientBuilder builder = DynamoDbClient.builder();
        builder.endpointDiscoveryEnabled(config.enableEndpointDiscovery);
        if (transport != null) {
            builder.httpClientBuilder((SdkHttpClient.Builder)transport.getValue());
        }
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<AwsClientBuilder> createAsyncBuilder(DynamodbConfig config, RuntimeValue<SdkAsyncHttpClient.Builder> transport) {
        DynamoDbAsyncClientBuilder builder = DynamoDbAsyncClient.builder();
        builder.endpointDiscoveryEnabled(config.enableEndpointDiscovery);
        if (transport != null) {
            builder.httpClientBuilder((SdkAsyncHttpClient.Builder)transport.getValue());
        }
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<DynamoDbClient> buildClient(RuntimeValue<? extends AwsClientBuilder> builder, BeanContainer beanContainer, ShutdownContext shutdown) {
        DynamodbClientProducer producer = (DynamodbClientProducer)beanContainer.instance(DynamodbClientProducer.class, new Annotation[0]);
        producer.setSyncConfiguredBuilder((DynamoDbClientBuilder)builder.getValue());
        shutdown.addShutdownTask(producer::destroy);
        return new RuntimeValue((Object)producer.client());
    }

    public RuntimeValue<DynamoDbAsyncClient> buildAsyncClient(RuntimeValue<? extends AwsClientBuilder> builder, BeanContainer beanContainer, ShutdownContext shutdown) {
        DynamodbClientProducer producer = (DynamodbClientProducer)beanContainer.instance(DynamodbClientProducer.class, new Annotation[0]);
        producer.setAsyncConfiguredBuilder((DynamoDbAsyncClientBuilder)builder.getValue());
        shutdown.addShutdownTask(producer::destroy);
        return new RuntimeValue((Object)producer.asyncClient());
    }
}

