/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arquillian;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;

public class QuarkusTestNgCallbacks {
    private static final String ARQ_TESTNG_SUPERCLASS = "org.jboss.arquillian.testng.Arquillian";

    static void invokeTestNgBeforeClasses(Object testInstance) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        if (testInstance != null) {
            ArrayList<Method> beforeClasses = new ArrayList<Method>();
            QuarkusTestNgCallbacks.collectCallbacks(testInstance.getClass(), beforeClasses, testInstance.getClass().getClassLoader().loadClass(BeforeClass.class.getName()));
            for (Method m : beforeClasses) {
                if (m.getParameterCount() != 0) continue;
                m.setAccessible(true);
                m.invoke(testInstance, new Object[0]);
            }
        }
    }

    static void invokeTestNgAfterClasses(Object testInstance) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        if (testInstance != null) {
            ArrayList<Method> afterClasses = new ArrayList<Method>();
            QuarkusTestNgCallbacks.collectCallbacks(testInstance.getClass(), afterClasses, testInstance.getClass().getClassLoader().loadClass(AfterClass.class.getName()));
            for (Method m : afterClasses) {
                if (m.getParameterCount() != 0) continue;
                m.setAccessible(true);
                m.invoke(testInstance, new Object[0]);
            }
        }
    }

    static void invokeTestNgAfterMethods(Object testInstance) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        if (testInstance != null) {
            ArrayList<Method> afterMethods = new ArrayList<Method>();
            QuarkusTestNgCallbacks.collectCallbacks(testInstance.getClass(), afterMethods, testInstance.getClass().getClassLoader().loadClass(AfterMethod.class.getName()));
            QuarkusTestNgCallbacks.collectCallbacks(testInstance.getClass(), afterMethods, testInstance.getClass().getClassLoader().loadClass(AfterTest.class.getName()));
            for (Method m : afterMethods) {
                if (m.getParameterCount() != 0) continue;
                m.setAccessible(true);
                m.invoke(testInstance, new Object[0]);
            }
        }
    }

    static void invokeTestNgBeforeMethods(Object testInstance) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        if (testInstance != null) {
            ArrayList<Method> beforeMethods = new ArrayList<Method>();
            QuarkusTestNgCallbacks.collectCallbacks(testInstance.getClass(), beforeMethods, testInstance.getClass().getClassLoader().loadClass(BeforeMethod.class.getName()));
            QuarkusTestNgCallbacks.collectCallbacks(testInstance.getClass(), beforeMethods, testInstance.getClass().getClassLoader().loadClass(BeforeTest.class.getName()));
            for (Method m : beforeMethods) {
                if (m.getParameterCount() != 0) continue;
                m.setAccessible(true);
                m.invoke(testInstance, new Object[0]);
            }
        }
    }

    private static void collectCallbacks(Class<?> testClass, List<Method> callbacks, Class<? extends Annotation> annotation) {
        for (Method m : testClass.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            QuarkusTestNgCallbacks.addIfNotPresent(callbacks, m);
        }
        Class<?> superClass = testClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class) && !superClass.toString().contains(ARQ_TESTNG_SUPERCLASS)) {
            QuarkusTestNgCallbacks.collectCallbacks(superClass, callbacks, annotation);
        }
    }

    private static boolean addIfNotPresent(List<Method> callbacks, Method candidateMethod) {
        if (callbacks.isEmpty()) {
            return callbacks.add(candidateMethod);
        }
        for (Method m : callbacks) {
            if (!m.getName().equals(candidateMethod.getName()) || m.getParameterCount() != candidateMethod.getParameterCount()) continue;
            return false;
        }
        return callbacks.add(candidateMethod);
    }
}

