/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.BootstrapArtifactVersion;
import io.quarkus.bootstrap.resolver.maven.BootstrapArtifactVersionConstraint;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.DependencyLoggingConfig;
import io.quarkus.bootstrap.resolver.maven.DeploymentInjectionException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTaskRunner;
import io.quarkus.bootstrap.resolver.maven.SimpleDependencyGraphTransformationContext;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathTree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiConsumer;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.transformer.ConflictIdSorter;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.jboss.logging.Logger;

public class IncubatingApplicationModelResolver {
    private static final Logger log = Logger.getLogger(IncubatingApplicationModelResolver.class);
    private static final String QUARKUS_RUNTIME_ARTIFACT = "quarkus.runtime";
    private static final String QUARKUS_EXTENSION_DEPENDENCY = "quarkus.ext";
    private static final String INCUBATING_MODEL_RESOLVER = "quarkus.bootstrap.incubating-model-resolver";
    private static final byte COLLECT_TOP_EXTENSION_RUNTIME_NODES = 1;
    private static final byte COLLECT_DIRECT_DEPS = 2;
    private static final byte COLLECT_RELOADABLE_MODULES = 4;
    private static final Artifact[] NO_ARTIFACTS = new Artifact[0];
    private final ExtensionInfo EXT_INFO_NONE = new ExtensionInfo();
    private final List<ExtensionDependency> topExtensionDeps = new ArrayList<ExtensionDependency>();
    private final Map<ArtifactKey, ExtensionInfo> allExtensions = new ConcurrentHashMap<ArtifactKey, ExtensionInfo>();
    private Collection<ConditionalDependency> conditionalDepsToProcess = new ConcurrentLinkedDeque<ConditionalDependency>();
    private MavenArtifactResolver resolver;
    private List<Dependency> managedDeps;
    private ApplicationModelBuilder appBuilder;
    private boolean collectReloadableModules;
    private DependencyLoggingConfig depLogging;
    private List<Dependency> collectCompileOnly;
    private boolean runtimeModelOnly;

    public static boolean isIncubatingEnabled(Properties projectProperties) {
        return Boolean.parseBoolean(IncubatingApplicationModelResolver.getIncubatingModelResolverProperty(projectProperties));
    }

    public static boolean isIncubatingModelResolverProperty(Properties projectProperties, String value) {
        Objects.requireNonNull(value);
        return value.equals(IncubatingApplicationModelResolver.getIncubatingModelResolverProperty(projectProperties));
    }

    public static String getIncubatingModelResolverProperty(Properties projectProperties) {
        String value = System.getProperty(INCUBATING_MODEL_RESOLVER);
        if (value != null || projectProperties == null) {
            return value;
        }
        return String.valueOf(projectProperties.get(INCUBATING_MODEL_RESOLVER));
    }

    public static IncubatingApplicationModelResolver newInstance() {
        return new IncubatingApplicationModelResolver();
    }

    public IncubatingApplicationModelResolver setArtifactResolver(MavenArtifactResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public IncubatingApplicationModelResolver setApplicationModelBuilder(ApplicationModelBuilder appBuilder) {
        this.appBuilder = appBuilder;
        return this;
    }

    public IncubatingApplicationModelResolver setCollectReloadableModules(boolean collectReloadableModules) {
        this.collectReloadableModules = collectReloadableModules;
        return this;
    }

    public IncubatingApplicationModelResolver setDependencyLogging(DependencyLoggingConfig depLogging) {
        this.depLogging = depLogging;
        return this;
    }

    public IncubatingApplicationModelResolver setCollectCompileOnly(List<Dependency> collectCompileOnly) {
        this.collectCompileOnly = collectCompileOnly;
        return this;
    }

    public IncubatingApplicationModelResolver setRuntimeModelOnly(boolean runtimeModelOnly) {
        this.runtimeModelOnly = runtimeModelOnly;
        return this;
    }

    public void resolve(CollectRequest collectRtDepsRequest) throws AppModelResolverException {
        this.managedDeps = collectRtDepsRequest.getManagedDependencies();
        this.collectPlatformProperties();
        this.managedDeps = this.managedDeps.isEmpty() ? new ArrayList() : this.managedDeps;
        DependencyNode root = this.resolveRuntimeDeps(collectRtDepsRequest);
        this.processRuntimeDeps(root);
        List<ConditionalDependency> activatedConditionalDeps = this.activateConditionalDeps();
        if (!this.runtimeModelOnly) {
            this.injectDeployment(activatedConditionalDeps);
        }
        root = this.normalize(this.resolver.getSession(), root);
        this.populateModelBuilder(root);
        for (ResolvedDependencyBuilder d : this.appBuilder.getDependencies()) {
            if (d.isFlagSet(64) || d.isFlagSet(2048)) continue;
            this.clearReloadableFlag(d);
        }
        for (ResolvedDependencyBuilder d : this.appBuilder.getDependencies()) {
            d.clearFlag(2048);
            if (d.isFlagSet(64)) {
                this.appBuilder.addReloadableWorkspaceModule(d.getKey());
            }
            if (this.runtimeModelOnly) continue;
            d.setFlags(8);
        }
        if (!this.runtimeModelOnly) {
            this.collectCompileOnly(collectRtDepsRequest, root);
        }
    }

    private List<ConditionalDependency> activateConditionalDeps() {
        if (this.conditionalDepsToProcess.isEmpty()) {
            return List.of();
        }
        ArrayList<ConditionalDependency> activatedConditionalDeps = new ArrayList<ConditionalDependency>();
        boolean checkDependencyConditions = true;
        while (!this.conditionalDepsToProcess.isEmpty() && checkDependencyConditions) {
            checkDependencyConditions = false;
            Collection<ConditionalDependency> unsatisfiedConditionalDeps = this.conditionalDepsToProcess;
            this.conditionalDepsToProcess = new ConcurrentLinkedDeque<ConditionalDependency>();
            for (ConditionalDependency cd : unsatisfiedConditionalDeps) {
                if (cd.isSatisfied()) {
                    cd.activate();
                    activatedConditionalDeps.add(cd);
                    checkDependencyConditions = true;
                    continue;
                }
                this.conditionalDepsToProcess.add(cd);
            }
        }
        return activatedConditionalDeps;
    }

    private void populateModelBuilder(DependencyNode root) {
        AppDep app = new AppDep(root);
        ModelResolutionTaskRunner taskRunner = new ModelResolutionTaskRunner();
        app.scheduleChildVisits(taskRunner, AppDep::scheduleDeploymentVisit);
        taskRunner.waitForCompletion();
        this.appBuilder.getApplicationArtifact().addDependencies(app.allDeps);
        for (AppDep d : app.children) {
            d.addToModel();
        }
        if (this.depLogging != null) {
            new AppDepLogger().log(app);
        }
    }

    private void injectDeployment(List<ConditionalDependency> activatedConditionalDeps) {
        ConcurrentLinkedDeque<Runnable> injectQueue = new ConcurrentLinkedDeque<Runnable>();
        this.collectDeploymentDeps(injectQueue);
        if (!activatedConditionalDeps.isEmpty()) {
            this.collectConditionalDeploymentDeps(activatedConditionalDeps, injectQueue);
        }
        for (Runnable inject : injectQueue) {
            inject.run();
        }
    }

    private void collectConditionalDeploymentDeps(List<ConditionalDependency> activatedConditionalDeps, ConcurrentLinkedDeque<Runnable> injectQueue) {
        ModelResolutionTaskRunner taskRunner = new ModelResolutionTaskRunner();
        for (ConditionalDependency cd : activatedConditionalDeps) {
            this.injectDeploymentDep(taskRunner, cd.getExtensionDependency(), injectQueue, true);
        }
        taskRunner.waitForCompletion();
    }

    private void collectDeploymentDeps(ConcurrentLinkedDeque<Runnable> injectQueue) {
        ModelResolutionTaskRunner taskRunner = new ModelResolutionTaskRunner();
        for (ExtensionDependency extDep : this.topExtensionDeps) {
            this.injectDeploymentDep(taskRunner, extDep, injectQueue, false);
        }
        taskRunner.waitForCompletion();
    }

    private void injectDeploymentDep(ModelResolutionTaskRunner taskRunner, ExtensionDependency extDep, ConcurrentLinkedDeque<Runnable> injectQueue, boolean conditionalDep) {
        taskRunner.run(() -> {
            ResolvedDependencyBuilder resolvedDep = this.appBuilder.getDependency(DependencyUtils.getKey(extDep.info.deploymentArtifact));
            if (resolvedDep == null) {
                extDep.collectDeploymentDeps();
                injectQueue.add(() -> extDep.injectDeploymentNode(conditionalDep ? extDep.getParentDeploymentNode() : null));
            } else {
                resolvedDep.clearFlag(64);
            }
        });
    }

    private void collectCompileOnly(CollectRequest collectRtDepsRequest, DependencyNode root) throws BootstrapMavenException {
        if (this.collectCompileOnly.isEmpty()) {
            return;
        }
        ArrayDeque<List> depStack = new ArrayDeque<List>();
        List children = root.getChildren();
        while (children != null) {
            for (DependencyNode node : children) {
                this.managedDeps.add(node.getDependency());
                if (node.getChildren().isEmpty()) continue;
                depStack.add(node.getChildren());
            }
            children = (List)depStack.poll();
        }
        CollectRequest request = new CollectRequest().setDependencies(this.collectCompileOnly).setManagedDependencies(this.managedDeps).setRepositories(collectRtDepsRequest.getRepositories());
        if (collectRtDepsRequest.getRoot() != null) {
            request.setRoot(collectRtDepsRequest.getRoot());
        } else {
            request.setRootArtifact(collectRtDepsRequest.getRootArtifact());
        }
        try {
            root = this.resolver.getSystem().collectDependencies(this.resolver.getSession(), request).getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new BootstrapDependencyProcessingException("Failed to collect compile-only dependencies of " + root.getArtifact(), e);
        }
        children = root.getChildren();
        int flags = 4098;
        while (children != null) {
            for (DependencyNode node : children) {
                if (DependencyUtils.hasWinner(node)) continue;
                ExtensionInfo extInfo = this.getExtensionInfoOrNull(node.getArtifact(), node.getRepositories());
                ResolvedDependencyBuilder dep = this.appBuilder.getDependency(DependencyUtils.getKey(node.getArtifact()));
                if (dep == null) {
                    dep = (ResolvedDependencyBuilder)DependencyUtils.newDependencyBuilder(node, this.resolver).setFlags(flags);
                    if (extInfo != null) {
                        dep.setFlags(16);
                        if (dep.isFlagSet(2)) {
                            dep.setFlags(128);
                        }
                    }
                    this.appBuilder.addDependency(dep);
                } else {
                    dep.setFlags(4096);
                }
                if (node.getChildren().isEmpty()) continue;
                depStack.add(node.getChildren());
            }
            flags = 4096;
            children = (List)depStack.poll();
        }
    }

    private void collectPlatformProperties() throws AppModelResolverException {
        PlatformImportsImpl platformReleases = new PlatformImportsImpl();
        for (Dependency d : this.managedDeps) {
            Artifact artifact = d.getArtifact();
            String extension = artifact.getExtension();
            if ("json".equals(extension) && artifact.getArtifactId().endsWith("-quarkus-platform-descriptor")) {
                platformReleases.addPlatformDescriptor(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), extension, artifact.getVersion());
                continue;
            }
            if (!"properties".equals(extension) || !artifact.getArtifactId().endsWith("-quarkus-platform-properties")) continue;
            platformReleases.addPlatformProperties(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), extension, artifact.getVersion(), this.resolver.resolve(artifact).getArtifact().getFile().toPath());
        }
        this.appBuilder.setPlatformImports((PlatformImports)platformReleases);
    }

    private void clearReloadableFlag(ResolvedDependencyBuilder dep) {
        Collection deps = dep.getDependencies();
        if (deps.isEmpty()) {
            return;
        }
        for (ArtifactCoords coords : deps) {
            ResolvedDependencyBuilder child = this.appBuilder.getDependency(coords.getKey());
            if (child == null || child.isFlagSet(2048)) continue;
            child.setFlags(2048);
            child.clearFlag(64);
            this.clearReloadableFlag(child);
        }
    }

    private DependencyNode normalize(RepositorySystemSession session, DependencyNode root) throws AppModelResolverException {
        SimpleDependencyGraphTransformationContext context = new SimpleDependencyGraphTransformationContext(session);
        try {
            root = new ConflictIdSorter().transformGraph(root, (DependencyGraphTransformationContext)context);
            return session.getDependencyGraphTransformer().transformGraph(root, (DependencyGraphTransformationContext)context);
        }
        catch (RepositoryException e) {
            throw new AppModelResolverException("Failed to resolve dependency graph conflicts", (Throwable)e);
        }
    }

    private DependencyNode resolveRuntimeDeps(CollectRequest request) throws AppModelResolverException {
        boolean verbose = true;
        if (verbose) {
            RepositorySystemSession session = this.resolver.getSession();
            DefaultRepositorySystemSession mutableSession = new DefaultRepositorySystemSession(this.resolver.getSession());
            mutableSession.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
            mutableSession.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
            session = mutableSession;
            BootstrapMavenContext ctx = new BootstrapMavenContext((BootstrapMavenContextConfig<?>)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)BootstrapMavenContext.config().setRepositorySystem(this.resolver.getSystem())).setRepositorySystemSession(session)).setRemoteRepositories(this.resolver.getRepositories())).setRemoteRepositoryManager(this.resolver.getRemoteRepositoryManager())).setCurrentProject(this.resolver.getMavenContext().getCurrentProject())).setWorkspaceDiscovery(this.collectReloadableModules));
            this.resolver = new MavenArtifactResolver(ctx);
        }
        try {
            return this.resolver.getSystem().collectDependencies(this.resolver.getSession(), request).getRoot();
        }
        catch (DependencyCollectionException e) {
            Artifact a = request.getRoot() == null ? request.getRootArtifact() : request.getRoot().getArtifact();
            throw new BootstrapMavenException("Failed to resolve dependencies for " + a, e);
        }
    }

    private boolean isRuntimeArtifact(ArtifactKey key) {
        ResolvedDependencyBuilder dep = this.appBuilder.getDependency(key);
        return dep != null && dep.isFlagSet(4);
    }

    private void processRuntimeDeps(DependencyNode root) {
        AppDep appRoot = new AppDep(root);
        appRoot.walkingFlags = (byte)3;
        if (this.collectReloadableModules) {
            appRoot.walkingFlags = (byte)(appRoot.walkingFlags | 4);
        }
        this.visitRuntimeDeps(appRoot);
        this.appBuilder.getApplicationArtifact().addDependencies(appRoot.allDeps);
        appRoot.setChildFlags();
    }

    private void visitRuntimeDeps(AppDep appRoot) {
        ModelResolutionTaskRunner taskRunner = new ModelResolutionTaskRunner();
        appRoot.scheduleChildVisits(taskRunner, AppDep::scheduleRuntimeVisit);
        taskRunner.waitForCompletion();
    }

    private ExtensionInfo getExtensionInfoOrNull(Artifact artifact, List<RemoteRepository> repos) throws BootstrapDependencyProcessingException {
        if (!artifact.getExtension().equals("jar")) {
            return null;
        }
        ArtifactKey extKey = DependencyUtils.getKey(artifact);
        ExtensionInfo ext = this.allExtensions.get(extKey);
        if (ext != null) {
            return ext == this.EXT_INFO_NONE ? null : ext;
        }
        Path path = (artifact = this.resolve(artifact, repos)).getFile().toPath();
        Properties descriptor = (Properties)PathTree.ofDirectoryOrArchive((Path)path).apply("META-INF/quarkus-extension.properties", visit -> {
            if (visit == null) {
                return null;
            }
            try {
                return IncubatingApplicationModelResolver.readDescriptor(visit.getPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        if (descriptor == null) {
            this.allExtensions.put(extKey, this.EXT_INFO_NONE);
            return null;
        }
        ext = new ExtensionInfo(artifact, descriptor);
        this.allExtensions.put(extKey, ext);
        return ext;
    }

    private DependencyNode collectDependencies(Artifact artifact, Collection<Exclusion> exclusions, List<RemoteRepository> repos) {
        DependencyNode root;
        try {
            root = this.resolver.getSystem().collectDependencies(this.resolver.getSession(), this.getCollectRequest(artifact, exclusions, repos)).getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new DeploymentInjectionException("Failed to collect dependencies for " + artifact, e);
        }
        if (root.getChildren().size() != 1) {
            throw new DeploymentInjectionException("Only one child expected but got " + root.getChildren());
        }
        return (DependencyNode)root.getChildren().get(0);
    }

    private CollectRequest getCollectRequest(Artifact artifact, Collection<Exclusion> exclusions, List<RemoteRepository> repos) {
        ArtifactDescriptorResult descr;
        try {
            descr = this.resolver.resolveDescriptor(artifact, repos);
        }
        catch (BootstrapMavenException e) {
            throw new DeploymentInjectionException("Failed to resolve descriptor for " + artifact, (Throwable)((Object)e));
        }
        ArrayList<Dependency> allConstraints = new ArrayList<Dependency>(this.managedDeps.size() + descr.getManagedDependencies().size());
        allConstraints.addAll(this.managedDeps);
        allConstraints.addAll(descr.getManagedDependencies());
        return new CollectRequest().setManagedDependencies(allConstraints).setRepositories(repos).setRootArtifact(artifact).setDependencies(List.of(new Dependency(artifact, "compile", Boolean.valueOf(false), exclusions)));
    }

    private Artifact resolve(Artifact artifact, List<RemoteRepository> repos) {
        if (artifact.getFile() != null) {
            return artifact;
        }
        try {
            return this.resolver.getSystem().resolveArtifact(this.resolver.getSession(), new ArtifactRequest().setArtifact(artifact).setRepositories(repos)).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new DeploymentInjectionException("Failed to resolve artifact " + artifact, e);
        }
    }

    private static Properties readDescriptor(Path path) throws IOException {
        Properties rtProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            rtProps.load(reader);
        }
        return rtProps;
    }

    private static boolean isSameKey(Artifact a1, Artifact a2) {
        return a2.getArtifactId().equals(a1.getArtifactId()) && a2.getGroupId().equals(a1.getGroupId()) && a2.getClassifier().equals(a1.getClassifier()) && a2.getExtension().equals(a1.getExtension());
    }

    private static String toCompactCoords(Artifact a) {
        StringBuilder b = new StringBuilder();
        b.append(a.getGroupId()).append(':').append(a.getArtifactId()).append(':');
        if (!a.getClassifier().isEmpty()) {
            b.append(a.getClassifier()).append(':');
        }
        if (!"jar".equals(a.getExtension())) {
            b.append(a.getExtension()).append(':');
        }
        b.append(a.getVersion());
        return b.toString();
    }

    private class ExtensionInfo {
        final Artifact runtimeArtifact;
        final Properties props;
        final Artifact deploymentArtifact;
        final Artifact[] conditionalDeps;
        final ArtifactKey[] dependencyCondition;
        boolean activated;

        private ExtensionInfo() {
            this.runtimeArtifact = null;
            this.props = null;
            this.deploymentArtifact = null;
            this.conditionalDeps = null;
            this.dependencyCondition = null;
        }

        ExtensionInfo(Artifact runtimeArtifact, Properties props) throws BootstrapDependencyProcessingException {
            this.runtimeArtifact = runtimeArtifact;
            this.props = props;
            String value = props.getProperty("deployment-artifact");
            if (value == null) {
                throw new BootstrapDependencyProcessingException("Extension descriptor from " + runtimeArtifact + " does not include deployment-artifact");
            }
            Artifact deploymentArtifact = DependencyUtils.toArtifact(value);
            if (deploymentArtifact.getVersion() == null || deploymentArtifact.getVersion().isEmpty()) {
                deploymentArtifact = deploymentArtifact.setVersion(runtimeArtifact.getVersion());
            }
            this.deploymentArtifact = deploymentArtifact;
            value = props.getProperty("conditional-dependencies");
            if (value != null) {
                String[] deps = BootstrapUtils.splitByWhitespace((String)value);
                this.conditionalDeps = new Artifact[deps.length];
                for (int i = 0; i < deps.length; ++i) {
                    try {
                        this.conditionalDeps[i] = DependencyUtils.toArtifact(deps[i]);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BootstrapDependencyProcessingException("Failed to parse conditional dependencies configuration of " + runtimeArtifact, e);
                    }
                }
            } else {
                this.conditionalDeps = NO_ARTIFACTS;
            }
            this.dependencyCondition = BootstrapUtils.parseDependencyCondition((String)props.getProperty("dependency-condition"));
        }

        void ensureActivated() {
            if (this.activated) {
                return;
            }
            this.activated = true;
            IncubatingApplicationModelResolver.this.appBuilder.handleExtensionProperties(this.props, this.runtimeArtifact.toString());
            String providesCapabilities = this.props.getProperty("provides-capabilities");
            String requiresCapabilities = this.props.getProperty("requires-capabilities");
            if (providesCapabilities != null || requiresCapabilities != null) {
                IncubatingApplicationModelResolver.this.appBuilder.addExtensionCapabilities((ExtensionCapabilities)CapabilityContract.of((String)IncubatingApplicationModelResolver.toCompactCoords(this.runtimeArtifact), (String)providesCapabilities, (String)requiresCapabilities));
            }
        }
    }

    private class ConditionalDependency {
        final AppDep conditionalDep;
        private boolean activated;

        private ConditionalDependency(ExtensionInfo info, AppDep parent) {
            DefaultDependencyNode rtNode = new DefaultDependencyNode(new Dependency(info.runtimeArtifact, "compile"));
            rtNode.setVersion((Version)new BootstrapArtifactVersion(info.runtimeArtifact.getVersion()));
            rtNode.setVersionConstraint((VersionConstraint)new BootstrapArtifactVersionConstraint(new BootstrapArtifactVersion(info.runtimeArtifact.getVersion())));
            rtNode.setRepositories(parent.ext.runtimeNode.getRepositories());
            this.conditionalDep = new AppDep(parent, (DependencyNode)rtNode);
            this.conditionalDep.ext = new ExtensionDependency(info, (DependencyNode)rtNode, parent.ext.exclusions);
        }

        ExtensionDependency getExtensionDependency() {
            return this.conditionalDep.ext;
        }

        void activate() {
            if (this.activated) {
                return;
            }
            this.activated = true;
            ExtensionDependency extDep = this.getExtensionDependency();
            DependencyNode originalNode = IncubatingApplicationModelResolver.this.collectDependencies(this.conditionalDep.ext.info.runtimeArtifact, extDep.exclusions, extDep.runtimeNode.getRepositories());
            DefaultDependencyNode rtNode = (DefaultDependencyNode)extDep.runtimeNode;
            rtNode.setRepositories(originalNode.getRepositories());
            List currentChildren = rtNode.getChildren();
            if (currentChildren == null || currentChildren.isEmpty()) {
                rtNode.setChildren(originalNode.getChildren());
            } else {
                currentChildren.addAll(originalNode.getChildren());
            }
            if (IncubatingApplicationModelResolver.this.collectReloadableModules) {
                this.conditionalDep.walkingFlags = (byte)(this.conditionalDep.walkingFlags | 4);
            }
            ModelResolutionTaskRunner taskRunner = new ModelResolutionTaskRunner();
            this.conditionalDep.scheduleRuntimeVisit(taskRunner);
            taskRunner.waitForCompletion();
            this.conditionalDep.setFlags(this.conditionalDep.walkingFlags);
            if (this.conditionalDep.parent.resolvedDep == null) {
                this.conditionalDep.parent.allDeps.add(this.conditionalDep.resolvedDep.getArtifactCoords());
            } else {
                this.conditionalDep.parent.resolvedDep.addDependency(this.conditionalDep.resolvedDep.getArtifactCoords());
            }
            this.conditionalDep.parent.ext.runtimeNode.getChildren().add(rtNode);
        }

        boolean isSatisfied() {
            if (this.conditionalDep.ext.info.dependencyCondition == null) {
                return true;
            }
            for (ArtifactKey key : this.conditionalDep.ext.info.dependencyCondition) {
                if (IncubatingApplicationModelResolver.this.isRuntimeArtifact(key)) continue;
                return false;
            }
            return true;
        }
    }

    private class AppDep {
        final AppDep parent;
        final DependencyNode node;
        ExtensionDependency ext;
        byte walkingFlags;
        ResolvedDependencyBuilder resolvedDep;
        final List<AppDep> children;
        final List<ArtifactCoords> allDeps;

        AppDep(DependencyNode node) {
            this.parent = null;
            this.node = node;
            this.children = new ArrayList<AppDep>(node.getChildren().size());
            this.allDeps = new ArrayList<ArtifactCoords>(node.getChildren().size());
        }

        AppDep(AppDep parent, DependencyNode node) {
            this.parent = parent;
            this.node = node;
            this.children = new ArrayList<AppDep>(node.getChildren().size());
            this.allDeps = new ArrayList<ArtifactCoords>(node.getChildren().size());
        }

        void addToModel() {
            for (AppDep child : this.children) {
                child.addToModel();
            }
            if (this.resolvedDep != null) {
                this.resolvedDep.addDependencies(this.allDeps);
                IncubatingApplicationModelResolver.this.appBuilder.addDependency(this.resolvedDep);
            }
        }

        void scheduleDeploymentVisit(ModelResolutionTaskRunner taskRunner) {
            taskRunner.run(this::visitDeploymentDependency);
            this.scheduleChildVisits(taskRunner, AppDep::scheduleDeploymentVisit);
        }

        void visitDeploymentDependency() {
            if (!IncubatingApplicationModelResolver.this.appBuilder.hasDependency(DependencyUtils.getKey(this.node.getArtifact()))) {
                try {
                    this.resolvedDep = DependencyUtils.newDependencyBuilder(this.node, IncubatingApplicationModelResolver.this.resolver);
                }
                catch (BootstrapMavenException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        }

        void scheduleRuntimeVisit(ModelResolutionTaskRunner taskRunner) {
            taskRunner.run(this::visitRuntimeDependency);
            this.scheduleChildVisits(taskRunner, AppDep::scheduleRuntimeVisit);
        }

        void visitRuntimeDependency() {
            Artifact artifact = this.node.getArtifact();
            ArtifactKey key = DependencyUtils.getKey(artifact);
            if (this.resolvedDep == null) {
                this.resolvedDep = IncubatingApplicationModelResolver.this.appBuilder.getDependency(key);
            }
            if (!this.node.getRelocations().isEmpty()) {
                ((DefaultDependencyNode)this.node).setRelocations(List.of());
            }
            try {
                ExtensionDependency ext = this.getExtensionDependencyOrNull();
                if (this.resolvedDep == null) {
                    WorkspaceModule module = null;
                    if (IncubatingApplicationModelResolver.this.resolver.getProjectModuleResolver() != null) {
                        module = IncubatingApplicationModelResolver.this.resolver.getProjectModuleResolver().getProjectModule(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                    }
                    this.resolvedDep = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)DependencyUtils.toAppArtifact(this.getResolvedArtifact(), module).setOptional(this.node.getDependency().isOptional())).setScope(this.node.getDependency().getScope())).setRuntimeCp()).setDeploymentCp();
                    if ("provided".equals(this.resolvedDep.getScope())) {
                        this.resolvedDep.setFlags(4096);
                    }
                    if (ext != null) {
                        this.resolvedDep.setRuntimeExtensionArtifact();
                        this.collectConditionalDependencies();
                    }
                }
            }
            catch (DeploymentInjectionException e) {
                throw e;
            }
            catch (Exception t) {
                throw new DeploymentInjectionException("Failed to inject extension deployment dependencies", t);
            }
        }

        void scheduleChildVisits(ModelResolutionTaskRunner taskRunner, BiConsumer<AppDep, ModelResolutionTaskRunner> childVisitor) {
            List childNodes = this.node.getChildren();
            ArrayList<DependencyNode> filtered = null;
            for (int i = 0; i < childNodes.size(); ++i) {
                DependencyNode childNode = (DependencyNode)childNodes.get(i);
                DependencyNode winner = DependencyUtils.getWinner(childNode);
                if (winner == null) {
                    this.allDeps.add(DependencyUtils.getCoords(childNode.getArtifact()));
                    AppDep child = new AppDep(this, childNode);
                    this.children.add(child);
                    if (filtered == null) continue;
                    filtered.add(childNode);
                    continue;
                }
                this.allDeps.add(DependencyUtils.getCoords(winner.getArtifact()));
                if (filtered != null) continue;
                filtered = new ArrayList<DependencyNode>(childNodes.size());
                for (int j = 0; j < i; ++j) {
                    filtered.add((DependencyNode)childNodes.get(j));
                }
            }
            if (filtered != null) {
                this.node.setChildren(filtered);
            }
            for (AppDep child : this.children) {
                childVisitor.accept(child, taskRunner);
            }
        }

        void setChildFlags() {
            for (AppDep c : this.children) {
                c.setFlags(this.walkingFlags);
            }
        }

        void setFlags(byte walkingFlags) {
            ResolvedDependencyBuilder existingDep;
            this.resolvedDep.addDependencies(this.allDeps);
            if (this.ext != null) {
                AppDep parentExtDep = this.parent;
                while (parentExtDep != null) {
                    if (parentExtDep.ext != null) {
                        parentExtDep.ext.addExtensionDependency(this.ext);
                        break;
                    }
                    parentExtDep = parentExtDep.parent;
                }
                this.ext.info.ensureActivated();
            }
            if ((existingDep = IncubatingApplicationModelResolver.this.appBuilder.getDependency(this.resolvedDep.getKey())) == null) {
                IncubatingApplicationModelResolver.this.appBuilder.addDependency(this.resolvedDep);
                if (this.ext != null) {
                    IncubatingApplicationModelResolver.this.managedDeps.add(new Dependency(this.ext.info.deploymentArtifact, "compile"));
                }
            } else if (existingDep != this.resolvedDep) {
                throw new IllegalStateException(this.node.getArtifact() + " is already in the model");
            }
            this.walkingFlags = walkingFlags;
            this.resolvedDep.setDirect(this.isWalkingFlagOn((byte)2));
            if (this.ext != null && this.isWalkingFlagOn((byte)1)) {
                this.resolvedDep.setFlags(128);
                this.clearWalkingFlag((byte)1);
                IncubatingApplicationModelResolver.this.topExtensionDeps.add(this.ext);
            }
            if (this.isWalkingFlagOn((byte)4)) {
                if (this.resolvedDep.getWorkspaceModule() != null && !this.resolvedDep.isFlagSet(16)) {
                    this.resolvedDep.setReloadable();
                } else {
                    this.clearWalkingFlag((byte)4);
                }
            }
            this.clearWalkingFlag((byte)2);
            this.setChildFlags();
        }

        private ExtensionDependency getExtensionDependencyOrNull() throws BootstrapDependencyProcessingException {
            ExtensionInfo extInfo;
            if (this.ext != null) {
                return this.ext;
            }
            this.ext = ExtensionDependency.get(this.node);
            if (this.ext == null && (extInfo = IncubatingApplicationModelResolver.this.getExtensionInfoOrNull(this.node.getArtifact(), this.node.getRepositories())) != null) {
                this.ext = new ExtensionDependency(extInfo, this.node, this.collectExclusions());
            }
            return this.ext;
        }

        private Collection<Exclusion> collectExclusions() {
            if (this.parent == null) {
                return List.of();
            }
            ArrayList<Exclusion> exclusions = null;
            AppDep next = this;
            while (next != null) {
                Collection nextExcl;
                if (next.ext != null) {
                    if (exclusions == null) {
                        return next.ext.exclusions;
                    }
                    exclusions.addAll(next.ext.exclusions);
                    return exclusions;
                }
                Collection collection = nextExcl = next.node.getDependency() == null ? null : next.node.getDependency().getExclusions();
                if (nextExcl != null && !nextExcl.isEmpty() && exclusions == null) {
                    exclusions = new ArrayList<Exclusion>(nextExcl);
                }
                next = next.parent;
            }
            return exclusions == null ? List.of() : exclusions;
        }

        Artifact getResolvedArtifact() {
            Artifact result = this.node.getArtifact();
            if (result.getFile() == null) {
                result = IncubatingApplicationModelResolver.this.resolve(result, this.node.getRepositories());
                this.node.setArtifact(result);
            }
            return result;
        }

        private boolean isWalkingFlagOn(byte flag) {
            return (this.walkingFlags & flag) > 0;
        }

        private void clearWalkingFlag(byte flag) {
            if ((this.walkingFlags & flag) > 0) {
                this.walkingFlags = (byte)(this.walkingFlags ^ flag);
            }
        }

        private void collectConditionalDependencies() throws BootstrapDependencyProcessingException {
            if (this.ext.info.conditionalDeps.length == 0 || this.ext.conditionalDepsQueued) {
                return;
            }
            this.ext.conditionalDepsQueued = true;
            ExclusionDependencySelector selector = this.ext.exclusions == null ? null : new ExclusionDependencySelector(this.ext.exclusions);
            for (Artifact conditionalArtifact : this.ext.info.conditionalDeps) {
                if (selector != null && !selector.selectDependency(new Dependency(conditionalArtifact, "runtime"))) continue;
                ExtensionInfo conditionalInfo = IncubatingApplicationModelResolver.this.getExtensionInfoOrNull(conditionalArtifact, this.ext.runtimeNode.getRepositories());
                if (conditionalInfo == null) {
                    log.warn((Object)(this.ext.info.runtimeArtifact + " declares a conditional dependency on " + conditionalArtifact + " that is not a Quarkus extension and will be ignored"));
                    continue;
                }
                if (conditionalInfo.activated) continue;
                ConditionalDependency conditionalDep = new ConditionalDependency(conditionalInfo, this);
                IncubatingApplicationModelResolver.this.conditionalDepsToProcess.add(conditionalDep);
                conditionalDep.conditionalDep.collectConditionalDependencies();
            }
        }
    }

    private class AppDepLogger {
        final List<Boolean> depth = new ArrayList<Boolean>();

        private AppDepLogger() {
        }

        void log(AppDep dep) {
            this.logInternal(dep);
            int childrenTotal = dep.node.getChildren().size();
            if (childrenTotal > 0) {
                if (childrenTotal == 1) {
                    this.depth.add(false);
                    this.log(dep.children.get(0));
                } else {
                    this.depth.add(true);
                    int i = 0;
                    while (i < childrenTotal) {
                        this.log(dep.children.get(i++));
                        if (i != childrenTotal - 1) continue;
                        this.depth.set(this.depth.size() - 1, false);
                    }
                }
                this.depth.remove(this.depth.size() - 1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void logInternal(AppDep dep) {
            Collection deps;
            StringBuilder buf = new StringBuilder();
            if (!this.depth.isEmpty()) {
                for (int i = 0; i < this.depth.size() - 1; ++i) {
                    if (this.depth.get(i).booleanValue()) {
                        buf.append('\u2502').append("  ");
                        continue;
                    }
                    buf.append("   ");
                }
                if (this.depth.get(this.depth.size() - 1).booleanValue()) {
                    buf.append('\u251c').append('\u2500').append(' ');
                } else {
                    buf.append('\u2514').append('\u2500').append(' ');
                }
            }
            ResolvedDependencyBuilder resolvedDep = this.getResolvedDependency(DependencyUtils.getKey(dep.node.getArtifact()));
            buf.append(resolvedDep.toCompactCoords());
            if (!this.depth.isEmpty()) {
                this.appendFlags(buf, (ResolvedDependency)resolvedDep);
            }
            IncubatingApplicationModelResolver.this.depLogging.getMessageConsumer().accept(buf.toString());
            if (IncubatingApplicationModelResolver.this.depLogging.isGraph() && !(deps = resolvedDep.getDependencies()).isEmpty() && deps.size() != dep.children.size()) {
                void var7_11;
                HashMap versions = new HashMap(dep.children.size());
                for (AppDep appDep : dep.children) {
                    versions.put(DependencyUtils.getCoords(appDep.node.getArtifact()), null);
                }
                ArrayList<String> list = new ArrayList<String>(deps.size() - dep.children.size());
                for (ArtifactCoords coords : deps) {
                    if (versions.containsKey(coords)) continue;
                    ResolvedDependencyBuilder childDep = this.getResolvedDependency(coords.getKey());
                    StringBuilder sb = new StringBuilder().append(childDep.toCompactCoords());
                    this.appendFlags(sb, (ResolvedDependency)childDep);
                    list.add(sb.append(" [+]").toString());
                }
                Collections.sort(list);
                boolean bl = false;
                while (var7_11 < list.size()) {
                    buf = new StringBuilder();
                    if (!this.depth.isEmpty()) {
                        for (int i = 0; i < this.depth.size() - 1; ++i) {
                            if (this.depth.get(i).booleanValue()) {
                                buf.append('\u2502').append("  ");
                                continue;
                            }
                            buf.append("   ");
                        }
                        if (this.depth.get(this.depth.size() - 1).booleanValue()) {
                            buf.append('\u2502').append("  ");
                        } else {
                            buf.append("   ");
                        }
                    }
                    if (var7_11 < list.size() - 1) {
                        buf.append('\u251c').append('\u2500').append(' ');
                    } else if (dep.children.isEmpty()) {
                        buf.append('\u2514').append('\u2500').append(' ');
                    } else {
                        buf.append('\u251c').append('\u2500').append(' ');
                    }
                    buf.append((String)list.get((int)var7_11));
                    IncubatingApplicationModelResolver.this.depLogging.getMessageConsumer().accept(buf.toString());
                    ++var7_11;
                }
            }
        }

        private void appendFlags(StringBuilder sb, ResolvedDependency d) {
            sb.append(" (").append(d.getScope());
            if (d.isFlagSet(1)) {
                sb.append(" optional");
            }
            if (IncubatingApplicationModelResolver.this.depLogging.isVerbose()) {
                if (d.isFlagSet(4)) {
                    sb.append(", runtime classpath");
                } else {
                    sb.append(", build-time classpath");
                }
                if (d.isFlagSet(16)) {
                    sb.append(", extension");
                }
                if (d.isFlagSet(64)) {
                    sb.append(", reloadable");
                }
            }
            sb.append(')');
        }

        private ResolvedDependencyBuilder getResolvedDependency(ArtifactKey key) {
            ResolvedDependencyBuilder resolvedDep = IncubatingApplicationModelResolver.this.appBuilder.getDependency(key);
            if (resolvedDep == null) {
                if (IncubatingApplicationModelResolver.this.appBuilder.getApplicationArtifact().getKey().equals(key)) {
                    return IncubatingApplicationModelResolver.this.appBuilder.getApplicationArtifact();
                }
                throw new IllegalArgumentException("Failed to locate " + key + " among application dependencies");
            }
            return resolvedDep;
        }
    }

    private class ExtensionDependency {
        final ExtensionInfo info;
        final DependencyNode runtimeNode;
        final Collection<Exclusion> exclusions;
        boolean conditionalDepsQueued;
        private List<ExtensionDependency> extDeps;
        private DependencyNode deploymentNode;
        private DependencyNode parentNode;

        static ExtensionDependency get(DependencyNode node) {
            return (ExtensionDependency)node.getData().get(IncubatingApplicationModelResolver.QUARKUS_EXTENSION_DEPENDENCY);
        }

        ExtensionDependency(ExtensionInfo info, DependencyNode node, Collection<Exclusion> exclusions) {
            this.runtimeNode = node;
            this.info = info;
            this.exclusions = exclusions;
            Map data = node.getData();
            if (data.isEmpty()) {
                node.setData((Object)IncubatingApplicationModelResolver.QUARKUS_EXTENSION_DEPENDENCY, (Object)this);
            } else if (data.put(IncubatingApplicationModelResolver.QUARKUS_EXTENSION_DEPENDENCY, this) != null) {
                throw new IllegalStateException("Dependency node " + node + " has already been associated with an extension dependency");
            }
        }

        DependencyNode getParentDeploymentNode() {
            if (this.parentNode == null) {
                return null;
            }
            ExtensionDependency ext = ExtensionDependency.get(this.parentNode);
            if (ext == null) {
                return null;
            }
            return ext.deploymentNode == null ? ext.parentNode : ext.deploymentNode;
        }

        void addExtensionDependency(ExtensionDependency dep) {
            if (this.extDeps == null) {
                this.extDeps = new ArrayList<ExtensionDependency>();
            }
            this.extDeps.add(dep);
        }

        private void collectDeploymentDeps() throws BootstrapDependencyProcessingException {
            log.debugf("Collecting dependencies of %s", (Object)this.info.deploymentArtifact);
            this.deploymentNode = IncubatingApplicationModelResolver.this.collectDependencies(this.info.deploymentArtifact, this.exclusions, this.runtimeNode.getRepositories());
            if (this.deploymentNode.getChildren().isEmpty()) {
                throw new BootstrapDependencyProcessingException("Failed to collect dependencies of " + this.deploymentNode.getArtifact() + ": either its POM could not be resolved from the available Maven repositories or the artifact does not have any dependencies while at least a dependency on the runtime artifact " + this.info.runtimeArtifact + " is expected");
            }
            if (!this.replaceDirectDepBranch(this.deploymentNode, true)) {
                throw new BootstrapDependencyProcessingException("Quarkus extension deployment artifact " + this.deploymentNode.getArtifact() + " does not appear to depend on the corresponding runtime artifact " + this.info.runtimeArtifact);
            }
        }

        private void injectDeploymentNode(DependencyNode parentDeploymentNode) {
            if (parentDeploymentNode == null) {
                this.runtimeNode.setData((Object)IncubatingApplicationModelResolver.QUARKUS_RUNTIME_ARTIFACT, (Object)this.runtimeNode.getArtifact());
                this.runtimeNode.setArtifact(this.deploymentNode.getArtifact());
                this.runtimeNode.setChildren(this.deploymentNode.getChildren());
            } else {
                parentDeploymentNode.getChildren().add(this.deploymentNode);
            }
        }

        private boolean replaceDirectDepBranch(DependencyNode parentNode, boolean replaceRuntimeNode) {
            DependencyNode inserted = null;
            List childNodes = parentNode.getChildren();
            for (int i = 0; i < childNodes.size(); ++i) {
                DependencyNode node = (DependencyNode)childNodes.get(i);
                Artifact a = node.getArtifact();
                if (a == null || DependencyUtils.hasWinner(node) || !IncubatingApplicationModelResolver.isSameKey(this.info.runtimeArtifact, a)) continue;
                if (replaceRuntimeNode) {
                    inserted = new DefaultDependencyNode(this.runtimeNode);
                    inserted.setChildren(this.runtimeNode.getChildren());
                    childNodes.set(i, inserted);
                } else {
                    inserted = this.runtimeNode;
                }
                if (this.deploymentNode != null || this.parentNode != null) break;
                this.parentNode = parentNode;
                break;
            }
            if (inserted == null) {
                return false;
            }
            if (this.extDeps != null) {
                ArrayList depQueue = new ArrayList(childNodes);
                ArrayList<ExtensionDependency> exts = new ArrayList<ExtensionDependency>(this.extDeps);
                for (int j = 0; j < depQueue.size(); ++j) {
                    DependencyNode depNode = (DependencyNode)depQueue.get(j);
                    if (DependencyUtils.hasWinner(depNode)) continue;
                    for (int k = 0; k < exts.size(); ++k) {
                        if (!exts.get(k).replaceDirectDepBranch(depNode, replaceRuntimeNode && depNode != inserted)) continue;
                        exts.remove(k);
                        break;
                    }
                    if (exts.isEmpty()) break;
                    depQueue.addAll(depNode.getChildren());
                }
            }
            return true;
        }
    }
}

