/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.ClassLoadingResource;
import io.quarkus.bootstrap.runner.JarFileReference;
import io.quarkus.bootstrap.runner.ManifestInfo;
import io.smallrye.common.io.jar.JarEntries;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarResource
implements ClassLoadingResource {
    private volatile ProtectionDomain protectionDomain;
    private final ManifestInfo manifestInfo;
    final Path jarPath;
    final AtomicReference<CompletableFuture<JarFileReference>> jarFileReference = new AtomicReference();

    public JarResource(ManifestInfo manifestInfo, Path jarPath) {
        this.manifestInfo = manifestInfo;
        this.jarPath = jarPath;
    }

    @Override
    public void init() {
        URL url;
        try {
            Object path = this.jarPath.toAbsolutePath().toString();
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            URI uri = new URI("file", null, (String)path, null);
            url = uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Unable to create protection domain for " + this.jarPath, e);
        }
        this.protectionDomain = new ProtectionDomain(new CodeSource(url, (Certificate[])null), null);
    }

    @Override
    public byte[] getResourceData(String resource) {
        return JarFileReference.withJarFile(this, resource, JarResourceDataProvider.INSTANCE);
    }

    @Override
    public URL getResourceURL(String resource) {
        return JarFileReference.withJarFile(this, resource, JarResourceURLProvider.INSTANCE);
    }

    @Override
    public ManifestInfo getManifestInfo() {
        return this.manifestInfo;
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    @Override
    public void close() {
        JarFileReference ref;
        CompletableFuture<JarFileReference> futureRef = this.jarFileReference.get();
        if (futureRef != null && (ref = (JarFileReference)futureRef.getNow(null)) != null) {
            ref.markForClosing(this);
        }
    }

    @Override
    public void resetInternalCaches() {
        this.close();
    }

    public String toString() {
        return "JarResource{" + this.jarPath.getFileName() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarResource that = (JarResource)o;
        return this.jarPath.equals(that.jarPath);
    }

    public int hashCode() {
        return Objects.hashCode(this.jarPath);
    }

    private static class JarResourceDataProvider
    implements JarFileReference.JarFileConsumer<byte[]> {
        private static final JarResourceDataProvider INSTANCE = new JarResourceDataProvider();

        private JarResourceDataProvider() {
        }

        @Override
        public byte[] apply(JarFile jarFile, Path path, String res) {
            byte[] byArray;
            block11: {
                ZipEntry entry = jarFile.getEntry(res);
                if (entry == null) {
                    return null;
                }
                InputStream is = jarFile.getInputStream(entry);
                try {
                    int read;
                    byte[] data = new byte[(int)entry.getSize()];
                    int pos = 0;
                    for (int rem = data.length; rem > 0; rem -= read) {
                        read = is.read(data, pos, rem);
                        if (read == -1) {
                            throw new RuntimeException("Failed to read all data for " + res);
                        }
                        pos += read;
                    }
                    byArray = data;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read zip entry " + res, e);
                    }
                }
                is.close();
            }
            return byArray;
        }
    }

    private static class JarResourceURLProvider
    implements JarFileReference.JarFileConsumer<URL> {
        private static final JarResourceURLProvider INSTANCE = new JarResourceURLProvider();

        private JarResourceURLProvider() {
        }

        @Override
        public URL apply(JarFile jarFile, Path path, String res) {
            JarEntry entry = jarFile.getJarEntry(res);
            if (entry == null) {
                return null;
            }
            try {
                URL resUrl;
                String realName = JarEntries.getRealName((JarEntry)entry);
                if (realName.endsWith("/")) {
                    realName = realName.substring(0, realName.length() - 1);
                }
                StringBuilder file = new StringBuilder(((resUrl = JarResourceURLProvider.getUrl(path, realName)).getProtocol() == null ? 4 : resUrl.getProtocol().length()) + 1 + resUrl.getPath().length() + (resUrl.getQuery() == null ? 0 : 3 + resUrl.getQuery().length()));
                file.append(resUrl.getProtocol());
                file.append(':');
                file.append(resUrl.getPath());
                if (resUrl.getQuery() != null) {
                    file.append("%3F");
                    file.append(resUrl.getQuery());
                }
                return new URL("jar", null, file.toString());
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private static URL getUrl(Path jarPath, String realName) throws MalformedURLException, URISyntaxException {
            URI jarUri = jarPath.toUri();
            StringBuilder ssp = new StringBuilder(jarUri.getPath().length() + realName.length() + 2);
            ssp.append(jarUri.getPath());
            ssp.append("!/");
            ssp.append(realName);
            return new URI(jarUri.getScheme(), ssp.toString(), null).toURL();
        }
    }
}

