/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.console;

import io.quarkus.dev.console.InputHandler;
import io.quarkus.dev.console.QuarkusConsole;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.utils.ANSI;

public class AeshConsole
extends QuarkusConsole {
    private final Connection connection;
    private final boolean inputSupport;
    private Size size;
    private Attributes attributes;
    private String statusMessage;
    private String promptMessage;
    private int totalStatusLines = 0;
    private int lastWriteCursorX;
    private final LinkedBlockingDeque<String> writeQueue = new LinkedBlockingDeque();
    private final Lock connectionLock = new ReentrantLock();
    private static final ThreadLocal<Boolean> IN_WRITE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public AeshConsole(final Connection connection, boolean inputSupport) {
        this.inputSupport = inputSupport;
        INSTANCE = this;
        this.connection = connection;
        connection.openNonBlocking();
        this.setup(connection);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                connection.close();
            }
        }, "Console Shutdown Hoot"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AeshConsole setStatusMessage(String statusMessage) {
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            StringBuilder buffer = new StringBuilder();
            this.clearStatusMessages(buffer);
            int newLines = this.countLines(statusMessage) + this.countLines(this.promptMessage);
            if (statusMessage == null) {
                if (this.promptMessage != null) {
                    newLines += 2;
                }
            } else {
                newLines = this.promptMessage == null ? (newLines += 2) : (newLines += 3);
            }
            if (newLines > this.totalStatusLines) {
                for (int i = 0; i < newLines - this.totalStatusLines; ++i) {
                    buffer.append("\n");
                }
            }
            this.statusMessage = statusMessage;
            this.totalStatusLines = newLines;
            this.printStatusAndPrompt(buffer);
            this.writeQueue.add(buffer.toString());
        }
        this.deadlockSafeWrite();
        return this;
    }

    public AeshInputHolder createHolder(InputHandler inputHandler) {
        return new AeshInputHolder(inputHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AeshConsole setPromptMessage(String promptMessage) {
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            if (!this.inputSupport) {
                return this;
            }
            StringBuilder buffer = new StringBuilder();
            this.clearStatusMessages(buffer);
            int newLines = this.countLines(this.statusMessage) + this.countLines(promptMessage);
            if (this.statusMessage == null) {
                if (promptMessage != null) {
                    newLines += 2;
                }
            } else {
                newLines = promptMessage == null ? (newLines += 2) : (newLines += 3);
            }
            if (newLines > this.totalStatusLines) {
                for (int i = 0; i < newLines - this.totalStatusLines; ++i) {
                    buffer.append("\n");
                }
            }
            this.promptMessage = promptMessage;
            this.totalStatusLines = newLines;
            this.printStatusAndPrompt(buffer);
            this.writeQueue.add(buffer.toString());
        }
        this.deadlockSafeWrite();
        return this;
    }

    private void end(Connection conn) {
        conn.setAttributes(this.attributes);
        StringBuilder sb = new StringBuilder();
        sb.append(ANSI.MAIN_BUFFER);
        sb.append("\u001b[?25h");
        sb.append("\u001b[0m");
        this.writeQueue.add(sb.toString());
        this.deadlockSafeWrite();
    }

    private void deadlockSafeWrite() {
        block3: while (!this.writeQueue.isEmpty()) {
            if (!this.connectionLock.tryLock()) continue;
            IN_WRITE.set(true);
            try {
                while (true) {
                    if (this.writeQueue.isEmpty()) continue block3;
                    String s = this.writeQueue.poll();
                    this.connection.write(s);
                }
            }
            finally {
                IN_WRITE.set(false);
                this.connectionLock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup(Connection conn) {
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            this.size = conn.size();
            if (this.inputSupport) {
                conn.setSignalHandler(event -> {
                    switch (event) {
                        case INT: {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    System.exit(0);
                                }
                            }).start();
                        }
                    }
                });
                conn.setStdinHandler(keys -> {
                    QuarkusConsole.InputHolder handler = (QuarkusConsole.InputHolder)this.inputHandlers.peek();
                    if (handler != null) {
                        handler.handler.handleInput(keys);
                    }
                });
            }
            conn.setCloseHandler(close -> this.end(conn));
            conn.setSizeHandler(size -> this.setup(conn));
            this.attributes = this.inputSupport ? conn.enterRawMode() : conn.getAttributes();
            StringBuilder sb = new StringBuilder();
            this.printStatusAndPrompt(sb);
            this.writeQueue.add(sb.toString());
        }
        this.deadlockSafeWrite();
    }

    private void printStatusAndPrompt(StringBuilder buffer) {
        if (this.totalStatusLines == 0) {
            return;
        }
        this.clearStatusMessages(buffer);
        this.gotoLine(buffer, this.size.getHeight() - this.totalStatusLines);
        buffer.append("\n--\n");
        if (this.statusMessage != null) {
            buffer.append(this.statusMessage);
            if (this.promptMessage != null) {
                buffer.append("\n");
            }
        }
        if (this.promptMessage != null) {
            buffer.append(this.promptMessage);
        }
    }

    private void clearStatusMessages(StringBuilder buffer) {
        this.gotoLine(buffer, this.size.getHeight() - this.totalStatusLines);
        buffer.append("\u001b[J");
    }

    private StringBuilder gotoLine(StringBuilder builder, int line) {
        return builder.append("\u001b[").append(line).append(";").append(0).append("H");
    }

    int countLines(String s) {
        return this.countLines(s, 0);
    }

    int countLines(String s, int cursorPos) {
        if (s == null) {
            return 0;
        }
        s = this.stripAnsiCodes(s);
        int lines = 0;
        int curLength = cursorPos;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                ++lines;
                curLength = 0;
                continue;
            }
            if (curLength++ != this.size.getWidth()) continue;
            ++lines;
            curLength = 0;
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s) {
        if (IN_WRITE.get().booleanValue()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            if (this.outputFilter != null && !this.outputFilter.test(s)) {
                return;
            }
            if (this.totalStatusLines == 0) {
                this.writeQueue.add(s);
            } else {
                this.clearStatusMessages(buffer);
                int cursorPos = this.lastWriteCursorX;
                this.gotoLine(buffer, this.size.getHeight());
                String stripped = this.stripAnsiCodes(s);
                int lines = this.countLines(s, cursorPos);
                int trailing = 0;
                int index = stripped.lastIndexOf("\n");
                trailing = index == -1 ? stripped.length() : stripped.length() - index - 1;
                int newCursorPos = lines == 0 ? trailing + cursorPos : trailing;
                if (cursorPos > 1 && lines == 0) {
                    buffer.append(s);
                    this.lastWriteCursorX = newCursorPos;
                    this.connection.write(buffer.toString());
                    return;
                }
                if (lines == 0) {
                    ++lines;
                }
                int appendLines = Math.max(Math.min(cursorPos > 1 ? lines - 1 : lines, this.totalStatusLines), 1);
                this.clearStatusMessages(buffer);
                buffer.append("\u001b[").append(this.size.getHeight() - this.totalStatusLines).append(";").append(0).append("H");
                buffer.append(s);
                buffer.append("\u001b[").append(this.size.getHeight()).append(";").append(0).append("H");
                for (int i = 0; i < appendLines; ++i) {
                    buffer.append("\n");
                }
                this.lastWriteCursorX = newCursorPos;
                this.printStatusAndPrompt(buffer);
                this.writeQueue.add(buffer.toString());
            }
        }
        this.deadlockSafeWrite();
    }

    public void write(byte[] buf, int off, int len) {
        this.write(new String(buf, off, len, this.connection.outputEncoding()));
    }

    class AeshInputHolder
    extends QuarkusConsole.InputHolder {
        protected AeshInputHolder(InputHandler handler) {
            super(handler);
        }

        protected void setPromptMessage(String prompt) {
            AeshConsole.this.setPromptMessage(prompt);
        }

        protected void setStatusMessage(String status) {
            AeshConsole.this.setStatusMessage(status);
        }
    }
}

