/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestRunResults {
    private final long id;
    private final ClassScanResult trigger;
    private final boolean full;
    private final long started;
    private final long completed;
    private final Map<String, TestClassResult> results;
    private final Map<String, TestClassResult> currentFailing = new HashMap<String, TestClassResult>();
    private final Map<String, TestClassResult> historicFailing = new HashMap<String, TestClassResult>();
    private final Map<String, TestClassResult> currentPassing = new HashMap<String, TestClassResult>();
    private final Map<String, TestClassResult> historicPassing = new HashMap<String, TestClassResult>();
    private final List<TestClassResult> failing = new ArrayList<TestClassResult>();
    private final List<TestClassResult> passing = new ArrayList<TestClassResult>();
    private final List<TestClassResult> skipped = new ArrayList<TestClassResult>();
    private final long passedCount;
    private final long failedCount;
    private final long skippedCount;
    private final long currentPassedCount;
    private final long currentFailedCount;
    private final long currentSkippedCount;

    public TestRunResults(long id, ClassScanResult trigger, boolean full, long started, long completed, Map<String, TestClassResult> results) {
        this.id = id;
        this.trigger = trigger;
        this.full = full;
        this.started = started;
        this.completed = completed;
        this.results = new HashMap<String, TestClassResult>(results);
        long passedCount = 0L;
        long failedCount = 0L;
        long skippedCount = 0L;
        long currentPassedCount = 0L;
        long currentFailedCount = 0L;
        long currentSkippedCount = 0L;
        for (Map.Entry<String, TestClassResult> i : results.entrySet()) {
            boolean current;
            passedCount += i.getValue().getPassing().stream().filter(TestResult::isTest).count();
            failedCount += i.getValue().getFailing().stream().filter(TestResult::isTest).count();
            skippedCount += i.getValue().getSkipped().stream().filter(TestResult::isTest).count();
            currentPassedCount += i.getValue().getPassing().stream().filter(s -> s.isTest() && s.getRunId() == id).count();
            currentFailedCount += i.getValue().getFailing().stream().filter(s -> s.isTest() && s.getRunId() == id).count();
            currentSkippedCount += i.getValue().getSkipped().stream().filter(s -> s.isTest() && s.getRunId() == id).count();
            boolean bl = current = i.getValue().getLatestRunId() == id;
            if (current) {
                if (!i.getValue().getFailing().isEmpty()) {
                    this.currentFailing.put(i.getKey(), i.getValue());
                    this.failing.add(i.getValue());
                    continue;
                }
                if (!i.getValue().getPassing().isEmpty()) {
                    this.currentPassing.put(i.getKey(), i.getValue());
                    this.passing.add(i.getValue());
                    continue;
                }
                this.skipped.add(i.getValue());
                continue;
            }
            if (!i.getValue().getFailing().isEmpty()) {
                this.historicFailing.put(i.getKey(), i.getValue());
                this.failing.add(i.getValue());
                continue;
            }
            if (!i.getValue().getPassing().isEmpty()) {
                this.historicPassing.put(i.getKey(), i.getValue());
                this.passing.add(i.getValue());
                continue;
            }
            this.skipped.add(i.getValue());
        }
        Collections.sort(this.passing);
        Collections.sort(this.failing);
        Collections.sort(this.skipped);
        this.failedCount = failedCount;
        this.passedCount = passedCount;
        this.skippedCount = skippedCount;
        this.currentFailedCount = currentFailedCount;
        this.currentPassedCount = currentPassedCount;
        this.currentSkippedCount = currentSkippedCount;
    }

    public long getId() {
        return this.id;
    }

    public ClassScanResult getTrigger() {
        return this.trigger;
    }

    public boolean isFull() {
        return this.full;
    }

    public Map<String, TestClassResult> getResults() {
        return Collections.unmodifiableMap(this.results);
    }

    public Map<String, TestClassResult> getCurrentFailing() {
        return this.currentFailing;
    }

    public Map<String, TestClassResult> getHistoricFailing() {
        return this.historicFailing;
    }

    public Map<String, TestClassResult> getCurrentPassing() {
        return this.currentPassing;
    }

    public Map<String, TestClassResult> getHistoricPassing() {
        return this.historicPassing;
    }

    public long getStartedTime() {
        return this.started;
    }

    public long getCompletedTime() {
        return this.completed;
    }

    public long getTotalTime() {
        return this.completed - this.started;
    }

    public List<TestClassResult> getFailing() {
        return this.failing;
    }

    public List<TestClassResult> getPassing() {
        return this.passing;
    }

    public List<TestClassResult> getSkipped() {
        return this.skipped;
    }

    public long getPassedCount() {
        return this.passedCount;
    }

    public long getFailedCount() {
        return this.failedCount;
    }

    public long getSkippedCount() {
        return this.skippedCount;
    }

    public long getCurrentPassedCount() {
        return this.currentPassedCount;
    }

    public long getCurrentFailedCount() {
        return this.currentFailedCount;
    }

    public long getCurrentSkippedCount() {
        return this.currentSkippedCount;
    }

    public long getTotalCount() {
        return this.getPassedCount() + this.getFailedCount() + this.getSkippedCount();
    }

    public long getCurrentTotalCount() {
        return this.getCurrentPassedCount() + this.getCurrentFailedCount() + this.getCurrentSkippedCount();
    }
}

