/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Objects;
import java.util.Set;
import org.jboss.jandex.DotName;

public final class ConfigClassBuildItem
extends MultiBuildItem {
    private final Class<?> configClass;
    private final Set<String> generatedClasses;
    private final String prefix;
    private final Type type;
    private final DotName name;

    public ConfigClassBuildItem(Class<?> configClass, Set<String> generatedClasses, String prefix, Type type) {
        this.configClass = configClass;
        this.generatedClasses = generatedClasses;
        this.prefix = prefix;
        this.type = type;
        this.name = DotName.createSimple((String)configClass.getName());
    }

    public Class<?> getConfigClass() {
        return this.configClass;
    }

    public Set<String> getGeneratedClasses() {
        return this.generatedClasses;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Type getType() {
        return this.type;
    }

    public DotName getName() {
        return this.name;
    }

    public boolean isMapping() {
        return Type.MAPPING.equals((Object)this.type);
    }

    public boolean isProperties() {
        return Type.PROPERTIES.equals((Object)this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConfigClassBuildItem that = (ConfigClassBuildItem)((Object)o);
        return this.configClass.equals(that.configClass) && this.prefix.equals(that.prefix) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configClass, this.prefix, this.type});
    }

    public static enum Type {
        MAPPING,
        PROPERTIES;

    }
}

