/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.configuration.ConfigCompatibility;
import io.quarkus.deployment.configuration.DefaultValuesConfigurationSource;
import io.quarkus.deployment.configuration.definition.ClassDefinition;
import io.quarkus.deployment.configuration.definition.GroupDefinition;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.deployment.configuration.matching.ConfigPatternMap;
import io.quarkus.deployment.configuration.matching.Container;
import io.quarkus.deployment.configuration.matching.FieldContainer;
import io.quarkus.deployment.configuration.matching.MapContainer;
import io.quarkus.deployment.configuration.matching.PatternMapBuilder;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingInterceptor;
import io.quarkus.deployment.configuration.type.ArrayOf;
import io.quarkus.deployment.configuration.type.CollectionOf;
import io.quarkus.deployment.configuration.type.ConverterType;
import io.quarkus.deployment.configuration.type.Leaf;
import io.quarkus.deployment.configuration.type.LowerBoundCheckOf;
import io.quarkus.deployment.configuration.type.MinMaxValidated;
import io.quarkus.deployment.configuration.type.OptionalOf;
import io.quarkus.deployment.configuration.type.PatternValidated;
import io.quarkus.deployment.configuration.type.UpperBoundCheckOf;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import io.quarkus.runtime.configuration.NameIterator;
import io.quarkus.runtime.configuration.PropertiesUtil;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.Expressions;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.PropertyName;
import io.smallrye.config.SecretKeys;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import io.smallrye.config.SysPropConfigSource;
import io.smallrye.config.common.AbstractConfigSource;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;

public final class BuildTimeConfigurationReader {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.config.build");
    private static final String CONFIG_ROOTS_LIST = "META-INF/quarkus-config-roots.list";
    final ClassLoader classLoader;
    final ConfigPatternMap<Container> buildTimePatternMap;
    final ConfigPatternMap<Container> buildTimeRunTimePatternMap;
    final ConfigPatternMap<Container> runTimePatternMap;
    final List<RootDefinition> allRoots;
    final List<RootDefinition> buildTimeVisibleRoots;
    final List<ConfigMappings.ConfigClass> buildTimeMappings;
    final List<ConfigMappings.ConfigClass> buildTimeRunTimeMappings;
    final List<ConfigMappings.ConfigClass> runTimeMappings;
    final List<ConfigMappings.ConfigClass> buildTimeVisibleMappings;
    final Set<String> deprecatedProperties;
    final Set<String> deprecatedRuntimeProperties;
    final ConfigTrackingInterceptor buildConfigTracker;

    private static List<Class<?>> collectConfigRoots(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Assert.checkNotNullParam((String)"classLoader", (Object)classLoader);
        ArrayList roots = new ArrayList();
        for (Class<?> clazz : ServiceUtil.classesNamedIn(classLoader, CONFIG_ROOTS_LIST)) {
            ConfigRoot annotation = clazz.getAnnotation(ConfigRoot.class);
            if (annotation == null) {
                log.warnf("Ignoring configuration root %s because it has no annotation", clazz);
                continue;
            }
            roots.add(clazz);
        }
        return roots;
    }

    public BuildTimeConfigurationReader(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        this(classLoader, BuildTimeConfigurationReader.collectConfigRoots(classLoader));
    }

    public BuildTimeConfigurationReader(List<Class<?>> configRoots) {
        this(null, configRoots);
    }

    private BuildTimeConfigurationReader(ClassLoader classLoader, List<Class<?>> configRoots) {
        Assert.checkNotNullParam((String)"configRoots", configRoots);
        this.classLoader = classLoader;
        ArrayList<RootDefinition> buildTimeRoots = new ArrayList<RootDefinition>();
        ArrayList<RootDefinition> buildTimeRunTimeRoots = new ArrayList<RootDefinition>();
        ArrayList<RootDefinition> runTimeRoots = new ArrayList<RootDefinition>();
        this.buildTimeMappings = new ArrayList<ConfigMappings.ConfigClass>();
        this.buildTimeRunTimeMappings = new ArrayList<ConfigMappings.ConfigClass>();
        this.runTimeMappings = new ArrayList<ConfigMappings.ConfigClass>();
        HashMap groups = new HashMap();
        for (Class<?> configRoot : configRoots) {
            boolean isMapping = configRoot.isAnnotationPresent(ConfigMapping.class);
            if (isMapping) {
                ConfigPhase phase = ConfigPhase.BUILD_TIME;
                ConfigRoot annotation = configRoot.getAnnotation(ConfigRoot.class);
                if (annotation != null) {
                    if (!annotation.prefix().equals("quarkus")) {
                        throw ReflectUtil.reportError(configRoot, "@ConfigRoot.prefix() is not allowed in combination with @ConfigMapping, please use @ConfigMapping.prefix()", new Object[0]);
                    }
                    if (!annotation.name().equals("<<hyphenated element name>>")) {
                        throw ReflectUtil.reportError(configRoot, "@ConfigRoot.name() is not allowed in combination with @ConfigMapping", new Object[0]);
                    }
                    phase = annotation.phase();
                }
                ConfigMappings.ConfigClass mapping = ConfigMappings.ConfigClass.configClass(configRoot);
                if (phase.equals((Object)ConfigPhase.BUILD_TIME)) {
                    this.buildTimeMappings.add(mapping);
                    continue;
                }
                if (phase.equals((Object)ConfigPhase.BUILD_AND_RUN_TIME_FIXED)) {
                    this.buildTimeRunTimeMappings.add(mapping);
                    continue;
                }
                if (!phase.equals((Object)ConfigPhase.RUN_TIME)) continue;
                this.runTimeMappings.add(mapping);
                continue;
            }
            String prefix = "quarkus";
            String name = "<<hyphenated element name>>";
            ConfigPhase phase = ConfigPhase.BUILD_TIME;
            ConfigRoot annotation = configRoot.getAnnotation(ConfigRoot.class);
            if (annotation != null) {
                prefix = annotation.prefix();
                name = annotation.name();
                phase = annotation.phase();
            }
            RootDefinition.Builder defBuilder = new RootDefinition.Builder();
            defBuilder.setPrefix(prefix);
            defBuilder.setConfigPhase(phase);
            defBuilder.setRootName(name);
            BuildTimeConfigurationReader.processClass(defBuilder, configRoot, groups);
            RootDefinition definition = defBuilder.build();
            if (phase == ConfigPhase.BUILD_TIME) {
                buildTimeRoots.add(definition);
                continue;
            }
            if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                buildTimeRunTimeRoots.add(definition);
                continue;
            }
            assert (phase == ConfigPhase.RUN_TIME);
            runTimeRoots.add(definition);
        }
        this.buildTimePatternMap = PatternMapBuilder.makePatterns(buildTimeRoots);
        this.buildTimeRunTimePatternMap = PatternMapBuilder.makePatterns(buildTimeRunTimeRoots);
        this.runTimePatternMap = PatternMapBuilder.makePatterns(runTimeRoots);
        this.buildTimeVisibleRoots = new ArrayList<RootDefinition>(buildTimeRoots.size() + buildTimeRunTimeRoots.size());
        this.buildTimeVisibleRoots.addAll(buildTimeRoots);
        this.buildTimeVisibleRoots.addAll(buildTimeRunTimeRoots);
        this.allRoots = new ArrayList<RootDefinition>(this.buildTimeVisibleRoots.size() + runTimeRoots.size());
        this.allRoots.addAll(this.buildTimeVisibleRoots);
        this.allRoots.addAll(runTimeRoots);
        this.buildTimeVisibleMappings = new ArrayList<ConfigMappings.ConfigClass>(this.buildTimeMappings.size() + this.buildTimeRunTimeMappings.size());
        this.buildTimeVisibleMappings.addAll(this.buildTimeMappings);
        this.buildTimeVisibleMappings.addAll(this.buildTimeRunTimeMappings);
        this.deprecatedProperties = this.getDeprecatedProperties(this.allRoots);
        this.deprecatedRuntimeProperties = this.getDeprecatedProperties(runTimeRoots);
        this.buildConfigTracker = new ConfigTrackingInterceptor();
    }

    private static void processClass(ClassDefinition.Builder builder, Class<?> clazz, Map<Class<?>, GroupDefinition> groups) {
        builder.setConfigurationClass(clazz);
        BuildTimeConfigurationReader.processClassFields(builder, clazz, groups);
    }

    private static void processClassFields(ClassDefinition.Builder builder, Class<?> clazz, Map<Class<?>, GroupDefinition> groups) {
        for (Field field : clazz.getDeclaredFields()) {
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
            if (Modifier.isPrivate(mods)) {
                throw ReflectUtil.reportError(field, "Configuration field may not be private", new Object[0]);
            }
            if (!Modifier.isPublic(mods) || !Modifier.isPublic(clazz.getModifiers())) {
                field.setAccessible(true);
            }
            builder.addMember(BuildTimeConfigurationReader.processValue(field, field.getGenericType(), groups));
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            BuildTimeConfigurationReader.processClassFields(builder, superclass, groups);
        }
    }

    private static ClassDefinition.ClassMember.Specification processValue(Field field, Type valueType, Map<Class<?>, GroupDefinition> groups) {
        boolean isOptional;
        Class<?> valueClass = ReflectUtil.rawTypeOf(valueType);
        boolean bl = isOptional = valueClass == Optional.class;
        if (valueClass == Map.class) {
            if (!(valueType instanceof ParameterizedType)) {
                throw ReflectUtil.reportError(field, "Map values must be parameterized", new Object[0]);
            }
            Class<?> keyClass = ReflectUtil.rawTypeOfParameter(valueType, 0);
            if (keyClass != String.class) {
                throw ReflectUtil.reportError(field, "Map key types other than String are not yet supported", new Object[0]);
            }
            ClassDefinition.ClassMember.Specification nested = BuildTimeConfigurationReader.processValue(field, ReflectUtil.typeOfParameter(valueType, 1), groups);
            if (nested instanceof ClassDefinition.GroupMember.Specification && ((ClassDefinition.GroupMember.Specification)nested).isOptional()) {
                throw ReflectUtil.reportError(field, "Group map values may not be optional", new Object[0]);
            }
            return new ClassDefinition.MapMember.Specification(nested);
        }
        if (valueClass.getAnnotation(ConfigGroup.class) != null || isOptional && ReflectUtil.rawTypeOfParameter(valueType, 0).getAnnotation(ConfigGroup.class) != null) {
            Class<?> groupClass = isOptional ? ReflectUtil.rawTypeOfParameter(valueType, 0) : valueClass;
            GroupDefinition def = groups.get(groupClass);
            if (def == null) {
                GroupDefinition.Builder subBuilder = new GroupDefinition.Builder();
                BuildTimeConfigurationReader.processClass(subBuilder, groupClass, groups);
                def = subBuilder.build();
                groups.put(groupClass, def);
            }
            return new ClassDefinition.GroupMember.Specification(field, def, isOptional);
        }
        String defaultDefault = valueClass == Boolean.TYPE ? "false" : (valueClass.isPrimitive() && valueClass != Character.TYPE ? "0" : null);
        ConfigItem configItem = field.getAnnotation(ConfigItem.class);
        if (configItem != null) {
            String defaultVal = configItem.defaultValue();
            return new ClassDefinition.ItemMember.Specification(field, defaultVal.equals("<<no default>>") ? defaultDefault : defaultVal);
        }
        ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
        if (configProperty != null) {
            log.warnf("Using @ConfigProperty for Quarkus configuration items is deprecated (use @ConfigItem instead) at %s#%s", (Object)field.getDeclaringClass().getName(), (Object)field.getName());
            String defaultVal = configProperty.defaultValue();
            return new ClassDefinition.ItemMember.Specification(field, defaultVal.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue") ? defaultDefault : defaultVal);
        }
        return new ClassDefinition.ItemMember.Specification(field, defaultDefault);
    }

    public ConfigPatternMap<Container> getBuildTimePatternMap() {
        return this.buildTimePatternMap;
    }

    public ConfigPatternMap<Container> getBuildTimeRunTimePatternMap() {
        return this.buildTimeRunTimePatternMap;
    }

    public ConfigPatternMap<Container> getRunTimePatternMap() {
        return this.runTimePatternMap;
    }

    public List<RootDefinition> getBuildTimeVisibleRoots() {
        return this.buildTimeVisibleRoots;
    }

    public List<RootDefinition> getAllRoots() {
        return this.allRoots;
    }

    public List<ConfigMappings.ConfigClass> getBuildTimeMappings() {
        return this.buildTimeMappings;
    }

    public List<ConfigMappings.ConfigClass> getBuildTimeRunTimeMappings() {
        return this.buildTimeRunTimeMappings;
    }

    public List<ConfigMappings.ConfigClass> getBuildTimeVisibleMappings() {
        return this.buildTimeVisibleMappings;
    }

    public SmallRyeConfig initConfiguration(LaunchMode launchMode, Properties buildSystemProps, Properties runtimeProperties, Map<String, String> platformProperties) {
        SmallRyeConfigBuilder builder = ConfigUtils.configBuilder((boolean)false, (LaunchMode)launchMode);
        if (this.classLoader != null) {
            builder.forClassLoader(this.classLoader);
        }
        builder.withSources(new ConfigSource[]{new DefaultValuesConfigurationSource(this.getBuildTimePatternMap())}).withSources(new ConfigSource[]{new DefaultValuesConfigurationSource(this.getBuildTimeRunTimePatternMap())}).withSources(new ConfigSource[]{new PropertiesConfigSource(buildSystemProps, "Build system")}).withSources(new ConfigSource[]{new PropertiesConfigSource(runtimeProperties, "Runtime Properties")});
        if (!platformProperties.isEmpty()) {
            builder.withSources(new ConfigSource[]{new DefaultValuesConfigSource(platformProperties, "Quarkus platform", -2147482648)});
        }
        for (ConfigMappings.ConfigClass mapping : this.getBuildTimeVisibleMappings()) {
            builder.withMapping(mapping);
        }
        builder.withInterceptors(new ConfigSourceInterceptor[]{this.buildConfigTracker});
        builder.withInterceptors(new ConfigSourceInterceptor[]{ConfigCompatibility.FrontEnd.instance(), ConfigCompatibility.BackEnd.instance()});
        SmallRyeConfig config = builder.build();
        this.buildConfigTracker.configure((Config)config);
        return config;
    }

    public ReadResult readConfiguration(SmallRyeConfig config) {
        return (ReadResult)SecretKeys.doUnlocked(() -> new ReadOperation(config, this.buildConfigTracker).run());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getDeprecatedProperties(Iterable<RootDefinition> rootDefinitions) {
        HashSet<String> ret = new HashSet<String>();
        StringBuilder nameBuilder = new StringBuilder();
        for (RootDefinition rootDefinition : rootDefinitions) {
            int len = nameBuilder.length();
            try {
                nameBuilder.append(rootDefinition.getName());
                this.collectDeprecatedConfigItems(rootDefinition, ret, nameBuilder);
            }
            finally {
                nameBuilder.setLength(len);
            }
        }
        return Set.copyOf(ret);
    }

    private void collectDeprecatedConfigItems(ClassDefinition classDefinition, Set<String> deprecatedConfigItems, StringBuilder nameBuilder) {
        for (ClassDefinition.ClassMember m : classDefinition.getMembers()) {
            this.collectDeprecatedConfigItems(m, deprecatedConfigItems, nameBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectDeprecatedConfigItems(ClassDefinition.ClassMember classMember, Set<String> deprecatedConfigItems, StringBuilder nameBuilder) {
        if (classMember instanceof ClassDefinition.ItemMember) {
            ClassDefinition.ItemMember im = (ClassDefinition.ItemMember)classMember;
            if (im.getField().isAnnotationPresent(Deprecated.class)) {
                int len = nameBuilder.length();
                try {
                    nameBuilder.append(".").append(im.getPropertyName());
                    deprecatedConfigItems.add(nameBuilder.toString());
                }
                finally {
                    nameBuilder.setLength(len);
                }
            }
        } else if (classMember instanceof ClassDefinition.GroupMember) {
            ClassDefinition.GroupMember gm = (ClassDefinition.GroupMember)classMember;
            int len = nameBuilder.length();
            try {
                nameBuilder.append(".").append(gm.getPropertyName());
                this.collectDeprecatedConfigItems(gm.getGroupDefinition(), deprecatedConfigItems, nameBuilder);
            }
            finally {
                nameBuilder.setLength(len);
            }
        } else if (classMember instanceof ClassDefinition.MapMember) {
            ClassDefinition.MapMember mm = (ClassDefinition.MapMember)classMember;
            this.collectDeprecatedConfigItems(mm.getNested(), deprecatedConfigItems, nameBuilder);
        }
    }

    public static final class ReadResult {
        final Map<Class<?>, Object> objectsByClass;
        final Map<String, String> allBuildTimeValues;
        final Map<String, String> buildTimeRunTimeValues;
        final Map<String, String> runTimeDefaultValues;
        final Map<String, String> runTimeValues;
        final ConfigPatternMap<Container> buildTimePatternMap;
        final ConfigPatternMap<Container> buildTimeRunTimePatternMap;
        final ConfigPatternMap<Container> runTimePatternMap;
        final List<RootDefinition> allRoots;
        final Map<Class<?>, RootDefinition> allRootsByClass;
        final List<ConfigMappings.ConfigClass> buildTimeMappings;
        final List<ConfigMappings.ConfigClass> buildTimeRunTimeMappings;
        final List<ConfigMappings.ConfigClass> runTimeMappings;
        final Map<Class<?>, ConfigMappings.ConfigClass> allMappings;
        final Set<String> unknownBuildProperties;
        final Set<String> deprecatedRuntimeProperties;
        final ConfigTrackingInterceptor.ReadOptionsProvider readOptionsProvider;

        public ReadResult(Builder builder) {
            this.objectsByClass = builder.getObjectsByClass();
            this.allBuildTimeValues = builder.getAllBuildTimeValues();
            this.buildTimeRunTimeValues = builder.getBuildTimeRunTimeValues();
            this.runTimeDefaultValues = builder.getRunTimeDefaultValues();
            this.runTimeValues = builder.getRuntimeValues();
            this.buildTimePatternMap = builder.getBuildTimePatternMap();
            this.buildTimeRunTimePatternMap = builder.getBuildTimeRunTimePatternMap();
            this.runTimePatternMap = builder.getRunTimePatternMap();
            this.allRoots = builder.getAllRoots();
            this.allRootsByClass = ReadResult.rootsToMap(builder);
            this.buildTimeMappings = builder.getBuildTimeMappings();
            this.buildTimeRunTimeMappings = builder.getBuildTimeRunTimeMappings();
            this.runTimeMappings = builder.getRunTimeMappings();
            this.allMappings = ReadResult.mappingsToMap(builder);
            this.unknownBuildProperties = builder.getUnknownBuildProperties();
            this.deprecatedRuntimeProperties = builder.deprecatedRuntimeProperties;
            this.readOptionsProvider = builder.buildConfigTracker == null ? null : builder.buildConfigTracker.getReadOptionsProvider();
        }

        private static Map<Class<?>, RootDefinition> rootsToMap(Builder builder) {
            HashMap map = new HashMap();
            for (RootDefinition root : builder.getAllRoots()) {
                map.put(root.getConfigurationClass(), root);
            }
            return map;
        }

        private static Map<Class<?>, ConfigMappings.ConfigClass> mappingsToMap(Builder builder) {
            HashMap map = new HashMap();
            for (ConfigMappings.ConfigClass mapping : builder.getBuildTimeMappings()) {
                map.put(mapping.getKlass(), mapping);
            }
            for (ConfigMappings.ConfigClass mapping : builder.getBuildTimeRunTimeMappings()) {
                map.put(mapping.getKlass(), mapping);
            }
            for (ConfigMappings.ConfigClass mapping : builder.getRunTimeMappings()) {
                map.put(mapping.getKlass(), mapping);
            }
            return map;
        }

        public Map<Class<?>, Object> getObjectsByClass() {
            return this.objectsByClass;
        }

        public Map<String, String> getAllBuildTimeValues() {
            return this.allBuildTimeValues;
        }

        public Map<String, String> getBuildTimeRunTimeValues() {
            return this.buildTimeRunTimeValues;
        }

        public Map<String, String> getRunTimeDefaultValues() {
            return this.runTimeDefaultValues;
        }

        public Map<String, String> getRunTimeValues() {
            return this.runTimeValues;
        }

        public ConfigPatternMap<Container> getBuildTimePatternMap() {
            return this.buildTimePatternMap;
        }

        public ConfigPatternMap<Container> getBuildTimeRunTimePatternMap() {
            return this.buildTimeRunTimePatternMap;
        }

        public ConfigPatternMap<Container> getRunTimePatternMap() {
            return this.runTimePatternMap;
        }

        public List<RootDefinition> getAllRoots() {
            return this.allRoots;
        }

        public Map<Class<?>, RootDefinition> getAllRootsByClass() {
            return this.allRootsByClass;
        }

        public List<ConfigMappings.ConfigClass> getBuildTimeMappings() {
            return this.buildTimeMappings;
        }

        public List<ConfigMappings.ConfigClass> getBuildTimeRunTimeMappings() {
            return this.buildTimeRunTimeMappings;
        }

        public List<ConfigMappings.ConfigClass> getRunTimeMappings() {
            return this.runTimeMappings;
        }

        public Map<Class<?>, ConfigMappings.ConfigClass> getAllMappings() {
            return this.allMappings;
        }

        public Set<String> getUnknownBuildProperties() {
            return this.unknownBuildProperties;
        }

        public Set<String> getDeprecatedRuntimeProperties() {
            return this.deprecatedRuntimeProperties;
        }

        public Object requireObjectForClass(Class<?> clazz) {
            Object obj = this.objectsByClass.get(clazz);
            if (obj == null) {
                throw new IllegalStateException("No config found for " + clazz);
            }
            return obj;
        }

        public ConfigTrackingInterceptor.ReadOptionsProvider getReadOptionsProvider() {
            return this.readOptionsProvider;
        }

        static class Builder {
            private Map<Class<?>, Object> objectsByClass;
            private Map<String, String> allBuildTimeValues;
            private Map<String, String> buildTimeRunTimeValues;
            private Map<String, String> runTimeDefaultValues;
            private Map<String, String> runtimeValues;
            private ConfigPatternMap<Container> buildTimePatternMap;
            private ConfigPatternMap<Container> buildTimeRunTimePatternMap;
            private ConfigPatternMap<Container> runTimePatternMap;
            private List<RootDefinition> allRoots;
            private List<ConfigMappings.ConfigClass> buildTimeMappings;
            private List<ConfigMappings.ConfigClass> buildTimeRunTimeMappings;
            private List<ConfigMappings.ConfigClass> runTimeMappings;
            private Set<String> unknownBuildProperties;
            private Set<String> deprecatedRuntimeProperties;
            private ConfigTrackingInterceptor buildConfigTracker;

            Builder() {
            }

            Map<Class<?>, Object> getObjectsByClass() {
                return this.objectsByClass;
            }

            Builder setObjectsByClass(Map<Class<?>, Object> objectsByClass) {
                this.objectsByClass = objectsByClass;
                return this;
            }

            Map<String, String> getAllBuildTimeValues() {
                return this.allBuildTimeValues;
            }

            Builder setAllBuildTimeValues(Map<String, String> allBuildTimeValues) {
                this.allBuildTimeValues = allBuildTimeValues;
                return this;
            }

            Map<String, String> getBuildTimeRunTimeValues() {
                return this.buildTimeRunTimeValues;
            }

            Builder setBuildTimeRunTimeValues(Map<String, String> buildTimeRunTimeValues) {
                this.buildTimeRunTimeValues = buildTimeRunTimeValues;
                return this;
            }

            Map<String, String> getRunTimeDefaultValues() {
                return this.runTimeDefaultValues;
            }

            Builder setRunTimeDefaultValues(Map<String, String> runTimeDefaultValues) {
                this.runTimeDefaultValues = runTimeDefaultValues;
                return this;
            }

            Map<String, String> getRuntimeValues() {
                return this.runtimeValues;
            }

            Builder setRuntimeValues(Map<String, String> runtimeValues) {
                this.runtimeValues = runtimeValues;
                return this;
            }

            ConfigPatternMap<Container> getBuildTimePatternMap() {
                return this.buildTimePatternMap;
            }

            Builder setBuildTimePatternMap(ConfigPatternMap<Container> buildTimePatternMap) {
                this.buildTimePatternMap = buildTimePatternMap;
                return this;
            }

            ConfigPatternMap<Container> getBuildTimeRunTimePatternMap() {
                return this.buildTimeRunTimePatternMap;
            }

            Builder setBuildTimeRunTimePatternMap(ConfigPatternMap<Container> buildTimeRunTimePatternMap) {
                this.buildTimeRunTimePatternMap = buildTimeRunTimePatternMap;
                return this;
            }

            ConfigPatternMap<Container> getRunTimePatternMap() {
                return this.runTimePatternMap;
            }

            Builder setRunTimePatternMap(ConfigPatternMap<Container> runTimePatternMap) {
                this.runTimePatternMap = runTimePatternMap;
                return this;
            }

            List<RootDefinition> getAllRoots() {
                return this.allRoots;
            }

            Builder setAllRoots(List<RootDefinition> allRoots) {
                this.allRoots = allRoots;
                return this;
            }

            List<ConfigMappings.ConfigClass> getBuildTimeMappings() {
                return this.buildTimeMappings;
            }

            Builder setBuildTimeMappings(List<ConfigMappings.ConfigClass> buildTimeMappings) {
                this.buildTimeMappings = buildTimeMappings;
                return this;
            }

            List<ConfigMappings.ConfigClass> getBuildTimeRunTimeMappings() {
                return this.buildTimeRunTimeMappings;
            }

            Builder setBuildTimeRunTimeMappings(List<ConfigMappings.ConfigClass> buildTimeRunTimeMappings) {
                this.buildTimeRunTimeMappings = buildTimeRunTimeMappings;
                return this;
            }

            List<ConfigMappings.ConfigClass> getRunTimeMappings() {
                return this.runTimeMappings;
            }

            Builder setRunTimeMappings(List<ConfigMappings.ConfigClass> runTimeMappings) {
                this.runTimeMappings = runTimeMappings;
                return this;
            }

            Set<String> getUnknownBuildProperties() {
                return this.unknownBuildProperties;
            }

            Builder setUnknownBuildProperties(Set<String> unknownBuildProperties) {
                this.unknownBuildProperties = unknownBuildProperties;
                return this;
            }

            Builder setDeprecatedRuntimeProperties(Set<String> deprecatedRuntimeProperties) {
                this.deprecatedRuntimeProperties = deprecatedRuntimeProperties;
                return this;
            }

            Builder setBuildConfigTracker(ConfigTrackingInterceptor buildConfigTracker) {
                this.buildConfigTracker = buildConfigTracker;
                return this;
            }

            ReadResult createReadResult() {
                return new ReadResult(this);
            }
        }
    }

    final class ReadOperation {
        final SmallRyeConfig config;
        final ConfigTrackingInterceptor buildConfigTracker;
        final Set<String> processedNames = new HashSet<String>();
        final Map<Class<?>, Object> objectsByClass = new HashMap();
        final Map<String, String> allBuildTimeValues = new TreeMap<String, String>();
        final Map<String, String> buildTimeRunTimeValues = new TreeMap<String, String>();
        final Map<String, String> runTimeDefaultValues = new TreeMap<String, String>();
        final Map<String, String> runTimeValues = new TreeMap<String, String>();
        final Map<ConverterType, Converter<?>> convByType = new HashMap();

        ReadOperation(SmallRyeConfig config, ConfigTrackingInterceptor buildConfigTracker) {
            this.config = config;
            this.buildConfigTracker = buildConfigTracker;
        }

        ReadResult run() {
            StringBuilder nameBuilder = new StringBuilder();
            for (RootDefinition root : BuildTimeConfigurationReader.this.buildTimeVisibleRoots) {
                Object instance;
                Class<?> clazz = root.getConfigurationClass();
                try {
                    Constructor<?> cons = clazz.getDeclaredConstructor(new Class[0]);
                    cons.setAccessible(true);
                    instance = cons.newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    throw ReflectUtil.toError(e);
                }
                catch (IllegalAccessException e) {
                    throw ReflectUtil.toError(e);
                }
                catch (InvocationTargetException e) {
                    throw ReflectUtil.unwrapInvocationTargetException(e);
                }
                catch (NoSuchMethodException e) {
                    throw ReflectUtil.toError(e);
                }
                this.objectsByClass.put(clazz, instance);
                nameBuilder.append(root.getName());
                this.readConfigGroup(root, instance, nameBuilder);
                nameBuilder.setLength(0);
            }
            SmallRyeConfig runtimeConfig = this.getConfigForRuntimeRecording();
            this.allBuildTimeValues.putAll(ReadOperation.getDefaults(this.config, BuildTimeConfigurationReader.this.buildTimePatternMap));
            this.buildTimeRunTimeValues.putAll(ReadOperation.getDefaults(this.config, BuildTimeConfigurationReader.this.buildTimeRunTimePatternMap));
            this.runTimeDefaultValues.putAll(ReadOperation.getDefaults(runtimeConfig, BuildTimeConfigurationReader.this.runTimePatternMap));
            Set<String> registeredRoots = BuildTimeConfigurationReader.this.allRoots.stream().map(RootDefinition::getName).collect(Collectors.toSet());
            registeredRoots.add("quarkus");
            Set<String> allProperties = this.getAllProperties(registeredRoots);
            HashSet<String> unknownBuildProperties = new HashSet<String>();
            for (String propertyName : allProperties) {
                NameIterator ni;
                if (propertyName.equals("config_ordinal")) continue;
                if (BuildTimeConfigurationReader.this.deprecatedProperties.contains(propertyName)) {
                    log.warnf("The '%s' config property is deprecated and should not be used anymore", (Object)propertyName);
                }
                if ((ni = new NameIterator(propertyName)).hasNext() && PropertiesUtil.isPropertyInRoots((String)propertyName, registeredRoots)) {
                    Converter<?> converter;
                    Field field;
                    Map<String, Object> map;
                    String key;
                    ConfigValue configValue;
                    boolean knownProperty;
                    Container matched = BuildTimeConfigurationReader.this.buildTimePatternMap.match(ni);
                    boolean bl = knownProperty = matched != null;
                    if (matched instanceof FieldContainer) {
                        configValue = this.config.getConfigValue(propertyName);
                        if (configValue.getValue() != null) {
                            this.allBuildTimeValues.put(configValue.getNameProfiled(), configValue.getValue());
                            ni.goToEnd();
                            this.getGroup((FieldContainer)matched, ni);
                        }
                    } else if (matched != null) {
                        assert (matched instanceof MapContainer);
                        configValue = this.config.getConfigValue(propertyName);
                        if (configValue.getValue() != null) {
                            ni.goToEnd();
                            key = ni.getPreviousSegment();
                            map = this.getMap((MapContainer)matched, ni);
                            field = matched.findField();
                            converter = this.getConverter(this.config, field, ConverterType.of(field));
                            map.put(key, this.config.convertValue(configValue, converter));
                            this.allBuildTimeValues.put(configValue.getNameProfiled(), configValue.getValue());
                        }
                    }
                    ni.goToStart();
                    matched = BuildTimeConfigurationReader.this.buildTimeRunTimePatternMap.match(ni);
                    boolean bl2 = knownProperty = knownProperty || matched != null;
                    if (matched instanceof FieldContainer) {
                        configValue = this.config.getConfigValue(propertyName);
                        if (configValue.getValue() != null) {
                            ni.goToEnd();
                            this.getGroup((FieldContainer)matched, ni);
                            this.allBuildTimeValues.put(configValue.getNameProfiled(), configValue.getValue());
                            this.buildTimeRunTimeValues.put(configValue.getNameProfiled(), configValue.getValue());
                        }
                    } else if (matched != null) {
                        assert (matched instanceof MapContainer);
                        configValue = this.config.getConfigValue(propertyName);
                        if (configValue.getValue() != null) {
                            ni.goToEnd();
                            key = ni.getPreviousSegment();
                            map = this.getMap((MapContainer)matched, ni);
                            field = matched.findField();
                            converter = this.getConverter(this.config, field, ConverterType.of(field));
                            map.put(key, this.config.convertValue(configValue, converter));
                            this.allBuildTimeValues.put(configValue.getNameProfiled(), configValue.getValue());
                            this.buildTimeRunTimeValues.put(configValue.getNameProfiled(), configValue.getValue());
                        }
                    }
                    ni.goToStart();
                    matched = BuildTimeConfigurationReader.this.runTimePatternMap.match(ni);
                    boolean bl3 = knownProperty = knownProperty || matched != null;
                    if (matched != null && (configValue = (ConfigValue)Expressions.withoutExpansion(() -> runtimeConfig.getConfigValue(propertyName))).getValue() != null) {
                        this.runTimeValues.put(configValue.getNameProfiled(), configValue.getValue());
                    }
                    if (knownProperty) continue;
                    unknownBuildProperties.add(propertyName);
                    continue;
                }
                ConfigValue configValue = (ConfigValue)Expressions.withoutExpansion(() -> runtimeConfig.getConfigValue(propertyName));
                if (configValue.getValue() != null) {
                    this.runTimeValues.put(propertyName, configValue.getValue());
                }
                if (!PropertiesUtil.isPropertyQuarkusCompoundName((NameIterator)ni)) continue;
                unknownBuildProperties.add(propertyName);
            }
            this.config.getConfigSource("PropertiesConfigSource[source=Build system]").ifPresent(configSource -> unknownBuildProperties.removeAll(configSource.getPropertyNames()));
            for (ConfigMappings.ConfigClass mapping : BuildTimeConfigurationReader.this.buildTimeVisibleMappings) {
                this.objectsByClass.put(mapping.getKlass(), this.config.getConfigMapping(mapping.getKlass(), mapping.getPrefix()));
            }
            Set<PropertyName> buildTimeNames = ReadOperation.getMappingsNames(BuildTimeConfigurationReader.this.buildTimeMappings);
            Set<PropertyName> buildTimeRunTimeNames = ReadOperation.getMappingsNames(BuildTimeConfigurationReader.this.buildTimeRunTimeMappings);
            Set<PropertyName> runTimeNames = ReadOperation.getMappingsNames(BuildTimeConfigurationReader.this.runTimeMappings);
            for (String property : allProperties) {
                ConfigValue value;
                PropertyName name = new PropertyName(property);
                if (buildTimeNames.contains(name)) {
                    unknownBuildProperties.remove(property);
                    value = this.config.getConfigValue(property);
                    if (value.getRawValue() != null) {
                        this.allBuildTimeValues.put(value.getNameProfiled(), value.getRawValue());
                    }
                }
                if (buildTimeRunTimeNames.contains(name)) {
                    unknownBuildProperties.remove(property);
                    value = this.config.getConfigValue(property);
                    if (value.getRawValue() != null) {
                        this.allBuildTimeValues.put(value.getNameProfiled(), value.getRawValue());
                        this.buildTimeRunTimeValues.put(value.getNameProfiled(), value.getRawValue());
                    }
                }
                if (!runTimeNames.contains(name)) continue;
                unknownBuildProperties.remove(property);
                value = runtimeConfig.getConfigValue(property);
                if (value.getRawValue() == null) continue;
                this.runTimeValues.put(value.getNameProfiled(), value.getRawValue());
            }
            HashSet<String> relocatesOrFallbacks = new HashSet<String>();
            for (String unknownBuildProperty : unknownBuildProperties) {
                ConfigValue configValue = this.config.getConfigValue(unknownBuildProperty);
                if (unknownBuildProperties.contains(configValue.getName())) continue;
                relocatesOrFallbacks.add(unknownBuildProperty);
            }
            unknownBuildProperties.removeAll(relocatesOrFallbacks);
            return new ReadResult.Builder().setObjectsByClass(this.objectsByClass).setAllBuildTimeValues(this.allBuildTimeValues).setBuildTimeRunTimeValues(this.filterActiveProfileProperties(this.buildTimeRunTimeValues)).setRunTimeDefaultValues(this.filterActiveProfileProperties(this.runTimeDefaultValues)).setRuntimeValues(this.runTimeValues).setBuildTimePatternMap(BuildTimeConfigurationReader.this.buildTimePatternMap).setBuildTimeRunTimePatternMap(BuildTimeConfigurationReader.this.buildTimeRunTimePatternMap).setRunTimePatternMap(BuildTimeConfigurationReader.this.runTimePatternMap).setAllRoots(BuildTimeConfigurationReader.this.allRoots).setBuildTimeMappings(BuildTimeConfigurationReader.this.buildTimeMappings).setBuildTimeRunTimeMappings(BuildTimeConfigurationReader.this.buildTimeRunTimeMappings).setRunTimeMappings(BuildTimeConfigurationReader.this.runTimeMappings).setUnknownBuildProperties(unknownBuildProperties).setDeprecatedRuntimeProperties(BuildTimeConfigurationReader.this.deprecatedRuntimeProperties).setBuildConfigTracker(this.buildConfigTracker).createReadResult();
        }

        private Object getGroup(FieldContainer matched, NameIterator ni) {
            String key;
            boolean consume;
            ClassDefinition.ClassMember classMember = matched.getClassMember();
            ClassDefinition definition = matched.findEnclosingClass();
            Class<?> configurationClass = definition.getConfigurationClass();
            if (definition instanceof RootDefinition) {
                return this.objectsByClass.get(configurationClass);
            }
            Container parent = matched.getParent();
            boolean bl = consume = !classMember.getPropertyName().isEmpty();
            if (consume) {
                ni.previous();
            }
            if (parent instanceof FieldContainer) {
                FieldContainer parentClass = (FieldContainer)parent;
                Field field = parentClass.findField();
                Object enclosing = this.getGroup(parentClass, ni);
                if (consume) {
                    ni.next();
                }
                if (classMember instanceof ClassDefinition.GroupMember && ((ClassDefinition.GroupMember)classMember).isOptional()) {
                    Optional opt;
                    try {
                        opt = (Optional)field.get(enclosing);
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                    if (opt.isPresent()) {
                        return opt.get();
                    }
                    Object instance = this.recreateGroup(ni, definition, configurationClass);
                    try {
                        field.set(enclosing, Optional.of(instance));
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                    return instance;
                }
                try {
                    return field.get(enclosing);
                }
                catch (IllegalAccessException e) {
                    throw ReflectUtil.toError(e);
                }
            }
            assert (parent instanceof MapContainer);
            MapContainer parentMap = (MapContainer)parent;
            Map<String, Object> map = this.getMap(parentMap, ni);
            Object instance = map.get(key = ni.getPreviousSegment());
            if (instance == null) {
                instance = this.recreateGroup(ni, definition, configurationClass);
                map.put(key, instance);
            }
            if (consume) {
                ni.next();
            }
            return instance;
        }

        private Map<String, Object> getMap(MapContainer matched, NameIterator ni) {
            Container parent = matched.getParent();
            if (parent instanceof FieldContainer) {
                FieldContainer parentClass = (FieldContainer)parent;
                Field field = parentClass.findField();
                ni.previous();
                Object instance = this.getGroup(parentClass, ni);
                ni.next();
                try {
                    return this.getFieldAsMap(field, instance);
                }
                catch (IllegalAccessException e) {
                    throw ReflectUtil.toError(e);
                }
            }
            assert (parent instanceof MapContainer);
            ni.previous();
            Map<String, Object> map = this.getMap((MapContainer)parent, ni);
            String key = ni.getPreviousSegment();
            ni.next();
            Map<String, Object> instance = this.getAsMap(map, key);
            if (instance == null) {
                instance = new HashMap<String, Object>();
                map.put(key, instance);
            }
            return instance;
        }

        private Object recreateGroup(NameIterator ni, ClassDefinition definition, Class<?> configurationClass) {
            Object instance;
            try {
                instance = configurationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw ReflectUtil.toError(e);
            }
            catch (IllegalAccessException e) {
                throw ReflectUtil.toError(e);
            }
            catch (InvocationTargetException e) {
                throw ReflectUtil.unwrapInvocationTargetException(e);
            }
            catch (NoSuchMethodException e) {
                throw ReflectUtil.toError(e);
            }
            StringBuilder nameBuilder = new StringBuilder(ni.getAllPreviousSegments());
            this.readConfigGroup(definition, instance, nameBuilder);
            return instance;
        }

        private Map<String, Object> getAsMap(Map<String, Object> map, String key) {
            return (Map)map.get(key);
        }

        private Map<String, Object> getFieldAsMap(Field field, Object instance) throws IllegalAccessException {
            return (Map)field.get(instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readConfigGroup(ClassDefinition definition, Object instance, StringBuilder nameBuilder) {
            for (ClassDefinition.ClassMember member : definition.getMembers()) {
                Object nestedInstance;
                Field field = member.getField();
                if (member instanceof ClassDefinition.MapMember) {
                    try {
                        field.set(instance, new TreeMap());
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                }
                String propertyName = member.getPropertyName();
                if (member instanceof ClassDefinition.ItemMember) {
                    ClassDefinition.ItemMember leafMember = (ClassDefinition.ItemMember)member;
                    int len = nameBuilder.length();
                    try {
                        String fullName;
                        if (!propertyName.isEmpty()) {
                            nameBuilder.append('.').append(propertyName);
                        }
                        if (!this.processedNames.add(fullName = nameBuilder.toString())) continue;
                        this.readConfigValue(fullName, leafMember, instance);
                        continue;
                    }
                    finally {
                        nameBuilder.setLength(len);
                        continue;
                    }
                }
                assert (member instanceof ClassDefinition.GroupMember);
                ClassDefinition.GroupMember groupMember = (ClassDefinition.GroupMember)member;
                if (groupMember.isOptional()) {
                    try {
                        field.set(instance, Optional.empty());
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                }
                Class<?> clazz = groupMember.getGroupDefinition().getConfigurationClass();
                try {
                    nestedInstance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    throw ReflectUtil.toError(e);
                }
                catch (InvocationTargetException e) {
                    throw ReflectUtil.unwrapInvocationTargetException(e);
                }
                catch (NoSuchMethodException e) {
                    throw ReflectUtil.toError(e);
                }
                catch (IllegalAccessException e) {
                    throw ReflectUtil.toError(e);
                }
                try {
                    field.set(instance, nestedInstance);
                }
                catch (IllegalAccessException e) {
                    throw ReflectUtil.toError(e);
                }
                if (propertyName.isEmpty()) {
                    this.readConfigGroup(groupMember.getGroupDefinition(), nestedInstance, nameBuilder);
                    continue;
                }
                int len = nameBuilder.length();
                try {
                    nameBuilder.append('.').append(propertyName);
                    this.readConfigGroup(groupMember.getGroupDefinition(), nestedInstance, nameBuilder);
                }
                finally {
                    nameBuilder.setLength(len);
                }
            }
        }

        private void readConfigValue(String fullName, ClassDefinition.ItemMember member, Object instance) {
            Field field = member.getField();
            Converter<?> converter = this.getConverter(this.config, field, ConverterType.of(field));
            try {
                Object val = this.config.getValue(fullName, converter);
                field.set(instance, val);
            }
            catch (IllegalAccessException e) {
                throw ReflectUtil.toError(e);
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e, Collections.singleton(fullName));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Converter<?> getConverter(SmallRyeConfig config, Field field, ConverterType valueType) {
            Converter converter = this.convByType.get(valueType);
            if (converter != null) {
                return converter;
            }
            if (valueType instanceof ArrayOf) {
                ArrayOf arrayOf = (ArrayOf)valueType;
                converter = Converters.newArrayConverter(this.getConverter(config, field, arrayOf.getElementType()), arrayOf.getArrayType());
            } else if (valueType instanceof CollectionOf) {
                CollectionOf collectionOf = (CollectionOf)valueType;
                Class<?> collectionClass = collectionOf.getCollectionClass();
                Converter<?> nested = this.getConverter(config, field, collectionOf.getElementType());
                if (collectionClass == List.class) {
                    converter = Converters.newCollectionConverter(nested, (IntFunction)ConfigUtils.listFactory());
                } else if (collectionClass == Set.class) {
                    converter = Converters.newCollectionConverter(nested, (IntFunction)ConfigUtils.setFactory());
                } else {
                    if (collectionClass != SortedSet.class) throw ReflectUtil.reportError(field, "Unsupported configuration collection type: %s", collectionClass);
                    converter = Converters.newCollectionConverter(nested, (IntFunction)ConfigUtils.sortedSetFactory());
                }
            } else if (valueType instanceof Leaf) {
                Leaf leaf = (Leaf)valueType;
                Class<Converter<?>> convertWith = leaf.getConvertWith();
                if (convertWith != null) {
                    try {
                        if (convertWith == HyphenateEnumConverter.class.asSubclass(Converter.class)) {
                            Constructor<Converter<?>> ctor = convertWith.getConstructor(Class.class);
                            converter = ctor.newInstance(valueType.getLeafType());
                        }
                        Constructor<Converter<?>> ctor = convertWith.getConstructor(new Class[0]);
                        converter = ctor.newInstance(new Object[0]);
                    }
                    catch (InstantiationException e) {
                        throw ReflectUtil.toError(e);
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                    catch (InvocationTargetException e) {
                        throw ReflectUtil.unwrapInvocationTargetException(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw ReflectUtil.toError(e);
                    }
                } else {
                    converter = config.requireConverter(leaf.getLeafType());
                }
            } else if (valueType instanceof LowerBoundCheckOf) {
                converter = this.getConverter(config, field, ((LowerBoundCheckOf)valueType).getClassConverterType());
            } else if (valueType instanceof UpperBoundCheckOf) {
                converter = this.getConverter(config, field, ((UpperBoundCheckOf)valueType).getClassConverterType());
            } else if (valueType instanceof MinMaxValidated) {
                MinMaxValidated minMaxValidated = (MinMaxValidated)valueType;
                String min = minMaxValidated.getMin();
                boolean minInclusive = minMaxValidated.isMinInclusive();
                String max = minMaxValidated.getMax();
                boolean maxInclusive = minMaxValidated.isMaxInclusive();
                Converter<?> nestedConverter = this.getConverter(config, field, minMaxValidated.getNestedType());
                if (min != null) {
                    converter = max != null ? Converters.rangeValueStringConverter(nestedConverter, (String)min, (boolean)minInclusive, (String)max, (boolean)maxInclusive) : Converters.minimumValueStringConverter(nestedConverter, (String)min, (boolean)minInclusive);
                } else {
                    assert (min == null && max != null);
                    converter = Converters.maximumValueStringConverter(nestedConverter, (String)max, (boolean)maxInclusive);
                }
            } else if (valueType instanceof OptionalOf) {
                OptionalOf optionalOf = (OptionalOf)valueType;
                converter = Converters.newOptionalConverter(this.getConverter(config, field, optionalOf.getNestedType()));
            } else {
                if (!(valueType instanceof PatternValidated)) throw Assert.unreachableCode();
                PatternValidated patternValidated = (PatternValidated)valueType;
                converter = Converters.patternValidatingConverter(this.getConverter(config, field, patternValidated.getNestedType()), (String)patternValidated.getPatternString());
            }
            this.convByType.put(valueType, converter);
            return converter;
        }

        private Set<String> getAllProperties(Set<String> registeredRoots) {
            final HashSet<String> sourcesProperties = new HashSet<String>();
            for (ConfigSource configSource : this.config.getConfigSources()) {
                if (configSource instanceof SysPropConfigSource || configSource instanceof EnvConfigSource || "PropertiesConfigSource[source=Build system]".equals(configSource.getName())) {
                    for (Object property : configSource.getPropertyNames()) {
                        int profileDot;
                        String unprofiledProperty = property;
                        if (((String)property).startsWith("%") && (profileDot = ((String)property).indexOf(46)) != -1) {
                            unprofiledProperty = ((String)property).substring(profileDot + 1);
                        }
                        if (!PropertiesUtil.isPropertyInRoots((String)unprofiledProperty, registeredRoots)) continue;
                        sourcesProperties.add((String)property);
                    }
                    continue;
                }
                sourcesProperties.addAll(configSource.getPropertyNames());
            }
            AbstractConfigSource sourceProperties = new AbstractConfigSource("SourceProperties", 100){

                public Set<String> getPropertyNames() {
                    return sourcesProperties;
                }

                public String getValue(String propertyName) {
                    return ReadOperation.this.config.getRawValue(propertyName);
                }
            };
            HashSet<String> properties = new HashSet<String>();
            SmallRyeConfigBuilder builder = ConfigUtils.emptyConfigBuilder();
            builder.getSources().clear();
            builder.getSourceProviders().clear();
            builder.setAddDefaultSources(false).withInterceptors(new ConfigSourceInterceptor[]{ConfigCompatibility.FrontEnd.nonLoggingInstance(), ConfigCompatibility.BackEnd.instance()}).addDiscoveredCustomizers().withProfiles(this.config.getProfiles()).withSources(new ConfigSource[]{sourceProperties});
            for (String property : builder.build().getPropertyNames()) {
                properties.add(property);
            }
            builder = ConfigUtils.emptyConfigBuilder();
            builder.getProfiles().add("");
            builder.getSources().clear();
            builder.getSourceProviders().clear();
            builder.setAddDefaultSources(false).withInterceptors(new ConfigSourceInterceptor[]{ConfigCompatibility.FrontEnd.nonLoggingInstance(), ConfigCompatibility.BackEnd.instance()}).addDiscoveredCustomizers().withSources(new ConfigSource[]{sourceProperties});
            List profiles = this.config.getProfiles();
            for (String property : builder.build().getPropertyNames()) {
                String activeProperty = ProfileConfigSourceInterceptor.activeName((String)property, (List)profiles);
                if (activeProperty.equals("quarkus.config.profile.parent") && !activeProperty.equals(property)) {
                    properties.remove(activeProperty);
                }
                properties.add(property);
            }
            return properties;
        }

        private SmallRyeConfig getConfigForRuntimeRecording() {
            SmallRyeConfigBuilder builder = ConfigUtils.emptyConfigBuilder();
            builder.getProfiles().add("");
            builder.getSources().clear();
            builder.getSourceProviders().clear();
            builder.withCustomizers(new SmallRyeConfigBuilderCustomizer[]{new SmallRyeConfigBuilderCustomizer(){

                public void configBuilder(SmallRyeConfigBuilder builder) {
                    builder.getMappingsBuilder().getMappings().clear();
                }

                public int priority() {
                    return Integer.MAX_VALUE;
                }
            }});
            builder.setAddDefaultSources(false).addDiscoveredCustomizers().addPropertiesSources();
            for (ConfigSource configSource : this.config.getConfigSources()) {
                if (configSource instanceof SysPropConfigSource || configSource instanceof EnvConfigSource || "PropertiesConfigSource[source=Build system]".equals(configSource.getName())) continue;
                builder.withSources(new ConfigSource[]{configSource});
            }
            builder.withSources(new ConfigSource[]{new AbstractConfigSource("Profiles", Integer.MAX_VALUE){
                private final Set<String> profiles;
                {
                    this.profiles = Set.of("quarkus.profile", "quarkus.config.profile.parent", "quarkus.test.profile", "smallrye.config.profile", "smallrye.config.profile.parent", "mp.config.profile");
                }

                public Set<String> getPropertyNames() {
                    return Collections.emptySet();
                }

                public String getValue(String propertyName) {
                    if (this.profiles.contains(propertyName)) {
                        return ReadOperation.this.config.getConfigValue(propertyName).getValue();
                    }
                    return null;
                }
            }});
            return builder.build();
        }

        private Map<String, String> filterActiveProfileProperties(Map<String, String> properties) {
            HashSet<String> propertiesToRemove = new HashSet<String>();
            for (String property : properties.keySet()) {
                for (String profile : this.config.getProfiles()) {
                    String profiledProperty = "%" + profile + "." + property;
                    if (!properties.containsKey(profiledProperty)) continue;
                    propertiesToRemove.add(property);
                }
            }
            properties.keySet().removeAll(propertiesToRemove);
            return properties;
        }

        private static Map<String, String> getDefaults(SmallRyeConfig config, ConfigPatternMap<Container> patternMap) {
            TreeMap<String, String> defaultValues = new TreeMap<String, String>();
            ReadOperation.getDefaults(config, defaultValues, new StringBuilder(), patternMap);
            return defaultValues;
        }

        private static void getDefaults(SmallRyeConfig config, Map<String, String> defaultValues, StringBuilder propertyName, ConfigPatternMap<Container> patternMap) {
            Container matched = patternMap.getMatched();
            if (matched != null) {
                ClassDefinition.ClassMember member = matched.getClassMember();
                assert (member instanceof ClassDefinition.ItemMember);
                ClassDefinition.ItemMember itemMember = (ClassDefinition.ItemMember)member;
                String defaultValue = itemMember.getDefaultValue();
                if (defaultValue != null) {
                    ConfigValue configValue = config.getConfigValue(propertyName.toString());
                    if (configValue.getValue() != null && !configValue.getName().equals(propertyName.toString())) {
                        defaultValues.put(propertyName.toString(), configValue.getValue());
                    } else {
                        defaultValues.put(propertyName.toString(), defaultValue);
                    }
                }
            }
            if (propertyName.length() != 0 && patternMap.childNames().iterator().hasNext()) {
                propertyName.append(".");
            }
            for (String childName : patternMap.childNames()) {
                ReadOperation.getDefaults(config, defaultValues, new StringBuilder(propertyName).append(childName.equals("{*}") ? "*" : childName), patternMap.getChild(childName));
            }
        }

        private static Set<PropertyName> getMappingsNames(List<ConfigMappings.ConfigClass> configMappings) {
            HashSet names = new HashSet();
            for (ConfigMappings.ConfigClass configMapping : configMappings) {
                names.addAll(ConfigMappings.getProperties((ConfigMappings.ConfigClass)configMapping).keySet());
            }
            return PropertiesUtil.toPropertyNames(names);
        }
    }
}

