/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class DecorateStackUtil {
    public static String getDecoratedString(Throwable throwable, String srcMainJava, List<String> knowClasses) {
        if (srcMainJava != null) {
            return DecorateStackUtil.getDecoratedString(throwable, Path.of(srcMainJava, new String[0]), knowClasses);
        }
        return null;
    }

    public static String getDecoratedString(Throwable throwable, Path srcMainJava, List<String> knowClasses) {
        if (knowClasses != null && !knowClasses.isEmpty() && throwable != null) {
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                String decoratedString;
                StackTraceElement elem = stackTrace[i];
                if (!knowClasses.contains(elem.getClassName()) || (decoratedString = DecorateStackUtil.getDecoratedString(srcMainJava, elem)) == null) continue;
                return decoratedString;
            }
        }
        return null;
    }

    public static String getDecoratedString(Path srcMainJava, StackTraceElement stackTraceElement) {
        int lineNumber = stackTraceElement.getLineNumber();
        if (lineNumber > 0 && srcMainJava != null) {
            String fullJavaFileName = DecorateStackUtil.getFullPath(stackTraceElement.getClassName(), stackTraceElement.getFileName());
            Path f = srcMainJava.resolve(fullJavaFileName);
            try {
                List<String> contextLines = DecorateStackUtil.getRelatedLinesInSource(f, lineNumber, 2);
                if (contextLines != null) {
                    String header = "Exception in " + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber();
                    return header + "\n" + String.join((CharSequence)"\n", contextLines);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static List<String> getRelatedLinesInSource(Path filePath, int lineNumber, int contextRange) throws IOException {
        if (Files.exists(filePath, new LinkOption[0])) {
            ArrayList<String> resultLines = new ArrayList<String>();
            ArrayDeque<CallSite> contextQueue = new ArrayDeque<CallSite>(2 * contextRange + 1);
            try (BufferedReader reader = Files.newBufferedReader(filePath);){
                String line;
                int currentLine = 1;
                while ((line = reader.readLine()) != null) {
                    if (currentLine >= lineNumber - contextRange) {
                        Object ln = String.valueOf(currentLine);
                        ln = currentLine == lineNumber ? "\u2192 " + (String)ln + "  " : "  " + (String)ln + "  ";
                        contextQueue.add((CallSite)((Object)("\t" + (String)ln + line)));
                    }
                    if (currentLine >= lineNumber + contextRange) break;
                    ++currentLine;
                }
                resultLines.addAll(contextQueue);
            }
            return resultLines;
        }
        return null;
    }

    private static String getFullPath(String fullClassName, String fileName) {
        int lastDotIndex = fullClassName.lastIndexOf(".");
        String packageName = fullClassName.substring(0, lastDotIndex);
        String path = packageName.replace('.', '/');
        return path + "/" + fileName;
    }
}

