/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.keycloak;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.List;

public final class KeycloakDevServicesRequiredBuildItem
extends MultiBuildItem {
    private final Capability capability;

    private KeycloakDevServicesRequiredBuildItem(Capability capability) {
        this.capability = capability;
    }

    static boolean setOidcConfigProperties(List<KeycloakDevServicesRequiredBuildItem> items) {
        return items.stream().anyMatch(i -> i.capability == Capability.OIDC);
    }

    static boolean setOidcClientConfigProperties(List<KeycloakDevServicesRequiredBuildItem> items) {
        boolean serverUrlOrTokenPathConfigured = ConfigUtils.isPropertyNonEmpty((String)"quarkus.oidc-client.auth-server-url") || ConfigUtils.isPropertyNonEmpty((String)"quarkus.oidc-client.token-path");
        return !serverUrlOrTokenPathConfigured && items.stream().anyMatch(i -> i.capability == Capability.OIDC_CLIENT);
    }

    public static KeycloakDevServicesRequiredBuildItem requireDevServiceForOidc() {
        return new KeycloakDevServicesRequiredBuildItem(Capability.OIDC);
    }

    public static KeycloakDevServicesRequiredBuildItem requireDevServiceForOidcClient() {
        return new KeycloakDevServicesRequiredBuildItem(Capability.OIDC_CLIENT);
    }

    static enum Capability {
        OIDC,
        OIDC_CLIENT;

    }
}

