/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.extensions;

import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.extensions.ExtensionInstallPlan;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;

public interface ExtensionManager {
    public BuildTool getBuildTool();

    public Collection<ArtifactCoords> getInstalledPlatforms() throws IOException;

    public Collection<ArtifactCoords> getInstalled() throws IOException;

    default public boolean isInstalled(ArtifactKey key) throws IOException {
        return this.getInstalled().stream().anyMatch(i -> Objects.equals(i.getKey(), key));
    }

    public InstallResult install(Collection<ArtifactCoords> var1) throws IOException;

    public InstallResult install(ExtensionInstallPlan var1) throws IOException;

    public UninstallResult uninstall(Collection<ArtifactKey> var1) throws IOException;

    public static class UninstallResult {
        private final Collection<ArtifactKey> uninstalled;

        public UninstallResult(Collection<ArtifactKey> uninstalled) {
            this.uninstalled = uninstalled;
        }

        public Collection<ArtifactKey> getUninstalled() {
            return this.uninstalled;
        }

        public boolean isSourceUpdated() {
            return this.uninstalled.size() > 0;
        }
    }

    public static class InstallResult {
        private final Collection<ArtifactCoords> installed;

        public InstallResult(Collection<ArtifactCoords> installed) {
            this.installed = installed;
        }

        public Collection<ArtifactCoords> getInstalled() {
            return this.installed;
        }

        public boolean isSourceUpdated() {
            return this.installed.size() > 0;
        }
    }
}

