/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.ProjectInfoCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import java.util.HashMap;
import java.util.Objects;

public class ProjectInfo {
    public static final String APP_MODEL = "quarkus.project-info.app-model";
    public static final String PER_MODULE = "quarkus.project-info.per-module";
    private final QuarkusCommandInvocation invocation;
    private final ProjectInfoCommandHandler handler = new ProjectInfoCommandHandler();

    public ProjectInfo(QuarkusProject quarkusProject) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject);
    }

    public ProjectInfo(QuarkusProject quarkusProject, MessageWriter messageWriter) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject, new HashMap<String, Object>(), messageWriter);
    }

    public ProjectInfo appModel(ApplicationModel applicationModel) {
        this.invocation.setValue(APP_MODEL, Objects.requireNonNull(applicationModel, "applicationModel is required"));
        return this;
    }

    public ProjectInfo perModule(boolean perModule) {
        this.invocation.setValue(PER_MODULE, perModule);
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        return this.handler.execute(this.invocation);
    }
}

