/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import java.nio.file.Path;
import java.util.Set;
import java.util.function.Function;

public class PluginManagerSettings {
    public static String DEFAULT_PLUGIN_PREFIX = "quarkus";
    public static String FALLBACK_REMOTE_JBANG_CATALOG = "quarkusio";
    public static String[] DEFAULT_REMOTE_JBANG_CATALOGS = new String[0];
    public static Function<Path, Path> DEFAULT_RELATIVE_PATH_FUNC = p -> p.resolve(".quarkus").resolve("cli").resolve("plugins").resolve("quarkus-cli-catalog.json");
    private final boolean interactiveMode;
    private final String pluginPrefix;
    private final String fallbackJBangCatalog;
    private final String[] remoteJBangCatalogs;
    private final Function<Path, Path> toRelativePath;

    public PluginManagerSettings(boolean interactiveMode, String pluginPrefix, String fallbackJBangCatalog, String[] remoteJBangCatalogs, Function<Path, Path> toRelativePath) {
        this.interactiveMode = interactiveMode;
        this.pluginPrefix = pluginPrefix;
        this.fallbackJBangCatalog = fallbackJBangCatalog;
        this.remoteJBangCatalogs = remoteJBangCatalogs;
        this.toRelativePath = toRelativePath;
    }

    public static PluginManagerSettings defaultSettings() {
        return new PluginManagerSettings(false, DEFAULT_PLUGIN_PREFIX, FALLBACK_REMOTE_JBANG_CATALOG, DEFAULT_REMOTE_JBANG_CATALOGS, DEFAULT_RELATIVE_PATH_FUNC);
    }

    public PluginManagerSettings withPluignPrefix(String pluginPrefix) {
        return new PluginManagerSettings(this.interactiveMode, pluginPrefix, this.fallbackJBangCatalog, this.remoteJBangCatalogs, this.toRelativePath);
    }

    public PluginManagerSettings withCatalogs(Set<String> remoteJBangCatalogs) {
        return new PluginManagerSettings(this.interactiveMode, this.pluginPrefix, this.fallbackJBangCatalog, remoteJBangCatalogs.toArray(new String[0]), this.toRelativePath);
    }

    public PluginManagerSettings withCatalogs(String ... remoteJBangCatalogs) {
        return new PluginManagerSettings(this.interactiveMode, this.pluginPrefix, this.fallbackJBangCatalog, remoteJBangCatalogs, this.toRelativePath);
    }

    public PluginManagerSettings withInteractivetMode(boolean interactiveMode) {
        return new PluginManagerSettings(interactiveMode, this.pluginPrefix, this.fallbackJBangCatalog, this.remoteJBangCatalogs, this.toRelativePath);
    }

    public String getPluginPrefix() {
        return this.pluginPrefix;
    }

    public String getFallbackJBangCatalog() {
        return this.fallbackJBangCatalog;
    }

    public String[] getRemoteJBangCatalogs() {
        return this.remoteJBangCatalogs;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public Function<Path, Path> getToRelativePath() {
        return this.toRelativePath;
    }
}

