/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.runtime;

import java.util.HashSet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.Roles;

@ApplicationScoped
public class DefaultRoleDecoder
implements RoleDecoder {
    private static final String DEFAULT_ATTRIBUTE_NAME = "groups";
    @Inject
    private Instance<RoleDecoder> instances;

    public Roles decodeRoles(AuthorizationIdentity authorizationIdentity) {
        RoleDecoder delegate = this.getDelegate();
        if (delegate == null) {
            return this.fromDefaultAttribute(authorizationIdentity);
        }
        return delegate.decodeRoles(authorizationIdentity);
    }

    private Roles fromDefaultAttribute(AuthorizationIdentity authorizationIdentity) {
        Attributes.Entry groups = authorizationIdentity.getAttributes().get(DEFAULT_ATTRIBUTE_NAME);
        if (groups == null) {
            return Roles.NONE;
        }
        return Roles.fromSet(new HashSet(groups));
    }

    private RoleDecoder getDelegate() {
        return this.instances.stream().filter(roleDecoder -> !DefaultRoleDecoder.class.isInstance(roleDecoder)).findAny().orElse(null);
    }
}

