/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
@Named
public class BootstrapWorkspaceProvider {
    private final Path base;
    private boolean initialized;
    private LocalProject origin;
    private final boolean honourAlternatePomFile;

    static BootstrapWorkspaceProvider newInstance(String dirName) {
        return new BootstrapWorkspaceProvider(dirName, false);
    }

    public BootstrapWorkspaceProvider() {
        this("", true);
    }

    private BootstrapWorkspaceProvider(String dirName, boolean honourAlternatePomFile) {
        this.honourAlternatePomFile = honourAlternatePomFile;
        this.base = Paths.get(dirName, new String[0]).normalize().toAbsolutePath();
    }

    public LocalProject origin() {
        if (!this.initialized) {
            Path modulePath = this.base;
            String alternatePomParam = BootstrapMavenOptions.newInstance().getOptionValue("f");
            if (alternatePomParam != null && this.honourAlternatePomFile) {
                Path path = Paths.get(alternatePomParam, new String[0]);
                modulePath = path.isAbsolute() ? path : this.base.resolve(path);
            }
            try {
                this.origin = LocalProject.loadWorkspace((Path)modulePath);
            }
            catch (BootstrapMavenException e) {
                Logger.getLogger(BootstrapWorkspaceProvider.class).warn((Object)("Failed to load workspace for " + modulePath));
            }
            this.initialized = true;
        }
        return this.origin;
    }

    public LocalWorkspace workspace() {
        LocalProject origin = this.origin();
        return origin == null ? null : origin.getWorkspace();
    }

    public LocalProject getProject(String groupId, String artifactId) {
        LocalWorkspace workspace = this.workspace();
        return workspace == null ? null : workspace.getProject(groupId, artifactId);
    }
}

