/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.scanner;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigGroup;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigProperty;
import io.quarkus.annotation.processor.documentation.config.discovery.EnumDefinition;
import io.quarkus.annotation.processor.documentation.config.discovery.ResolvedType;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigAnnotationListener;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class AbstractConfigListener
implements ConfigAnnotationListener {
    protected final Config config;
    protected final Utils utils;
    protected final ConfigCollector configCollector;

    protected AbstractConfigListener(Config config, Utils utils, ConfigCollector configCollector) {
        this.config = config;
        this.utils = utils;
        this.configCollector = configCollector;
    }

    @Override
    public Optional<DiscoveryConfigGroup> onConfigGroup(TypeElement configGroup) {
        DiscoveryConfigGroup discoveryConfigGroup = new DiscoveryConfigGroup(this.config.getExtension(), this.utils.element().getBinaryName(configGroup), configGroup.getQualifiedName().toString(), configGroup.getKind() == ElementKind.INTERFACE);
        this.configCollector.addResolvedConfigGroup(discoveryConfigGroup);
        return Optional.of(discoveryConfigGroup);
    }

    @Override
    public void onResolvedEnum(TypeElement enumTypeElement) {
        LinkedHashMap<String, EnumDefinition.EnumConstant> enumConstants = new LinkedHashMap<String, EnumDefinition.EnumConstant>();
        for (Element element : enumTypeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            String explicitValue = null;
            Map<String, AnnotationMirror> annotations = this.utils.element().getAnnotations(element);
            AnnotationMirror configDocEnumValue = annotations.get("io.quarkus.runtime.annotations.ConfigDocEnumValue");
            if (configDocEnumValue != null) {
                Map<String, Object> enumValueValues = this.utils.element().getAnnotationValues(configDocEnumValue);
                explicitValue = (String)enumValueValues.get("value");
            }
            enumConstants.put(element.getSimpleName().toString(), new EnumDefinition.EnumConstant(explicitValue));
        }
        EnumDefinition enumDefinition = new EnumDefinition(enumTypeElement.getQualifiedName().toString(), enumConstants);
        this.configCollector.addResolvedEnum(enumDefinition);
    }

    protected void handleCommonPropertyAnnotations(DiscoveryConfigProperty.Builder builder, Map<String, AnnotationMirror> propertyAnnotations, ResolvedType resolvedType, String sourceElementName) {
        Boolean enforceHyphenateValues;
        AnnotationMirror configDocEnum;
        AnnotationMirror configDocSectionAnnotation;
        AnnotationMirror deprecatedAnnotation = propertyAnnotations.get(Deprecated.class.getName());
        if (deprecatedAnnotation != null) {
            String since = (String)this.utils.element().getAnnotationValues(deprecatedAnnotation).get("since");
            builder.deprecated(since, null, null);
        }
        if ((configDocSectionAnnotation = propertyAnnotations.get("io.quarkus.runtime.annotations.ConfigDocSection")) != null) {
            Boolean sectionGenerated = (Boolean)this.utils.element().getAnnotationValues(configDocSectionAnnotation).get("generated");
            if (sectionGenerated != null && sectionGenerated.booleanValue()) {
                builder.section(true);
            } else {
                builder.section(false);
            }
        }
        if ((configDocEnum = propertyAnnotations.get("io.quarkus.runtime.annotations.ConfigDocEnum")) != null && (enforceHyphenateValues = (Boolean)this.utils.element().getAnnotationValues(configDocEnum).get("enforceHyphenateValues")) != null && enforceHyphenateValues.booleanValue()) {
            builder.enforceHyphenateEnumValues();
        }
    }
}

