/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.scanner;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigGroup;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigProperty;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigRoot;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryRootElement;
import io.quarkus.annotation.processor.documentation.config.discovery.ResolvedType;
import io.quarkus.annotation.processor.documentation.config.model.ConfigPhase;
import io.quarkus.annotation.processor.documentation.config.model.SourceElementType;
import io.quarkus.annotation.processor.documentation.config.scanner.AbstractConfigListener;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.documentation.config.util.ConfigNamingUtil;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Strings;
import io.quarkus.annotation.processor.util.Utils;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class LegacyConfigRootListener
extends AbstractConfigListener {
    LegacyConfigRootListener(Config config, Utils utils, ConfigCollector configCollector) {
        super(config, utils, configCollector);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Optional<DiscoveryConfigRoot> onConfigRoot(TypeElement configRoot) {
        void var10_18;
        void var8_10;
        if (this.config.getExtension().isMixedModule() && configRoot.getKind() == ElementKind.INTERFACE) {
            return Optional.empty();
        }
        String prefix = "quarkus";
        ConfigPhase configPhase = ConfigPhase.BUILD_TIME;
        AnnotationMirror configRootAnnotation = null;
        AnnotationMirror configDocPrefixAnnotation = null;
        AnnotationMirror configDocFileNameAnnotation = null;
        for (AnnotationMirror annotationMirror : configRoot.getAnnotationMirrors()) {
            String annotationName = this.utils.element().getQualifiedName(annotationMirror.getAnnotationType());
            if (annotationName.equals("io.quarkus.runtime.annotations.ConfigRoot")) {
                configRootAnnotation = annotationMirror;
                continue;
            }
            if (annotationName.equals("io.quarkus.runtime.annotations.ConfigDocPrefix")) {
                configDocPrefixAnnotation = annotationMirror;
                continue;
            }
            if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigDocFilename")) continue;
            configDocFileNameAnnotation = annotationMirror;
        }
        if (configRootAnnotation == null) {
            throw new IllegalStateException("@ConfigRoot is missing on " + configRoot);
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = configRootAnnotation.getElementValues();
        String string = "<<hyphenated element name>>";
        for (Map.Entry entry : elementValues.entrySet()) {
            String string2 = ((ExecutableElement)entry.getKey()).toString();
            String string3 = ((AnnotationValue)entry.getValue()).getValue().toString();
            if ("name()".equals(string2)) {
                String string4 = string3;
                continue;
            }
            if ("phase()".equals(string2)) {
                configPhase = ConfigPhase.valueOf(string3);
                continue;
            }
            if (!"prefix()".equals(string2)) continue;
            prefix = string3;
        }
        String overriddenDocPrefix = null;
        if (configDocPrefixAnnotation != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : configDocPrefixAnnotation.getElementValues().entrySet()) {
                if (!"value()".equals(entry.getKey().toString())) continue;
                overriddenDocPrefix = entry.getValue().getValue().toString();
                break;
            }
        }
        Object var10_16 = null;
        if (configDocFileNameAnnotation != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : configDocFileNameAnnotation.getElementValues().entrySet()) {
                if (!"value()".equals(entry.getKey().toString())) continue;
                String string5 = entry.getValue().getValue().toString();
                break;
            }
        }
        String string6 = ConfigNamingUtil.getRootPrefix(prefix, (String)var8_10, configRoot.getSimpleName().toString(), configPhase);
        String string7 = this.utils.element().getBinaryName(configRoot);
        DiscoveryConfigRoot discoveryConfigRoot = new DiscoveryConfigRoot(this.config.getExtension(), string6, overriddenDocPrefix, string7, configRoot.getQualifiedName().toString(), configPhase, (String)var10_18, false);
        this.configCollector.addConfigRoot(discoveryConfigRoot);
        return Optional.of(discoveryConfigRoot);
    }

    @Override
    public void onEnclosedField(DiscoveryRootElement discoveryRootElement, TypeElement clazz, VariableElement field, ResolvedType resolvedType) {
        if (this.config.getExtension().isMixedModule() && discoveryRootElement.isConfigMapping()) {
            return;
        }
        Map<String, AnnotationMirror> fieldAnnotations = this.utils.element().getAnnotations(field);
        String sourceElementName = field.getSimpleName().toString();
        String name = ConfigNamingUtil.hyphenate(sourceElementName);
        DiscoveryConfigProperty.Builder builder = DiscoveryConfigProperty.builder(clazz.getQualifiedName().toString(), sourceElementName, SourceElementType.FIELD, resolvedType);
        AnnotationMirror configItemAnnotation = fieldAnnotations.get("io.quarkus.runtime.annotations.ConfigItem");
        if (configItemAnnotation != null) {
            String configItemDefaultValueForDoc;
            String configItemDefaultValue;
            Map<String, Object> configItemValues = this.utils.element().getAnnotationValues(configItemAnnotation);
            String configItemName = (String)configItemValues.get("name");
            if (configItemName != null && !"<<hyphenated element name>>".equals(configItemName)) {
                name = configItemName;
            }
            if ((configItemDefaultValue = (String)configItemValues.get("defaultValue")) != null && !"<<no default>>".equals(configItemDefaultValue)) {
                builder.defaultValue(configItemDefaultValue);
            }
            if (!Strings.isEmpty(configItemDefaultValueForDoc = (String)configItemValues.get("defaultValueDocumentation"))) {
                builder.defaultValueForDoc(configItemDefaultValueForDoc);
            } else {
                AnnotationMirror configDocDefaultAnnotation = fieldAnnotations.get("io.quarkus.runtime.annotations.ConfigDocDefault");
                if (configDocDefaultAnnotation != null) {
                    builder.defaultValueForDoc(configDocDefaultAnnotation.getElementValues().values().iterator().next().getValue().toString());
                }
            }
        }
        builder.name(name);
        if (resolvedType.isMap()) {
            String mapKey = ConfigNamingUtil.hyphenate(sourceElementName);
            AnnotationMirror configDocMapKeyAnnotation = fieldAnnotations.get("io.quarkus.runtime.annotations.ConfigDocMapKey");
            if (configDocMapKeyAnnotation != null) {
                mapKey = configDocMapKeyAnnotation.getElementValues().values().iterator().next().getValue().toString();
            }
            builder.mapKey(mapKey);
        }
        if (fieldAnnotations.containsKey("io.quarkus.runtime.annotations.DefaultConverter") || fieldAnnotations.containsKey("io.quarkus.runtime.annotations.ConvertWith")) {
            builder.converted();
        }
        this.handleCommonPropertyAnnotations(builder, fieldAnnotations, resolvedType, sourceElementName);
        discoveryRootElement.addProperty(builder.build());
    }

    @Override
    @Deprecated(forRemoval=true)
    public Optional<DiscoveryConfigGroup> onConfigGroup(TypeElement configGroup) {
        if (this.config.getExtension().isMixedModule() && configGroup.getKind() == ElementKind.INTERFACE) {
            return Optional.empty();
        }
        return super.onConfigGroup(configGroup);
    }
}

