/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

final class JavaDocParser {
    private static final Pattern START_OF_LINE = Pattern.compile("^", 8);
    private static final Pattern REPLACE_WINDOWS_EOL = Pattern.compile("\r\n");
    private static final Pattern REPLACE_MACOS_EOL = Pattern.compile("\r");
    private static final Pattern STARTING_SPACE = Pattern.compile("^ +");
    private static final String BACKTICK = "`";
    private static final String HASH = "#";
    private static final String STAR = "*";
    private static final String S_NODE = "s";
    private static final String UNDERSCORE = "_";
    private static final String NEW_LINE = "\n";
    private static final String LINK_NODE = "a";
    private static final String BOLD_NODE = "b";
    private static final String STRONG_NODE = "strong";
    private static final String BIG_NODE = "big";
    private static final String CODE_NODE = "code";
    private static final String DEL_NODE = "del";
    private static final String ITALICS_NODE = "i";
    private static final String EMPHASIS_NODE = "em";
    private static final String TEXT_NODE = "#text";
    private static final String UNDERLINE_NODE = "u";
    private static final String NEW_LINE_NODE = "br";
    private static final String PARAGRAPH_NODE = "p";
    private static final String SMALL_NODE = "small";
    private static final String LIST_ITEM_NODE = "li";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String STRIKE_NODE = "strike";
    private static final String SUB_SCRIPT_NODE = "sub";
    private static final String ORDERED_LIST_NODE = "ol";
    private static final String SUPER_SCRIPT_NODE = "sup";
    private static final String UN_ORDERED_LIST_NODE = "ul";
    private static final String PREFORMATED_NODE = "pre";
    private static final String BLOCKQUOTE_NODE = "blockquote";
    private static final String BIG_ASCIDOC_STYLE = "[.big]";
    private static final String LINK_ATTRIBUTE_FORMAT = "[%s]";
    private static final String SUB_SCRIPT_ASCIDOC_STYLE = "~";
    private static final String SUPER_SCRIPT_ASCIDOC_STYLE = "^";
    private static final String SMALL_ASCIDOC_STYLE = "[.small]";
    private static final String ORDERED_LIST_ITEM_ASCIDOC_STYLE = " . ";
    private static final String UNORDERED_LIST_ITEM_ASCIDOC_STYLE = " - ";
    private static final String UNDERLINE_ASCIDOC_STYLE = "[.underline]";
    private static final String LINE_THROUGH_ASCIDOC_STYLE = "[.line-through]";
    private static final String HARD_LINE_BREAK_ASCIDOC_STYLE = " +\n";
    private static final String CODE_BLOCK_ASCIDOC_STYLE = "```";
    private static final String BLOCKQUOTE_BLOCK_ASCIDOC_STYLE = "[quote]\n____";
    private static final String BLOCKQUOTE_BLOCK_ASCIDOC_STYLE_END = "____";
    private final boolean inlineMacroMode;

    public JavaDocParser(boolean inlineMacroMode) {
        this.inlineMacroMode = inlineMacroMode;
    }

    public JavaDocParser() {
        this(false);
    }

    public String parseConfigDescription(String javadocComment) {
        AtomicReference ref = new AtomicReference();
        this.parseConfigDescription(javadocComment, ref::set, s -> {});
        return (String)ref.get();
    }

    public void parseConfigDescription(String javadocComment, Consumer<String> javadocTextConsumer, Consumer<String> sinceConsumer) {
        if (javadocComment == null || javadocComment.trim().isEmpty()) {
            javadocTextConsumer.accept("");
            return;
        }
        Javadoc javadoc = StaticJavaParser.parseJavadoc((String)(javadocComment = START_OF_LINE.matcher(javadocComment).replaceAll("* ")));
        if (this.isAsciidoc(javadoc)) {
            javadocTextConsumer.accept(this.handleEolInAsciidoc(javadoc));
        } else {
            javadocTextConsumer.accept(this.htmlJavadocToAsciidoc(javadoc.getDescription()));
        }
        javadoc.getBlockTags().stream().filter(t -> t.getType() == JavadocBlockTag.Type.SINCE).map(JavadocBlockTag::getContent).map(JavadocDescription::toText).findFirst().ifPresent(sinceConsumer::accept);
    }

    public SectionHolder parseConfigSection(String javadocComment, int sectionLevel) {
        if (javadocComment == null || javadocComment.trim().isEmpty()) {
            return new SectionHolder("", "");
        }
        Javadoc javadoc = StaticJavaParser.parseJavadoc((String)(javadocComment = START_OF_LINE.matcher(javadocComment).replaceAll("* ")));
        if (this.isAsciidoc(javadoc)) {
            String details = this.handleEolInAsciidoc(javadoc);
            int endOfTitleIndex = details.indexOf(46);
            String title = details.substring(0, endOfTitleIndex).replaceAll("^([^\\w])+", "").trim();
            return new SectionHolder(title, details);
        }
        return this.generateConfigSection(javadoc, sectionLevel);
    }

    private SectionHolder generateConfigSection(Javadoc javadoc, int sectionLevel) {
        String generatedAsciiDoc = this.htmlJavadocToAsciidoc(javadoc.getDescription());
        if (generatedAsciiDoc.isEmpty()) {
            return new SectionHolder("", "");
        }
        String beginSectionDetails = IntStream.rangeClosed(0, Math.max(0, sectionLevel)).mapToObj(x -> "=").collect(Collectors.joining()) + " ";
        int endOfTitleIndex = generatedAsciiDoc.indexOf(46);
        if (endOfTitleIndex == -1) {
            return new SectionHolder(generatedAsciiDoc.trim(), beginSectionDetails + generatedAsciiDoc);
        }
        String title = generatedAsciiDoc.substring(0, endOfTitleIndex).trim();
        String introduction = generatedAsciiDoc.substring(endOfTitleIndex + 1).trim();
        String details = beginSectionDetails + title + "\n\n" + introduction;
        return new SectionHolder(title, details.trim());
    }

    private String handleEolInAsciidoc(Javadoc javadoc) {
        String asciidoc = javadoc.getDescription().toText();
        asciidoc = REPLACE_WINDOWS_EOL.matcher(asciidoc).replaceAll(NEW_LINE);
        asciidoc = REPLACE_MACOS_EOL.matcher(asciidoc).replaceAll(NEW_LINE);
        return asciidoc;
    }

    private boolean isAsciidoc(Javadoc javadoc) {
        for (JavadocBlockTag blockTag : javadoc.getBlockTags()) {
            if (!"asciidoclet".equals(blockTag.getTagName())) continue;
            return true;
        }
        return false;
    }

    private String htmlJavadocToAsciidoc(JavadocDescription javadocDescription) {
        StringBuilder sb = new StringBuilder();
        for (JavadocDescriptionElement javadocDescriptionElement : javadocDescription.getElements()) {
            if (javadocDescriptionElement instanceof JavadocInlineTag) {
                JavadocInlineTag inlineTag = (JavadocInlineTag)javadocDescriptionElement;
                String content = inlineTag.getContent().trim();
                switch (inlineTag.getType()) {
                    case CODE: 
                    case VALUE: 
                    case LITERAL: 
                    case SYSTEM_PROPERTY: {
                        sb.append('`');
                        this.appendEscapedAsciiDoc(sb, content);
                        sb.append('`');
                        break;
                    }
                    case LINK: 
                    case LINKPLAIN: {
                        if (content.startsWith(HASH)) {
                            content = DocGeneratorUtil.hyphenate(content.substring(1));
                        }
                        sb.append('`');
                        this.appendEscapedAsciiDoc(sb, content);
                        sb.append('`');
                        break;
                    }
                    default: {
                        sb.append(content);
                        break;
                    }
                }
                continue;
            }
            this.appendHtml(sb, (Node)Jsoup.parseBodyFragment((String)javadocDescriptionElement.toText()));
        }
        return JavaDocParser.trim(sb);
    }

    private void appendHtml(StringBuilder sb, Node node) {
        for (Node childNode : node.childNodes()) {
            switch (childNode.nodeName()) {
                case "p": {
                    JavaDocParser.newLine(sb);
                    JavaDocParser.newLine(sb);
                    this.appendHtml(sb, childNode);
                    break;
                }
                case "pre": {
                    JavaDocParser.newLine(sb);
                    JavaDocParser.newLine(sb);
                    sb.append(CODE_BLOCK_ASCIDOC_STYLE);
                    JavaDocParser.newLine(sb);
                    for (Node grandChildNode : childNode.childNodes()) {
                        this.unescapeHtmlEntities(sb, grandChildNode.toString());
                    }
                    JavaDocParser.newLineIfNeeded(sb);
                    sb.append(CODE_BLOCK_ASCIDOC_STYLE);
                    JavaDocParser.newLine(sb);
                    JavaDocParser.newLine(sb);
                    break;
                }
                case "blockquote": {
                    JavaDocParser.newLine(sb);
                    JavaDocParser.newLine(sb);
                    sb.append(BLOCKQUOTE_BLOCK_ASCIDOC_STYLE);
                    JavaDocParser.newLine(sb);
                    this.appendHtml(sb, childNode);
                    JavaDocParser.newLineIfNeeded(sb);
                    sb.append(BLOCKQUOTE_BLOCK_ASCIDOC_STYLE_END);
                    JavaDocParser.newLine(sb);
                    JavaDocParser.newLine(sb);
                    break;
                }
                case "ol": 
                case "ul": {
                    JavaDocParser.newLine(sb);
                    this.appendHtml(sb, childNode);
                    break;
                }
                case "li": {
                    String marker = childNode.parent().nodeName().equals(ORDERED_LIST_NODE) ? ORDERED_LIST_ITEM_ASCIDOC_STYLE : UNORDERED_LIST_ITEM_ASCIDOC_STYLE;
                    JavaDocParser.newLine(sb);
                    sb.append(marker);
                    this.appendHtml(sb, childNode);
                    break;
                }
                case "a": {
                    String link = childNode.attr(HREF_ATTRIBUTE);
                    sb.append("link:");
                    sb.append(link);
                    StringBuilder caption = new StringBuilder();
                    this.appendHtml(caption, childNode);
                    sb.append(String.format(LINK_ATTRIBUTE_FORMAT, JavaDocParser.trim(caption)));
                    break;
                }
                case "code": {
                    sb.append(BACKTICK);
                    this.appendHtml(sb, childNode);
                    sb.append(BACKTICK);
                    break;
                }
                case "b": 
                case "strong": {
                    sb.append(STAR);
                    this.appendHtml(sb, childNode);
                    sb.append(STAR);
                    break;
                }
                case "em": 
                case "i": {
                    sb.append(UNDERSCORE);
                    this.appendHtml(sb, childNode);
                    sb.append(UNDERSCORE);
                    break;
                }
                case "u": {
                    sb.append(UNDERLINE_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    break;
                }
                case "small": {
                    sb.append(SMALL_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    break;
                }
                case "big": {
                    sb.append(BIG_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    break;
                }
                case "sub": {
                    sb.append(SUB_SCRIPT_ASCIDOC_STYLE);
                    this.appendHtml(sb, childNode);
                    sb.append(SUB_SCRIPT_ASCIDOC_STYLE);
                    break;
                }
                case "sup": {
                    sb.append(SUPER_SCRIPT_ASCIDOC_STYLE);
                    this.appendHtml(sb, childNode);
                    sb.append(SUPER_SCRIPT_ASCIDOC_STYLE);
                    break;
                }
                case "del": 
                case "s": 
                case "strike": {
                    sb.append(LINE_THROUGH_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    break;
                }
                case "br": {
                    sb.append(HARD_LINE_BREAK_ASCIDOC_STYLE);
                    break;
                }
                case "#text": {
                    String text = ((TextNode)childNode).text();
                    if (text.isEmpty()) break;
                    Matcher startingSpaceMatcher = STARTING_SPACE.matcher(text);
                    if (sb.length() > 0 && '\n' == sb.charAt(sb.length() - 1) && startingSpaceMatcher.find()) {
                        text = startingSpaceMatcher.replaceFirst("");
                    }
                    this.appendEscapedAsciiDoc(sb, text);
                    break;
                }
                default: {
                    this.appendHtml(sb, childNode);
                }
            }
        }
    }

    static String trim(StringBuilder sb) {
        char ch;
        int length = sb.length();
        int offset = 0;
        while (offset < length) {
            ch = sb.charAt(offset);
            if (ch == ' ' && offset + 2 < length && sb.charAt(offset + 1) == '+' && sb.charAt(offset + 2) == '\n') {
                offset += 3;
                continue;
            }
            if (ch > ' ') break;
            ++offset;
        }
        if (offset > 0) {
            sb.delete(0, offset);
        }
        if (sb.length() > 0) {
            offset = sb.length() - 1;
            while (offset >= 0) {
                ch = sb.charAt(offset);
                if (ch == '\n' && offset - 2 >= 0 && sb.charAt(offset - 1) == '+' && sb.charAt(offset - 2) == ' ') {
                    offset -= 3;
                    continue;
                }
                if (ch > ' ') break;
                --offset;
            }
            if (offset < sb.length() - 1) {
                sb.setLength(offset + 1);
            }
        }
        return sb.toString();
    }

    private static StringBuilder newLineIfNeeded(StringBuilder sb) {
        JavaDocParser.trimText(sb, " \t\r\n");
        return sb.append(NEW_LINE);
    }

    private static StringBuilder newLine(StringBuilder sb) {
        JavaDocParser.trimText(sb, " \t");
        return sb.append(NEW_LINE);
    }

    private static StringBuilder trimText(StringBuilder sb, String charsToTrim) {
        while (sb.length() > 0 && charsToTrim.indexOf(sb.charAt(sb.length() - 1)) >= 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    private StringBuilder unescapeHtmlEntities(StringBuilder sb, String text) {
        int i = 0;
        block21: while (i < text.length()) {
            switch (text.charAt(i++)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block21;
                }
            }
            --i;
            break;
        }
        while (i < text.length()) {
            char ch = text.charAt(i);
            block4 : switch (ch) {
                case '&': {
                    String abbrev;
                    int start = ++i;
                    while (i < text.length() && text.charAt(i) != ';') {
                        ++i;
                    }
                    if (i <= start) break;
                    switch (abbrev = text.substring(start, i)) {
                        case "lt": {
                            sb.append('<');
                            break block4;
                        }
                        case "gt": {
                            sb.append('>');
                            break block4;
                        }
                        case "nbsp": {
                            sb.append("{nbsp}");
                            break block4;
                        }
                        case "amp": {
                            sb.append('&');
                            break block4;
                        }
                    }
                    try {
                        int code = Integer.parseInt(abbrev);
                        sb.append((char)code);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Could not parse HTML entity &" + abbrev + "; in\n\n" + text + "\n\n");
                    }
                }
                case '\r': {
                    if (i + 1 < text.length() && text.charAt(i + 1) == '\n') break;
                    sb.append('\n');
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb;
    }

    private StringBuilder appendEscapedAsciiDoc(StringBuilder sb, String text) {
        boolean escaping = false;
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case ']': {
                    if (this.inlineMacroMode) {
                        if (escaping) {
                            sb.append("++");
                            escaping = false;
                        }
                        sb.append("&#93;");
                        continue block5;
                    }
                }
                case '#': 
                case '*': 
                case '[': 
                case '\\': 
                case '{': 
                case '|': 
                case '}': {
                    if (!escaping) {
                        sb.append("++");
                        escaping = true;
                    }
                    sb.append(ch);
                    continue block5;
                }
                case '+': {
                    if (escaping) {
                        sb.append("++");
                        escaping = false;
                    }
                    sb.append("{plus}");
                    continue block5;
                }
                default: {
                    if (escaping) {
                        sb.append("++");
                        escaping = false;
                    }
                    sb.append(ch);
                }
            }
        }
        if (escaping) {
            sb.append("++");
        }
        return sb;
    }

    static class SectionHolder {
        final String title;
        final String details;

        public SectionHolder(String title, String details) {
            this.title = title;
            this.details = details;
        }
    }
}

