/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.Components;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InjectableDecorator;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.InjectableObserverMethod;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.RemovedBean;
import io.quarkus.arc.ResourceReferenceProvider;
import io.quarkus.arc.impl.ApplicationContext;
import io.quarkus.arc.impl.ArcCDIProvider;
import io.quarkus.arc.impl.BeanManagerBean;
import io.quarkus.arc.impl.BeanManagerImpl;
import io.quarkus.arc.impl.BeanTypeAssignabilityRules;
import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.impl.ComputingCacheContextInstances;
import io.quarkus.arc.impl.ContextInstances;
import io.quarkus.arc.impl.Contexts;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.CurrentInjectionPointProvider;
import io.quarkus.arc.impl.DelegateInjectionPointAssignabilityRules;
import io.quarkus.arc.impl.DependentContext;
import io.quarkus.arc.impl.EagerInstanceHandle;
import io.quarkus.arc.impl.EventBean;
import io.quarkus.arc.impl.EventImpl;
import io.quarkus.arc.impl.EventTypeAssignabilityRules;
import io.quarkus.arc.impl.HierarchyDiscovery;
import io.quarkus.arc.impl.InjectionPointBean;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.InstanceBean;
import io.quarkus.arc.impl.InstanceImpl;
import io.quarkus.arc.impl.Instances;
import io.quarkus.arc.impl.InterceptedStaticMethods;
import io.quarkus.arc.impl.InterceptorBindings;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.arc.impl.Mockable;
import io.quarkus.arc.impl.Qualifiers;
import io.quarkus.arc.impl.Reflections;
import io.quarkus.arc.impl.RequestContext;
import io.quarkus.arc.impl.SingletonContext;
import io.quarkus.arc.impl.ThreadLocalCurrentContextFactory;
import io.quarkus.arc.impl.Types;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class ArcContainerImpl
implements ArcContainer {
    private static final Logger LOGGER = Logger.getLogger(ArcContainerImpl.class.getPackage().getName());
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
    private final String id;
    private final AtomicBoolean running;
    private final List<InjectableBean<?>> beans;
    private final Map<String, List<InjectableBean<?>>> beansByRawType;
    private final LazyValue<List<RemovedBean>> removedBeans;
    private final List<InjectableInterceptor<?>> interceptors;
    private final List<InjectableDecorator<?>> decorators;
    private final List<InjectableObserverMethod<?>> observers;
    private final Contexts contexts;
    private final ComputingCache<Resolvable, Set<InjectableBean<?>>> resolved;
    private final ComputingCache<String, InjectableBean<?>> beansById;
    private final ComputingCache<String, Set<InjectableBean<?>>> beansByName;
    private final ArrayList<ResourceReferenceProvider> resourceProviders;
    final InstanceImpl<Object> instance;
    final Qualifiers registeredQualifiers;
    final InterceptorBindings registeredInterceptorBindings;
    private volatile ExecutorService executorService;
    private final CurrentContextFactory currentContextFactory;
    private final boolean strictMode;

    public ArcContainerImpl(CurrentContextFactory currentContextFactory, boolean strictMode) {
        this.strictMode = strictMode;
        this.id = String.valueOf(ID_GENERATOR.incrementAndGet());
        this.running = new AtomicBoolean(true);
        ArrayList beans = new ArrayList();
        HashMap beansByRawType = new HashMap();
        final ArrayList<Supplier<Collection<RemovedBean>>> removedBeans = new ArrayList<Supplier<Collection<RemovedBean>>>();
        ArrayList<InjectableInterceptor> interceptors = new ArrayList<InjectableInterceptor>();
        ArrayList<InjectableDecorator> decorators = new ArrayList<InjectableDecorator>();
        ArrayList observers = new ArrayList();
        HashSet<String> interceptorBindings = new HashSet<String>();
        HashMap<Class<? extends Annotation>, Set<Annotation>> transitiveInterceptorBindings = new HashMap<Class<? extends Annotation>, Set<Annotation>>();
        HashMap<String, Set<String>> qualifierNonbindingMembers = new HashMap<String, Set<String>>();
        HashSet<String> qualifiers = new HashSet<String>();
        Supplier<ContextInstances> applicationContextInstances = null;
        Supplier<ContextInstances> requestContextInstances = null;
        this.currentContextFactory = currentContextFactory == null ? new ThreadLocalCurrentContextFactory() : currentContextFactory;
        ArrayList<Components> components = new ArrayList<Components>();
        for (ComponentsProvider componentsProvider : ServiceLoader.load(ComponentsProvider.class)) {
            components.add(componentsProvider.getComponents(this.currentContextFactory));
        }
        for (Components c : components) {
            for (InjectableBean<?> bean : c.getBeans()) {
                if (bean instanceof InjectableInterceptor) {
                    interceptors.add((InjectableInterceptor)bean);
                    continue;
                }
                if (bean instanceof InjectableDecorator) {
                    decorators.add((InjectableDecorator)bean);
                    continue;
                }
                beans.add(bean);
                ArcContainerImpl.precomputeBeanRawTypes(beansByRawType, bean);
            }
            removedBeans.add(c.getRemovedBeans());
            observers.addAll(c.getObservers());
            interceptorBindings.addAll(c.getInterceptorBindings());
            transitiveInterceptorBindings.putAll(c.getTransitiveInterceptorBindings());
            qualifierNonbindingMembers.putAll(c.getQualifierNonbindingMembers());
            qualifiers.addAll(c.getQualifiers());
            if (applicationContextInstances == null) {
                applicationContextInstances = c.getContextInstances().get(ApplicationScoped.class);
            }
            if (requestContextInstances != null) continue;
            requestContextInstances = c.getContextInstances().get(RequestScoped.class);
        }
        ArcContainerImpl.addBuiltInBeans(beans, beansByRawType);
        interceptors.sort(Comparator.comparingInt(InjectableBean::getPriority));
        decorators.sort(Comparator.comparingInt(InjectableBean::getPriority));
        this.resolved = new ComputingCache<Resolvable, Set>(this::resolve);
        this.beansById = new ComputingCache<String, InjectableBean>(this::findById);
        this.beansByName = new ComputingCache<String, Set>(this::resolve);
        this.resourceProviders = new ArrayList();
        for (ResourceReferenceProvider resourceProvider : ServiceLoader.load(ResourceReferenceProvider.class)) {
            this.resourceProviders.add(resourceProvider);
        }
        this.resourceProviders.trimToSize();
        this.instance = InstanceImpl.forGlobalEntrypoint(Object.class, Collections.emptySet());
        this.beans = List.copyOf(beans);
        this.beansByRawType = Map.copyOf(beansByRawType);
        this.beansByRawType.forEach(new BiConsumer<String, List<InjectableBean<?>>>(){

            @Override
            public void accept(String key, List<InjectableBean<?>> val) {
                if (val.size() > 1) {
                    ((ArrayList)val).trimToSize();
                }
            }
        });
        this.interceptors = List.copyOf(interceptors);
        this.decorators = List.copyOf(decorators);
        this.observers = List.copyOf(observers);
        this.removedBeans = new LazyValue<List<RemovedBean>>(new Supplier<List<RemovedBean>>(){

            @Override
            public List<RemovedBean> get() {
                ArrayList removed = new ArrayList();
                for (Supplier supplier : removedBeans) {
                    removed.addAll((Collection)supplier.get());
                }
                LOGGER.debugf("Loaded %s removed beans lazily", removed.size());
                return List.copyOf(removed);
            }
        });
        this.registeredQualifiers = new Qualifiers(qualifiers, qualifierNonbindingMembers);
        this.registeredInterceptorBindings = new InterceptorBindings(interceptorBindings, transitiveInterceptorBindings);
        ApplicationContext applicationContext = applicationContextInstances != null ? new ApplicationContext(applicationContextInstances.get()) : new ApplicationContext();
        RequestContext requestContext = new RequestContext(this.currentContextFactory.create(RequestScoped.class), this.notifierOrNull(Set.of(Initialized.Literal.REQUEST, Any.Literal.INSTANCE)), this.notifierOrNull(Set.of(BeforeDestroyed.Literal.REQUEST, Any.Literal.INSTANCE)), this.notifierOrNull(Set.of(Destroyed.Literal.REQUEST, Any.Literal.INSTANCE)), requestContextInstances != null ? requestContextInstances : ComputingCacheContextInstances::new);
        Contexts.Builder contextsBuilder = new Contexts.Builder(requestContext, applicationContext, new SingletonContext(), new DependentContext());
        for (Components c : components) {
            for (InjectableContext context : c.getContexts()) {
                if (ApplicationScoped.class.equals(context.getScope())) {
                    throw new IllegalStateException("Failed to register a context - built-in application context is always active: " + context);
                }
                if (Singleton.class.equals(context.getScope())) {
                    throw new IllegalStateException("Failed to register a context - built-in singleton context is always active: " + context);
                }
                contextsBuilder.putContext(context);
            }
        }
        this.contexts = contextsBuilder.build();
    }

    static void precomputeBeanRawTypes(Map<String, List<InjectableBean<?>>> map, InjectableBean<?> bean) {
        for (Type type : bean.getTypes()) {
            Class<Object> rawType;
            if (Object.class.equals((Object)type) || (rawType = Types.getRawType(type)) == null) continue;
            String key = (rawType = Types.boxedClass(rawType)).getName();
            List<InjectableBean<?>> match = map.get(key);
            if (match == null) {
                map.put(key, List.of(bean));
                continue;
            }
            if (match.contains(bean)) continue;
            if (match.size() == 1) {
                ArrayList newMatch = new ArrayList();
                newMatch.add(match.get(0));
                newMatch.add(bean);
                map.put(key, newMatch);
                continue;
            }
            match.add(bean);
        }
    }

    public void init() {
        Set<Annotation> qualifiers = Set.of(Initialized.Literal.APPLICATION, Any.Literal.INSTANCE);
        EventImpl.createNotifier(Object.class, Object.class, qualifiers, this, false, null).notify("@Initialized(ApplicationScoped.class)");
        CDI.setCDIProvider(new ArcCDIProvider());
        LOGGER.debugf("ArC DI container initialized [beans=%s, observers=%s]", this.beans.size(), this.observers.size());
    }

    @Override
    public InjectableContext getActiveContext(Class<? extends Annotation> scopeType) {
        return this.contexts.getActiveContext(scopeType);
    }

    @Override
    public List<InjectableContext> getContexts(Class<? extends Annotation> scopeType) {
        return this.contexts.getContexts(scopeType);
    }

    @Override
    public Set<Class<? extends Annotation>> getScopes() {
        return this.contexts.scopes;
    }

    @Override
    public <T> InstanceHandle<T> instance(Class<T> type, Annotation ... qualifiers) {
        return this.instanceHandle(type, qualifiers);
    }

    @Override
    public <T> InstanceHandle<T> instance(TypeLiteral<T> type, Annotation ... qualifiers) {
        return this.instanceHandle(type.getType(), qualifiers);
    }

    @Override
    public <X> InstanceHandle<X> instance(Type type, Annotation ... qualifiers) {
        return this.instanceHandle(type, qualifiers);
    }

    @Override
    public <T> Supplier<InstanceHandle<T>> beanInstanceSupplier(Class<T> type, Annotation ... qualifiers) {
        InjectableBean<?> bean;
        Resolvable resolvable;
        Set<InjectableBean<?>> resolvedBeans;
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        }
        if ((resolvedBeans = this.resolved.getValue(resolvable = new Resolvable(type, qualifiers))).isEmpty()) {
            this.scanRemovedBeans(resolvable);
        }
        Set<InjectableBean<?>> filteredBean = resolvedBeans;
        if (resolvedBeans.size() > 1) {
            throw new AmbiguousResolutionException("Beans: " + resolvedBeans);
        }
        InjectableBean<?> injectableBean = bean = filteredBean.size() != 1 ? null : filteredBean.iterator().next();
        if (bean == null) {
            return null;
        }
        return new Supplier<InstanceHandle<T>>(){

            @Override
            public InstanceHandle<T> get() {
                return ArcContainerImpl.beanInstanceHandle(bean, null);
            }
        };
    }

    @Override
    public <T> InstanceHandle<T> instance(InjectableBean<T> bean) {
        Objects.requireNonNull(bean);
        return ArcContainerImpl.beanInstanceHandle(bean, null);
    }

    @Override
    public <T> InjectableInstance<T> select(Class<T> type, Annotation ... qualifiers) {
        return this.instance.select(type, qualifiers);
    }

    @Override
    public <T> InjectableInstance<T> select(TypeLiteral<T> type, Annotation ... qualifiers) {
        return this.instance.select(type, qualifiers);
    }

    @Override
    public <T> List<InstanceHandle<T>> listAll(Class<T> type, Annotation ... qualifiers) {
        return this.listAll((Type)type, qualifiers);
    }

    @Override
    public <T> List<InstanceHandle<T>> listAll(TypeLiteral<T> type, Annotation ... qualifiers) {
        return this.listAll(type.getType(), qualifiers);
    }

    @Override
    public <X> List<InstanceHandle<X>> listAll(Type type, Annotation ... qualifiers) {
        return Instances.listOfHandles(CurrentInjectionPointProvider.EMPTY_SUPPLIER, type, Set.of(qualifiers), new CreationalContextImpl(null));
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public <T> InjectableBean<T> bean(String beanIdentifier) {
        Objects.requireNonNull(beanIdentifier);
        return this.beansById.getValue(beanIdentifier);
    }

    @Override
    public InjectableBean<?> namedBean(String name) {
        Objects.requireNonNull(name);
        Set<InjectableBean<?>> found = this.beansByName.getValue(name);
        return found.size() == 1 ? found.iterator().next() : null;
    }

    @Override
    public <T> InstanceHandle<T> instance(String name) {
        Objects.requireNonNull(name);
        Set<InjectableBean<?>> resolvedBeans = this.beansByName.getValue(name);
        return resolvedBeans.size() != 1 ? EagerInstanceHandle.unavailable() : ArcContainerImpl.beanInstanceHandle(resolvedBeans.iterator().next(), null);
    }

    @Override
    public ManagedContext requestContext() {
        return this.contexts.requestContext;
    }

    @Override
    public BeanManager beanManager() {
        return BeanManagerImpl.INSTANCE.get();
    }

    @Override
    public ExecutorService getExecutorService() {
        ExecutorService executor = this.executorService;
        return executor != null ? executor : ForkJoinPool.commonPool();
    }

    public void setExecutor(ExecutorService executor) {
        this.executorService = executor;
    }

    @Override
    public CurrentContextFactory getCurrentContextFactory() {
        return this.currentContextFactory;
    }

    @Override
    public boolean strictCompatibility() {
        return this.strictMode;
    }

    public String toString() {
        return "ArcContainerImpl [id=" + this.id + ", running=" + this.running + ", beans=" + this.beans.size() + ", observers=" + this.observers.size() + ", scopes=" + this.contexts.scopes.size() + "]";
    }

    public synchronized void shutdown() {
        if (this.running.get()) {
            CDI<Object> cdi = CDI.current();
            if (cdi instanceof ArcCDIProvider.ArcCDI) {
                ArcCDIProvider.ArcCDI arcCdi = (ArcCDIProvider.ArcCDI)cdi;
                arcCdi.destroy();
            }
            this.contexts.requestContext.terminate();
            HashSet<Annotation> beforeDestroyQualifiers = new HashSet<Annotation>(4);
            beforeDestroyQualifiers.add(BeforeDestroyed.Literal.APPLICATION);
            beforeDestroyQualifiers.add(Any.Literal.INSTANCE);
            try {
                EventImpl.createNotifier(Object.class, Object.class, beforeDestroyQualifiers, this, false, null).notify(this.toString());
            }
            catch (Exception e) {
                LOGGER.warn((Object)"An error occurred during delivery of the @BeforeDestroyed(ApplicationScoped.class) event", e);
            }
            this.contexts.applicationContext.destroy();
            HashSet<Annotation> destroyQualifiers = new HashSet<Annotation>(4);
            destroyQualifiers.add(Destroyed.Literal.APPLICATION);
            destroyQualifiers.add(Any.Literal.INSTANCE);
            try {
                EventImpl.createNotifier(Object.class, Object.class, destroyQualifiers, this, false, null).notify(this.toString());
            }
            catch (Exception e) {
                LOGGER.warn((Object)"An error occurred during delivery of the @Destroyed(ApplicationScoped.class) event", e);
            }
            this.contexts.singletonContext.destroy();
            Reflections.clearCaches();
            this.resolved.clear();
            this.running.set(false);
            InterceptedStaticMethods.clear();
            LOGGER.debugf("ArC DI container shut down", new Object[0]);
        }
    }

    public List<InjectableBean<?>> getBeans() {
        return this.beans;
    }

    public List<RemovedBean> getRemovedBeans() {
        return this.removedBeans.get();
    }

    public List<InjectableInterceptor<?>> getInterceptors() {
        return this.interceptors;
    }

    public List<InjectableDecorator<?>> getDecorators() {
        return this.decorators;
    }

    public List<InjectableObserverMethod<?>> getObservers() {
        return this.observers;
    }

    @Override
    public <T> List<InjectableObserverMethod<? super T>> resolveObserverMethods(Type eventType, Annotation ... eventQualifiers) {
        return this.resolveObserverMethods(eventType, Set.of(eventQualifiers));
    }

    InstanceHandle<Object> getResource(Type type, Set<Annotation> annotations) {
        for (ResourceReferenceProvider resourceProvider : this.resourceProviders) {
            InstanceHandle<Object> ret = resourceProvider.get(type, annotations);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private EventImpl.Notifier<Object> notifierOrNull(Set<Annotation> qualifiers) {
        EventImpl.Notifier<Object> notifier = EventImpl.createNotifier(Object.class, Object.class, qualifiers, this, false, null);
        return notifier.isEmpty() ? null : notifier;
    }

    private static void addBuiltInBeans(List<InjectableBean<?>> beans, Map<String, List<InjectableBean<?>>> beansByRawType) {
        BeanManagerBean beanManagerBean = new BeanManagerBean();
        beans.add(beanManagerBean);
        ArcContainerImpl.precomputeBeanRawTypes(beansByRawType, beanManagerBean);
        EventBean eventBean = new EventBean();
        beans.add(eventBean);
        ArcContainerImpl.precomputeBeanRawTypes(beansByRawType, eventBean);
        beans.add(InstanceBean.INSTANCE);
        ArcContainerImpl.precomputeBeanRawTypes(beansByRawType, InstanceBean.INSTANCE);
        InjectionPointBean injectionPointBean = new InjectionPointBean();
        beans.add(injectionPointBean);
        ArcContainerImpl.precomputeBeanRawTypes(beansByRawType, injectionPointBean);
    }

    private <T> InstanceHandle<T> instanceHandle(Type type, Annotation ... qualifiers) {
        return ArcContainerImpl.beanInstanceHandle(this.getBean(type, qualifiers), null);
    }

    static <T> InstanceHandle<T> beanInstanceHandle(InjectableBean<T> bean, CreationalContextImpl<T> parentContext, boolean resetCurrentInjectionPoint, Consumer<T> destroyLogic) {
        return ArcContainerImpl.beanInstanceHandle(bean, parentContext, resetCurrentInjectionPoint, destroyLogic, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> InstanceHandle<T> beanInstanceHandle(InjectableBean<T> bean, CreationalContextImpl<T> parentContext, boolean resetCurrentInjectionPoint, Consumer<T> destroyLogic, boolean useParentCreationalContextDirectly) {
        if (bean != null) {
            if (parentContext == null && Dependent.class.equals(bean.getScope())) {
                parentContext = new CreationalContextImpl(null);
            }
            CreationalContextImpl<T> creationalContext = parentContext != null ? (useParentCreationalContextDirectly ? parentContext : parentContext.child(bean)) : new CreationalContextImpl<T>(bean);
            InjectionPoint prev = null;
            if (resetCurrentInjectionPoint) {
                prev = InjectionPointProvider.setCurrent(creationalContext, CurrentInjectionPointProvider.EMPTY);
            }
            try {
                EagerInstanceHandle<T> eagerInstanceHandle = new EagerInstanceHandle<T>(bean, bean.get(creationalContext), creationalContext, parentContext, destroyLogic);
                return eagerInstanceHandle;
            }
            finally {
                if (resetCurrentInjectionPoint) {
                    InjectionPointProvider.setCurrent(creationalContext, prev);
                }
            }
        }
        return EagerInstanceHandle.unavailable();
    }

    static <T> InstanceHandle<T> beanInstanceHandle(InjectableBean<T> bean, CreationalContextImpl<T> parentContext) {
        return ArcContainerImpl.beanInstanceHandle(bean, parentContext, true, null);
    }

    private <T> InjectableBean<T> getBean(Type requiredType, Annotation ... qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        } else {
            this.registeredQualifiers.verify(qualifiers);
        }
        Resolvable resolvable = new Resolvable(requiredType, qualifiers);
        Set<InjectableBean<?>> resolvedBeans = this.resolved.getValue(resolvable);
        if (resolvedBeans.isEmpty()) {
            this.scanRemovedBeans(resolvable);
        }
        return resolvedBeans.size() != 1 ? null : resolvedBeans.iterator().next();
    }

    Set<Bean<?>> getBeans(Type requiredType, Annotation ... qualifiers) {
        if (requiredType instanceof TypeVariable) {
            throw new IllegalArgumentException("The given type is a type variable: " + requiredType);
        }
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        } else {
            this.registeredQualifiers.verify(qualifiers);
        }
        return Set.of(this.getMatchingBeans(new Resolvable(requiredType, qualifiers)).toArray(new Bean[0]));
    }

    Set<Bean<?>> getBeans(String name) {
        return new HashSet(this.getMatchingBeans(name));
    }

    boolean isScope(Class<? extends Annotation> annotationType) {
        if (annotationType.isAnnotationPresent(Scope.class) || annotationType.isAnnotationPresent(NormalScope.class)) {
            return true;
        }
        for (Class<? extends Annotation> scopeType : this.contexts.scopes) {
            if (!scopeType.equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    boolean isNormalScope(Class<? extends Annotation> annotationType) {
        if (annotationType.isAnnotationPresent(NormalScope.class)) {
            return true;
        }
        List<InjectableContext> injectableContexts = this.contexts.getContexts(annotationType);
        for (InjectableContext context : injectableContexts) {
            if (!context.isNormal()) continue;
            return true;
        }
        return false;
    }

    private Set<InjectableBean<?>> resolve(Resolvable resolvable) {
        return ArcContainerImpl.resolve(this.getMatchingBeans(resolvable));
    }

    private Set<InjectableBean<?>> resolve(String name) {
        return ArcContainerImpl.resolve(this.getMatchingBeans(name));
    }

    private InjectableBean<?> findById(String identifier) {
        for (InjectableBean<?> injectableBean : this.beans) {
            if (!injectableBean.getIdentifier().equals(identifier)) continue;
            return injectableBean;
        }
        for (InjectableInterceptor injectableInterceptor : this.interceptors) {
            if (!injectableInterceptor.getIdentifier().equals(identifier)) continue;
            return injectableInterceptor;
        }
        for (InjectableDecorator injectableDecorator : this.decorators) {
            if (!injectableDecorator.getIdentifier().equals(identifier)) continue;
            return injectableDecorator;
        }
        return null;
    }

    static <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        if (beans.size() == 1) {
            return beans.iterator().next();
        }
        if (beans.stream().allMatch(InjectableBean.class::isInstance)) {
            ArrayList matching = new ArrayList(beans.size());
            for (Bean<X> bean : beans) {
                matching.add((InjectableBean)bean);
            }
            Set<InjectableBean<?>> resolved = ArcContainerImpl.resolve(matching);
            if (resolved.size() != 1) {
                throw new AmbiguousResolutionException(resolved.toString());
            }
            return resolved.iterator().next();
        }
        HashSet<Bean<X>> resolved = new HashSet<Bean<X>>(beans);
        resolved.removeIf(Predicate.not(BeanAttributes::isAlternative));
        if (resolved.size() != 1) {
            throw new AmbiguousResolutionException(((Object)resolved).toString());
        }
        return (Bean)resolved.iterator().next();
    }

    private static Set<InjectableBean<?>> resolve(List<InjectableBean<?>> matching) {
        if (matching.isEmpty()) {
            return Collections.emptySet();
        }
        if (matching.size() == 1) {
            return Set.of(matching.get(0));
        }
        ArrayList nonDefault = new ArrayList(matching);
        Iterator iterator = nonDefault.iterator();
        while (iterator.hasNext()) {
            if (!((InjectableBean)iterator.next()).isDefaultBean()) continue;
            iterator.remove();
        }
        if (nonDefault.isEmpty()) {
            ArrayList priorityDefaultBeans = new ArrayList(matching);
            priorityDefaultBeans.sort(ArcContainerImpl::compareDefaultBeans);
            Integer highest = ((InjectableBean)priorityDefaultBeans.get(0)).getPriority();
            Iterator iterator2 = priorityDefaultBeans.iterator();
            while (iterator2.hasNext()) {
                if (highest.equals(((InjectableBean)iterator2.next()).getPriority())) continue;
                iterator2.remove();
            }
            if (priorityDefaultBeans.size() == 1) {
                return Set.of((InjectableBean)priorityDefaultBeans.get(0));
            }
            return Set.copyOf(priorityDefaultBeans);
        }
        if (nonDefault.size() == 1) {
            return Set.of((InjectableBean)nonDefault.get(0));
        }
        ArrayList priorityBeans = new ArrayList(nonDefault);
        Iterator iterator3 = priorityBeans.iterator();
        while (iterator3.hasNext()) {
            if (ArcContainerImpl.isAlternativeOrDeclaredOnAlternative((InjectableBean)iterator3.next())) continue;
            iterator3.remove();
        }
        if (priorityBeans.isEmpty()) {
            return Set.copyOf(nonDefault);
        }
        if (priorityBeans.size() == 1) {
            return Set.of((InjectableBean)priorityBeans.get(0));
        }
        priorityBeans.sort(ArcContainerImpl::compareAlternativeBeans);
        Integer highest = ArcContainerImpl.getAlternativePriority((InjectableBean)priorityBeans.get(0));
        Iterator iterator4 = priorityBeans.iterator();
        while (iterator4.hasNext()) {
            if (highest.equals(ArcContainerImpl.getAlternativePriority((InjectableBean)iterator4.next()))) continue;
            iterator4.remove();
        }
        if (priorityBeans.size() == 1) {
            return Set.of((InjectableBean)priorityBeans.get(0));
        }
        return Set.copyOf(priorityBeans);
    }

    private static boolean isAlternativeOrDeclaredOnAlternative(InjectableBean<?> bean) {
        return bean.getAlternativePriority() != null || bean.getDeclaringBean() != null && bean.getDeclaringBean().getAlternativePriority() != null;
    }

    private static Integer getAlternativePriority(InjectableBean<?> bean) {
        Integer beanPriority = bean.getAlternativePriority();
        if (beanPriority == null && bean.getDeclaringBean() != null) {
            beanPriority = bean.getDeclaringBean().getAlternativePriority();
        }
        return beanPriority;
    }

    List<InjectableBean<?>> getMatchingBeans(Resolvable resolvable) {
        ArrayList matching = new ArrayList();
        for (InjectableBean<?> bean : this.potentialBeans(resolvable.requiredType)) {
            if (!this.matches(bean, resolvable.requiredType, resolvable.qualifiers)) continue;
            matching.add(bean);
        }
        return matching;
    }

    Iterable<InjectableBean<?>> potentialBeans(Type type) {
        Class rawType;
        if (!Object.class.equals((Object)type) && (rawType = Types.getRawType(type)) != null) {
            List<InjectableBean<?>> match = this.beansByRawType.get(Types.boxedClass(rawType).getName());
            return match == null ? List.of() : match;
        }
        return this.beans;
    }

    List<RemovedBean> getMatchingRemovedBeans(Resolvable resolvable) {
        ArrayList<RemovedBean> matching = new ArrayList<RemovedBean>();
        for (RemovedBean removedBean : this.removedBeans.get()) {
            if (!this.matches(removedBean.getTypes(), removedBean.getQualifiers(), resolvable.requiredType, resolvable.qualifiers)) continue;
            matching.add(removedBean);
        }
        return matching;
    }

    void scanRemovedBeans(Type requiredType, Annotation ... qualifiers) {
        this.scanRemovedBeans(new Resolvable(requiredType, qualifiers));
    }

    void scanRemovedBeans(Resolvable resolvable) {
        List<RemovedBean> removedMatching = this.getMatchingRemovedBeans(resolvable);
        if (!removedMatching.isEmpty()) {
            String separator = "====================";
            String msg = "\n%1$s%1$s%1$s%1$s\nCDI: programmatic lookup problem detected\n-----------------------------------------\nAt least one bean matched the required type and qualifiers but was marked as unused and removed during build\n\nStack frame: %5$s\nRequired type: %3$s\nRequired qualifiers: %4$s\nRemoved beans:\n\t- %2$s\nSolutions:\n\t- Application developers can eliminate false positives via the @Unremovable annotation\n\t- Extensions can eliminate false positives via build items, e.g. using the UnremovableBeanBuildItem\n\t- See also https://quarkus.io/guides/cdi-reference#remove_unused_beans\n\t- Enable the DEBUG log level to see the full stack trace\n%1$s%1$s%1$s%1$s\n";
            StackWalker walker = StackWalker.getInstance();
            StackWalker.StackFrame frame = walker.walk(this::findCaller);
            LOGGER.warnf(msg, separator, removedMatching.stream().map(Object::toString).collect(Collectors.joining("\n\t- ")), resolvable.requiredType, Arrays.toString(resolvable.qualifiers), frame != null ? frame : "n/a");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\nCDI: programmatic lookup stack trace:\n" + walker.walk(this::collectStack));
            }
        }
    }

    private StackWalker.StackFrame findCaller(Stream<StackWalker.StackFrame> stream) {
        return stream.filter(this::isCallerFrame).findFirst().orElse(null);
    }

    private String collectStack(Stream<StackWalker.StackFrame> stream) {
        return stream.map(Object::toString).collect(Collectors.joining("\n\t"));
    }

    private boolean isCallerFrame(StackWalker.StackFrame frame) {
        String className = frame.getClassName();
        return !className.startsWith("io.quarkus.arc.impl");
    }

    List<InjectableBean<?>> getMatchingBeans(String name) {
        ArrayList matching = new ArrayList();
        for (InjectableBean<?> bean : this.beans) {
            if (!name.equals(bean.getName())) continue;
            matching.add(bean);
        }
        return matching;
    }

    private static int compareAlternativeBeans(InjectableBean<?> bean1, InjectableBean<?> bean2) {
        Integer priority1;
        Integer priority2 = bean2.getAlternativePriority();
        if (priority2 == null && bean2.getDeclaringBean() != null) {
            priority2 = bean2.getDeclaringBean().getAlternativePriority();
        }
        if ((priority1 = bean1.getAlternativePriority()) == null && bean1.getDeclaringBean() != null) {
            priority1 = bean1.getDeclaringBean().getAlternativePriority();
        }
        return priority2.compareTo(priority1);
    }

    private static int compareDefaultBeans(InjectableBean<?> bean1, InjectableBean<?> bean2) {
        Integer priority2 = bean2.getPriority();
        Integer priority1 = bean1.getPriority();
        return priority2.compareTo(priority1);
    }

    <T> List<InjectableObserverMethod<? super T>> resolveObserverMethods(Type eventType, Set<Annotation> eventQualifiers) {
        this.registeredQualifiers.verify(eventQualifiers);
        if (this.observers.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Type> eventTypes = new HierarchyDiscovery(eventType).getTypeClosure();
        ArrayList<InjectableObserverMethod<T>> resolvedObservers = new ArrayList<InjectableObserverMethod<T>>();
        for (InjectableObserverMethod<?> observer : this.observers) {
            if (!EventTypeAssignabilityRules.instance().matches(observer.getObservedType(), eventTypes) || !observer.getObservedQualifiers().isEmpty() && !this.registeredQualifiers.isSubset(observer.getObservedQualifiers(), eventQualifiers)) continue;
            resolvedObservers.add(observer);
        }
        resolvedObservers.sort(InjectableObserverMethod::compare);
        return resolvedObservers;
    }

    List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        if (this.interceptors.isEmpty()) {
            return Collections.emptyList();
        }
        if (interceptorBindings.length == 0) {
            throw new IllegalArgumentException("No interceptor bindings");
        }
        this.registeredInterceptorBindings.verify(interceptorBindings);
        ArrayList interceptors = new ArrayList();
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        for (Annotation binding : interceptorBindings) {
            bindings.add(binding);
            Set<Annotation> transitive = this.registeredInterceptorBindings.getTransitive(binding.annotationType());
            if (transitive == null) continue;
            bindings.addAll(transitive);
        }
        for (InjectableInterceptor injectableInterceptor : this.interceptors) {
            if (!injectableInterceptor.intercepts(type) || !this.hasAllInterceptionBindings(injectableInterceptor, bindings)) continue;
            interceptors.add(injectableInterceptor);
        }
        return interceptors;
    }

    List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... qualifiers) {
        if (this.decorators.isEmpty()) {
            return Collections.emptyList();
        }
        if (Objects.requireNonNull(types).isEmpty()) {
            throw new IllegalArgumentException("The set of bean types must not be empty");
        }
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        } else {
            this.registeredQualifiers.verify(qualifiers);
        }
        ArrayList decorators = new ArrayList();
        for (InjectableDecorator<?> decorator : this.decorators) {
            if (!this.decoratorMatches(decorator.getDelegateType(), decorator.getDelegateQualifiers(), types, Set.of(qualifiers))) continue;
            decorators.add(decorator);
        }
        return decorators;
    }

    private boolean hasAllInterceptionBindings(InjectableInterceptor<?> interceptor, Iterable<Annotation> bindings) {
        for (Annotation binding : interceptor.getInterceptorBindings()) {
            if (this.registeredQualifiers.hasQualifier(bindings, binding)) continue;
            return false;
        }
        return true;
    }

    Set<InjectableBean<?>> getResolvedBeans(Type requiredType, Annotation ... qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        } else {
            this.registeredQualifiers.verify(qualifiers);
        }
        return this.resolved.getValue(new Resolvable(requiredType, qualifiers));
    }

    private boolean matches(InjectableBean<?> bean, Type requiredType, Annotation ... qualifiers) {
        return this.matches(bean.getTypes(), bean.getQualifiers(), requiredType, qualifiers);
    }

    private boolean matches(Set<Type> beanTypes, Set<Annotation> beanQualifiers, Type requiredType, Annotation ... qualifiers) {
        if (!BeanTypeAssignabilityRules.instance().matches(requiredType, beanTypes)) {
            return false;
        }
        return this.registeredQualifiers.hasQualifiers(beanQualifiers, qualifiers);
    }

    private boolean decoratorMatches(Type delegateType, Set<Annotation> delegateQualifiers, Set<Type> requiredTypes, Set<Annotation> requiredQualifiers) {
        if (!DelegateInjectionPointAssignabilityRules.instance().matches(delegateType, requiredTypes)) {
            return false;
        }
        return this.registeredQualifiers.hasQualifiers(delegateQualifiers, requiredQualifiers.toArray(new Annotation[0]));
    }

    static ArcContainerImpl unwrap(ArcContainer container) {
        if (container instanceof ArcContainerImpl) {
            return (ArcContainerImpl)container;
        }
        throw new IllegalArgumentException();
    }

    public static void mockObservers(String beanIdentifier, boolean mock) {
        ArcContainerImpl.instance().mockObserversFor(beanIdentifier, mock);
    }

    private void mockObserversFor(String beanIdentifier, boolean mock) {
        for (InjectableObserverMethod<?> observer : this.observers) {
            if (!(observer instanceof Mockable) || !beanIdentifier.equals(observer.getDeclaringBeanIdentifier())) continue;
            Mockable mockable = (Mockable)((Object)observer);
            if (mock) {
                mockable.arc$setMock(null);
                continue;
            }
            mockable.arc$clearMock();
        }
    }

    public void mockObserversFor(Class<?> beanClass, boolean mock) {
        for (InjectableObserverMethod<?> observer : this.observers) {
            if (!(observer instanceof Mockable) || !beanClass.equals(observer.getBeanClass())) continue;
            Mockable mockable = (Mockable)((Object)observer);
            if (mock) {
                mockable.arc$setMock(null);
                continue;
            }
            mockable.arc$clearMock();
        }
    }

    public static ArcContainerImpl instance() {
        return ArcContainerImpl.unwrap(Arc.container());
    }

    private static final class Resolvable {
        private static final Annotation[] ANY_QUALIFIER = new Annotation[]{Any.Literal.INSTANCE};
        final Type requiredType;
        final Annotation[] qualifiers;

        Resolvable(Type requiredType, Annotation[] qualifiers) {
            Class rawType = Reflections.getRawType(requiredType);
            if (Event.class.equals(rawType) || Instance.class.equals(rawType) || InjectionPoint.class.equals(rawType)) {
                this.requiredType = rawType;
                this.qualifiers = ANY_QUALIFIER;
            } else {
                this.requiredType = requiredType;
                this.qualifiers = qualifiers;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.qualifiers);
            result = 31 * result + (this.requiredType == null ? 0 : this.requiredType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Resolvable)) {
                return false;
            }
            Resolvable other = (Resolvable)obj;
            if (this.requiredType == null ? other.requiredType != null : !this.requiredType.equals(other.requiredType)) {
                return false;
            }
            return Arrays.equals(this.qualifiers, other.qualifiers);
        }
    }
}

