/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.cli;

import io.grpc.reflection.v1.MutinyServerReflectionGrpc;
import io.grpc.reflection.v1.ServerReflectionRequest;
import io.grpc.reflection.v1.ServerReflectionResponse;
import io.grpc.reflection.v1.ServiceResponse;
import io.quarkus.grpc.cli.GcurlBaseCommand;
import io.smallrye.mutiny.Multi;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="list", sortOptions=false, header={"gRPC list"})
public class ListCommand
extends GcurlBaseCommand {
    @Override
    public String getAction() {
        return "list";
    }

    @Override
    protected void execute(MutinyServerReflectionGrpc.MutinyServerReflectionStub stub) {
        ServerReflectionRequest request = ServerReflectionRequest.newBuilder().setListServices("dummy").build();
        Multi<ServerReflectionResponse> response = stub.serverReflectionInfo(Multi.createFrom().item(request));
        response.toUni().map(r -> {
            List<ServiceResponse> serviceList = r.getListServicesResponse().getServiceList();
            serviceList.forEach(sr -> this.log(sr.getName()));
            return null;
        }).await().indefinitely();
    }
}

