/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.reflection.v1;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.reflection.v1.ServerReflectionGrpc;
import io.grpc.reflection.v1.ServerReflectionRequest;
import io.grpc.reflection.v1.ServerReflectionResponse;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.MutinyGrpc;
import io.quarkus.grpc.MutinyStub;
import io.quarkus.grpc.stubs.ClientCalls;
import io.smallrye.mutiny.Multi;

public final class MutinyServerReflectionGrpc
implements MutinyGrpc {
    private static final int METHODID_SERVER_REFLECTION_INFO = 0;

    private MutinyServerReflectionGrpc() {
    }

    public static MutinyServerReflectionStub newMutinyStub(Channel channel) {
        return new MutinyServerReflectionStub(channel);
    }

    public static final class MutinyServerReflectionStub
    extends AbstractStub<MutinyServerReflectionStub>
    implements MutinyStub {
        private ServerReflectionGrpc.ServerReflectionStub delegateStub;

        private MutinyServerReflectionStub(Channel channel) {
            super(channel);
            this.delegateStub = ServerReflectionGrpc.newStub(channel);
        }

        private MutinyServerReflectionStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = ServerReflectionGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected MutinyServerReflectionStub build(Channel channel, CallOptions callOptions) {
            return new MutinyServerReflectionStub(channel, callOptions);
        }

        public Multi<ServerReflectionResponse> serverReflectionInfo(Multi<ServerReflectionRequest> request) {
            return ClientCalls.manyToMany(request, this.delegateStub::serverReflectionInfo);
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ServerReflectionImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(ServerReflectionImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return io.quarkus.grpc.stubs.ServerCalls.manyToMany(responseObserver, this.serviceImpl::serverReflectionInfo);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class ServerReflectionImplBase
    implements BindableService {
        private String compression;

        public ServerReflectionImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Multi<ServerReflectionResponse> serverReflectionInfo(Multi<ServerReflectionRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(ServerReflectionGrpc.getServiceDescriptor()).addMethod(ServerReflectionGrpc.getServerReflectionInfoMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0, this.compression))).build();
        }
    }
}

