/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class TypeVariableImpl<D extends GenericDeclaration>
implements TypeVariable<D> {
    private final String name;
    private final List<Type> bounds;

    public TypeVariableImpl(String name, Type ... bounds) {
        this.name = name;
        this.bounds = Arrays.asList(bounds);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation[] getAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type[] getBounds() {
        return this.bounds.toArray(new Type[this.bounds.size()]);
    }

    @Override
    public D getGenericDeclaration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AnnotatedType[] getAnnotatedBounds() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.bounds);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeVariable)) {
            return false;
        }
        TypeVariable other = (TypeVariable)obj;
        return Objects.equals(this.name, other.getName()) && Arrays.equals(this.getBounds(), other.getBounds());
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(" & ", " extends ", "");
        joiner.setEmptyValue("");
        for (Type bound : this.bounds) {
            if (bound instanceof Class) {
                joiner.add(((Class)bound).getName());
                continue;
            }
            joiner.add(bound.toString());
        }
        return this.name + joiner;
    }
}

