/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.time.Duration;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Predicate;

public class ExponentialBackoff {
    public static final Duration MAX_BACKOFF = Duration.ofMillis(Long.MAX_VALUE);
    public static final double DEFAULT_JITTER = 0.5;

    private ExponentialBackoff() {
    }

    public static Function<Multi<Throwable>, Flow.Publisher<Long>> randomExponentialBackoffFunction(final long numRetries, final Duration firstBackoff, final Duration maxBackoff, final double jitterFactor, final ScheduledExecutorService executor) {
        ExponentialBackoff.validate(firstBackoff, maxBackoff, jitterFactor, executor);
        return new Function<Multi<Throwable>, Flow.Publisher<Long>>(){
            int index;

            @Override
            public Flow.Publisher<Long> apply(Multi<Throwable> t) {
                return t.onItem().transformToUniAndConcatenate(failure -> {
                    int iteration;
                    if ((long)(iteration = this.index++) >= numRetries) {
                        failure.addSuppressed(new IllegalStateException("Retries exhausted: " + iteration + "/" + numRetries, (Throwable)failure));
                        return Uni.createFrom().failure((Throwable)failure);
                    }
                    Duration delay = ExponentialBackoff.getNextDelay(firstBackoff, maxBackoff, jitterFactor, iteration);
                    return Uni.createFrom().item(Long.valueOf(iteration)).onItem().delayIt().onExecutor(executor).by(delay);
                });
            }
        };
    }

    private static Duration getNextDelay(Duration firstBackoff, Duration maxBackoff, double jitterFactor, int iteration) {
        Duration nextBackoff = ExponentialBackoff.getNextAttemptDelay(firstBackoff, maxBackoff, iteration);
        long jitterOffset = ExponentialBackoff.getJitter(jitterFactor, nextBackoff);
        long lowBound = Math.max(firstBackoff.minus(nextBackoff).toMillis(), -jitterOffset);
        long highBound = Math.min(maxBackoff.minus(nextBackoff).toMillis(), jitterOffset);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long jitter = highBound == lowBound ? (highBound == 0L ? 0L : random.nextLong(highBound)) : random.nextLong(lowBound, highBound);
        return nextBackoff.plusMillis(jitter);
    }

    private static void validate(Duration firstBackoff, Duration maxBackoff, double jitterFactor, ScheduledExecutorService executor) {
        if (jitterFactor < 0.0 || jitterFactor > 1.0) {
            throw new IllegalArgumentException("jitterFactor must be between 0 and 1 (default 0.5)");
        }
        ParameterValidation.nonNull(firstBackoff, "firstBackoff");
        ParameterValidation.nonNull(maxBackoff, "maxBackoff");
        ParameterValidation.nonNull(executor, "executor");
    }

    public static Function<Multi<Throwable>, Flow.Publisher<Long>> randomExponentialBackoffFunctionExpireAt(final long expireAt, final Duration firstBackoff, final Duration maxBackoff, final double jitterFactor, final ScheduledExecutorService executor) {
        ExponentialBackoff.validate(firstBackoff, maxBackoff, jitterFactor, executor);
        return new Function<Multi<Throwable>, Flow.Publisher<Long>>(){
            int index;

            @Override
            public Flow.Publisher<Long> apply(Multi<Throwable> t) {
                return t.onItem().transformToUniAndConcatenate(failure -> {
                    int iteration = this.index++;
                    Duration delay = ExponentialBackoff.getNextDelay(firstBackoff, maxBackoff, jitterFactor, iteration);
                    long checkTime = System.currentTimeMillis() + delay.toMillis();
                    if (checkTime > expireAt) {
                        return Uni.createFrom().failure(new IllegalStateException("Retries exhausted : " + iteration + " attempts against " + checkTime + "/" + expireAt + " expiration", (Throwable)failure));
                    }
                    return Uni.createFrom().item(Long.valueOf(iteration)).onItem().delayIt().onExecutor(executor).by(delay);
                });
            }
        };
    }

    private static long getJitter(double jitterFactor, Duration nextBackoff) {
        long jitterOffset;
        try {
            jitterOffset = nextBackoff.multipliedBy((long)(100.0 * jitterFactor)).dividedBy(100L).toMillis();
        }
        catch (ArithmeticException ae) {
            jitterOffset = Math.round(9.223372036854776E18 * jitterFactor);
        }
        return jitterOffset;
    }

    private static Duration getNextAttemptDelay(Duration firstBackoff, Duration maxBackoff, int iteration) {
        Duration nextBackoff;
        try {
            nextBackoff = firstBackoff.multipliedBy((long)Math.pow(2.0, iteration));
            if (nextBackoff.compareTo(maxBackoff) > 0) {
                nextBackoff = maxBackoff;
            }
        }
        catch (ArithmeticException overflow) {
            nextBackoff = maxBackoff;
        }
        return nextBackoff;
    }

    public static Function<Multi<Throwable>, Flow.Publisher<Long>> backoffWithPredicateFactory(final Duration initialBackOff, final double jitter, final Duration maxBackoff, final Predicate<? super Throwable> predicate, final ScheduledExecutorService pool) {
        return new Function<Multi<Throwable>, Flow.Publisher<Long>>(){
            int index = 0;

            @Override
            public Flow.Publisher<Long> apply(Multi<Throwable> stream) {
                return stream.onItem().transformToUniAndConcatenate(failure -> {
                    int iteration = this.index++;
                    try {
                        if (predicate.test(failure)) {
                            Duration delay = ExponentialBackoff.getNextDelay(initialBackOff, maxBackoff, jitter, iteration);
                            return Uni.createFrom().item(Long.valueOf(iteration)).onItem().delayIt().onExecutor(pool).by(delay);
                        }
                        return Uni.createFrom().failure((Throwable)failure);
                    }
                    catch (Throwable err) {
                        failure.addSuppressed(err);
                        return Uni.createFrom().failure((Throwable)failure);
                    }
                });
            }
        };
    }

    public static Function<Multi<Throwable>, Flow.Publisher<Long>> noBackoffPredicateFactory(final Predicate<? super Throwable> predicate) {
        return new Function<Multi<Throwable>, Flow.Publisher<Long>>(){

            @Override
            public Flow.Publisher<Long> apply(Multi<Throwable> stream) {
                return stream.onItem().transformToUniAndConcatenate(failure -> {
                    try {
                        if (predicate.test(failure)) {
                            return Uni.createFrom().item(1L);
                        }
                        return Uni.createFrom().failure((Throwable)failure);
                    }
                    catch (Throwable err) {
                        return Uni.createFrom().failure(err);
                    }
                });
            }
        };
    }
}

