/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.reflection.v1alpha;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.reflection.v1alpha.ServerReflectionGrpc;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.reflection.v1alpha.ServerReflectionResponse;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.runtime.ClientCalls;
import io.quarkus.grpc.runtime.ServerCalls;
import io.smallrye.mutiny.Multi;

public final class MutinyServerReflectionGrpc {
    private static final int METHODID_SERVER_REFLECTION_INFO = 0;

    private MutinyServerReflectionGrpc() {
    }

    public static MutinyServerReflectionStub newMutinyStub(Channel channel) {
        return new MutinyServerReflectionStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ServerReflectionImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(ServerReflectionImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return ServerCalls.manyToMany(responseObserver, this.serviceImpl::serverReflectionInfo);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class ServerReflectionImplBase
    implements BindableService {
        public Multi<ServerReflectionResponse> serverReflectionInfo(Multi<ServerReflectionRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)ServerReflectionGrpc.getServiceDescriptor()).addMethod(ServerReflectionGrpc.getServerReflectionInfoMethod(), io.grpc.stub.ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0))).build();
        }
    }

    public static final class MutinyServerReflectionStub
    extends AbstractStub<MutinyServerReflectionStub> {
        private ServerReflectionGrpc.ServerReflectionStub delegateStub;

        private MutinyServerReflectionStub(Channel channel) {
            super(channel);
            this.delegateStub = ServerReflectionGrpc.newStub(channel);
        }

        private MutinyServerReflectionStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = ServerReflectionGrpc.newStub(channel).build(channel, callOptions);
        }

        protected MutinyServerReflectionStub build(Channel channel, CallOptions callOptions) {
            return new MutinyServerReflectionStub(channel, callOptions);
        }

        public Multi<ServerReflectionResponse> serverReflectionInfo(Multi<ServerReflectionRequest> hdlr) {
            return ClientCalls.manyToMany(hdlr, this.delegateStub::serverReflectionInfo);
        }
    }
}

