/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.auth;

import io.grpc.BindableService;
import io.grpc.ServerMethodDefinition;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.grpc.auth.GrpcSecurityInterceptor;
import io.quarkus.grpc.runtime.GrpcContainer;
import io.quarkus.grpc.runtime.GrpcServerRecorder;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Recorder
public class GrpcSecurityRecorder {
    public void initGrpcSecurityInterceptor(Map<String, List<String>> serviceClassToBlockingMethod, BeanContainer container) {
        HashMap<String, List<String>> svcToMethods = new HashMap<String, List<String>>();
        Instance<BindableService> services = ((GrpcContainer)container.beanInstance(GrpcContainer.class, new Annotation[0])).getServices();
        for (BindableService service : services) {
            String className = GrpcServerRecorder.GrpcServiceDefinition.getImplementationClassName(service);
            List<String> blockingMethods = serviceClassToBlockingMethod.get(className);
            if (blockingMethods == null || blockingMethods.isEmpty()) continue;
            String svcName = service.bindService().getServiceDescriptor().getName();
            ArrayList<String> methods = new ArrayList<String>();
            block1: for (String blockingMethod : blockingMethods) {
                for (ServerMethodDefinition method : service.bindService().getMethods()) {
                    if (!blockingMethod.equals(method.getMethodDescriptor().getBareMethodName())) continue;
                    methods.add(method.getMethodDescriptor().getFullMethodName());
                    continue block1;
                }
            }
            svcToMethods.put(svcName, methods);
        }
        ((GrpcSecurityInterceptor)container.beanInstance(GrpcSecurityInterceptor.class, new Annotation[0])).init(svcToMethods);
    }
}

