/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.blocking;

import io.grpc.Context;
import io.grpc.ServerCall;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import java.util.concurrent.Callable;
import java.util.function.Consumer;

class BlockingExecutionHandler<ReqT>
implements Callable<Void> {
    private final ServerCall.Listener<ReqT> delegate;
    private final Context grpcContext;
    private final Consumer<ServerCall.Listener<ReqT>> consumer;
    private final InjectableContext.ContextState state;
    private final ManagedContext requestContext;
    private final Object lock;

    public BlockingExecutionHandler(Consumer<ServerCall.Listener<ReqT>> consumer, Context grpcContext, ServerCall.Listener<ReqT> delegate, InjectableContext.ContextState state, ManagedContext requestContext, Object lock) {
        this.consumer = consumer;
        this.grpcContext = grpcContext;
        this.delegate = delegate;
        this.state = state;
        this.requestContext = requestContext;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() {
        Object object = this.lock;
        synchronized (object) {
            Void void_;
            Context previous = this.grpcContext.attach();
            try {
                this.requestContext.activate(this.state);
                try {
                    this.consumer.accept(this.delegate);
                }
                finally {
                    this.requestContext.deactivate();
                }
                void_ = null;
            }
            catch (Throwable throwable) {
                this.grpcContext.detach(previous);
                throw throwable;
            }
            this.grpcContext.detach(previous);
            return void_;
        }
    }
}

