/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import java.util.HashMap;
import java.util.Map;

public class HibernateConfigUtil {
    private static final String EXPIRATION_MAX_IDLE = ".expiration.max-idle";
    private static final String MEMORY_OBJECT_COUNT = ".memory.object-count";
    private static final String HIBERNATE_CACHE_PREFIX = "hibernate.cache.";

    public static Map<String, String> getCacheConfigEntries(HibernateOrmConfig config) {
        HashMap<String, String> cacheRegionsConfigEntries = new HashMap<String, String>();
        for (Map.Entry<String, HibernateOrmConfig.HibernateOrmConfigCache> regionEntry : config.cache.entrySet()) {
            String regionName = regionEntry.getKey();
            HibernateOrmConfig.HibernateOrmConfigCache cacheConfig = regionEntry.getValue();
            if (cacheConfig.expiration.maxIdle.isPresent()) {
                cacheRegionsConfigEntries.put(HibernateConfigUtil.getCacheConfigKey(regionName, EXPIRATION_MAX_IDLE), String.valueOf(cacheConfig.expiration.maxIdle.get().getSeconds()));
            }
            if (!cacheConfig.memory.objectCount.isPresent()) continue;
            cacheRegionsConfigEntries.put(HibernateConfigUtil.getCacheConfigKey(regionName, MEMORY_OBJECT_COUNT), String.valueOf(cacheConfig.memory.objectCount.getAsLong()));
        }
        return cacheRegionsConfigEntries;
    }

    private static String getCacheConfigKey(String regionName, String configKey) {
        return HIBERNATE_CACHE_PREFIX + regionName + configKey;
    }
}

