/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import java.util.Set;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public final class PersistenceUnitDescriptorBuildItem
extends MultiBuildItem {
    private final ParsedPersistenceXmlDescriptor descriptor;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final boolean isReactive;

    public PersistenceUnitDescriptorBuildItem(ParsedPersistenceXmlDescriptor descriptor, boolean isReactive) {
        this.descriptor = descriptor;
        this.multiTenancyStrategy = MultiTenancyStrategy.NONE;
        this.isReactive = isReactive;
    }

    public PersistenceUnitDescriptorBuildItem(ParsedPersistenceXmlDescriptor descriptor, MultiTenancyStrategy multiTenancyStrategy, boolean isReactive) {
        this.descriptor = descriptor;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.isReactive = isReactive;
    }

    public void addListedEntityClassNamesTo(Set<String> classNames) {
        classNames.addAll(this.descriptor.getManagedClassNames());
    }

    public String getExplicitSqlImportScriptResourceName() {
        return this.descriptor.getProperties().getProperty("javax.persistence.sql-load-script-source");
    }

    public String getPersistenceUnitName() {
        return this.descriptor.getName();
    }

    public QuarkusPersistenceUnitDefinition asOutputPersistenceUnitDefinition() {
        return new QuarkusPersistenceUnitDefinition((PersistenceUnitDescriptor)this.descriptor, this.multiTenancyStrategy, this.isReactive);
    }
}

