/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.standalone.elasticsearch.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchConfigUtil;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchStandaloneBuildTimeConfig;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchStandalonePreBootState;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchStandaloneRuntimeConfig;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.bean.ArcBeanProvider;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.bean.HibernateSearchBeanUtil;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.management.HibernateSearchStandaloneManagementHandler;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.mapping.QuarkusHibernateSearchStandaloneMappingConfigurer;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.pojo.standalone.bootstrap.spi.StandalonePojoIntegrationBooter;
import org.hibernate.search.mapper.pojo.standalone.mapping.SearchMapping;
import org.hibernate.search.mapper.pojo.standalone.mapping.StandalonePojoMappingConfigurer;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;

@Recorder
public class HibernateSearchStandaloneRecorder {
    public void preBoot(HibernateSearchStandaloneBuildTimeConfig buildTimeConfig, Map<String, Set<String>> backendAndIndexNamesForSearchExtensions, Set<String> rootAnnotationMappedClassNames) {
        LinkedHashSet rootAnnotationMappedClasses = new LinkedHashSet();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        for (String className : rootAnnotationMappedClassNames) {
            try {
                rootAnnotationMappedClasses.add(Class.forName(className, true, tccl));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not initialize mapped class " + className, e);
            }
        }
        LinkedHashMap<String, Object> bootProperties = new LinkedHashMap<String, Object>();
        new StaticInitListener(buildTimeConfig, backendAndIndexNamesForSearchExtensions, rootAnnotationMappedClasses).contributeBootProperties(bootProperties::put);
        StandalonePojoIntegrationBooter booter = StandalonePojoIntegrationBooter.builder().properties(bootProperties).valueReadHandleFactory(ValueHandleFactory.usingJavaLangReflect()).property("hibernate.search.bean_provider", (Object)new ArcBeanProvider(Arc.container())).build();
        booter.preBoot(bootProperties::put);
        HibernateSearchStandalonePreBootState.set(bootProperties);
    }

    public void checkNoExplicitActiveTrue(HibernateSearchStandaloneRuntimeConfig runtimeConfig) {
        if (runtimeConfig.active().orElse(false).booleanValue()) {
            String enabledPropertyKey = HibernateSearchStandaloneRuntimeConfig.extensionPropertyKey("enabled");
            String activePropertyKey = HibernateSearchStandaloneRuntimeConfig.mapperPropertyKey("active");
            throw new ConfigurationException("Hibernate Search Standalone activated explicitly, but the Hibernate Search Standalone extension was disabled at build time. If you want Hibernate Search Standalone to be active, you must set '" + enabledPropertyKey + "' to 'true' at build time. If you don't want Hibernate Search Standalone to be active, you must leave '" + activePropertyKey + "' unset or set it to 'false'.", Set.of(enabledPropertyKey, activePropertyKey));
        }
    }

    public void clearPreBootState() {
        HibernateSearchStandalonePreBootState.pop();
    }

    public Function<SyntheticCreationalContext<SearchMapping>, SearchMapping> createSearchMappingFunction(final HibernateSearchStandaloneRuntimeConfig runtimeConfig, final Map<String, Set<String>> backendAndIndexNamesForSearchExtensions) {
        return new Function<SyntheticCreationalContext<SearchMapping>, SearchMapping>(){

            @Override
            public SearchMapping apply(SyntheticCreationalContext<SearchMapping> context) {
                if (runtimeConfig != null && !runtimeConfig.active().orElse(true).booleanValue()) {
                    throw new IllegalStateException("Cannot retrieve the SearchMapping: Hibernate Search Standalone was deactivated through configuration properties");
                }
                LinkedHashMap<String, Object> bootProperties = new LinkedHashMap<String, Object>(HibernateSearchStandalonePreBootState.pop());
                new RuntimeInitListener(runtimeConfig, backendAndIndexNamesForSearchExtensions).contributeRuntimeProperties(bootProperties::put);
                StandalonePojoIntegrationBooter booter = StandalonePojoIntegrationBooter.builder().properties(bootProperties).build();
                return booter.boot();
            }
        };
    }

    public void bootEagerly(HibernateSearchStandaloneRuntimeConfig runtimeConfig) {
        if (runtimeConfig != null && !runtimeConfig.active().orElse(true).booleanValue()) {
            return;
        }
        ((SearchMapping)Arc.container().instance(SearchMapping.class, new Annotation[0]).get()).allIndexedEntities();
    }

    public Handler<RoutingContext> managementHandler() {
        return new HibernateSearchStandaloneManagementHandler();
    }

    private static void mergeInto(Map<String, Set<String>> target, Map<String, Set<String>> source) {
        for (Map.Entry<String, Set<String>> entry : source.entrySet()) {
            HibernateSearchStandaloneRecorder.mergeInto(target, entry.getKey(), entry.getValue());
        }
    }

    private static void mergeInto(Map<String, Set<String>> target, String key, Set<String> values) {
        target.computeIfAbsent(key, ignored -> new LinkedHashSet()).addAll(values);
    }

    private static final class StaticInitListener {
        private final HibernateSearchStandaloneBuildTimeConfig buildTimeConfig;
        private final Map<String, Set<String>> backendAndIndexNamesForSearchExtensions;
        private final Set<Class<?>> rootAnnotationMappedClasses;

        private StaticInitListener(HibernateSearchStandaloneBuildTimeConfig buildTimeConfig, Map<String, Set<String>> backendAndIndexNamesForSearchExtensions, Set<Class<?>> rootAnnotationMappedClasses) {
            this.buildTimeConfig = buildTimeConfig;
            this.backendAndIndexNamesForSearchExtensions = backendAndIndexNamesForSearchExtensions;
            this.rootAnnotationMappedClasses = rootAnnotationMappedClasses;
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.background_failure_handler", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.buildTimeConfig == null ? Optional.empty() : this.buildTimeConfig.backgroundFailureHandler(), FailureHandler.class, null, null));
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.mapping.configurer", this.collectAllStandalonePojoMappingConfigurers());
            Map backendConfigs = this.buildTimeConfig == null ? Collections.emptyMap() : this.buildTimeConfig.backends();
            LinkedHashMap<String, Set<String>> backendAndIndexNames = new LinkedHashMap<String, Set<String>>();
            HibernateSearchStandaloneRecorder.mergeInto(backendAndIndexNames, this.backendAndIndexNamesForSearchExtensions);
            for (Map.Entry entry : backendConfigs.entrySet()) {
                HibernateSearchStandaloneRecorder.mergeInto(backendAndIndexNames, (String)entry.getKey(), ((HibernateSearchStandaloneBuildTimeConfig.ElasticsearchBackendBuildTimeConfig)entry.getValue()).indexes().keySet());
            }
            for (Map.Entry entry : backendAndIndexNames.entrySet()) {
                String backendName = (String)entry.getKey();
                Set indexNames = (Set)entry.getValue();
                this.contributeBackendBuildTimeProperties(propertyCollector, backendName, indexNames, (HibernateSearchStandaloneBuildTimeConfig.ElasticsearchBackendBuildTimeConfig)backendConfigs.get(backendName));
            }
        }

        private List<BeanReference<StandalonePojoMappingConfigurer>> collectAllStandalonePojoMappingConfigurers() {
            ArrayList<BeanReference<StandalonePojoMappingConfigurer>> configurers = new ArrayList<BeanReference<StandalonePojoMappingConfigurer>>();
            configurers.add(BeanReference.ofInstance((Object)new QuarkusHibernateSearchStandaloneMappingConfigurer(this.buildTimeConfig.mapping().structure(), this.rootAnnotationMappedClasses)));
            Optional<List<BeanReference<StandalonePojoMappingConfigurer>>> beanReferences = HibernateSearchBeanUtil.multiExtensionBeanReferencesFor(this.buildTimeConfig.mapping().configurer(), StandalonePojoMappingConfigurer.class, null, null);
            if (beanReferences.isPresent()) {
                configurers.addAll((Collection<BeanReference<StandalonePojoMappingConfigurer>>)beanReferences.get());
            }
            return configurers;
        }

        private void contributeBackendBuildTimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, Set<String> indexNames, HibernateSearchStandaloneBuildTimeConfig.ElasticsearchBackendBuildTimeConfig elasticsearchBackendConfig) {
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "type", "elasticsearch");
            if (elasticsearchBackendConfig != null) {
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "version", elasticsearchBackendConfig.version());
            }
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "layout.strategy", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(elasticsearchBackendConfig == null ? Optional.empty() : elasticsearchBackendConfig.layout().strategy(), IndexLayoutStrategy.class, backendName, null));
            this.contributeBackendIndexBuildTimeProperties(propertyCollector, backendName, null, elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexDefaults());
            for (String indexName : indexNames) {
                HibernateSearchStandaloneBuildTimeConfig.ElasticsearchIndexBuildTimeConfig indexConfig = elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexes().get(indexName);
                this.contributeBackendIndexBuildTimeProperties(propertyCollector, backendName, indexName, indexConfig);
            }
        }

        private void contributeBackendIndexBuildTimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, String indexName, HibernateSearchStandaloneBuildTimeConfig.ElasticsearchIndexBuildTimeConfig indexConfig) {
            if (indexConfig != null) {
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.settings_file", indexConfig.schemaManagement().settingsFile());
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.mapping_file", indexConfig.schemaManagement().mappingFile());
            }
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "analysis.configurer", HibernateSearchBeanUtil.multiExtensionBeanReferencesFor(indexConfig == null ? Optional.empty() : indexConfig.analysis().configurer(), ElasticsearchAnalysisConfigurer.class, backendName, indexName));
        }
    }

    private static final class RuntimeInitListener {
        private final HibernateSearchStandaloneRuntimeConfig runtimeConfig;
        private final Map<String, Set<String>> backendAndIndexNamesForSearchExtensions;

        private RuntimeInitListener(HibernateSearchStandaloneRuntimeConfig runtimeConfig, Map<String, Set<String>> backendAndIndexNamesForSearchExtensions) {
            this.runtimeConfig = runtimeConfig;
            this.backendAndIndexNamesForSearchExtensions = backendAndIndexNamesForSearchExtensions;
        }

        public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
            if (this.runtimeConfig != null) {
                HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.schema_management.strategy", this.runtimeConfig.schemaManagement().strategy());
            }
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.indexing.plan.synchronization.strategy", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.runtimeConfig == null ? Optional.empty() : this.runtimeConfig.indexing().plan().synchronization().strategy(), IndexingPlanSynchronizationStrategy.class, null, null));
            Map backendConfigs = this.runtimeConfig == null ? Collections.emptyMap() : this.runtimeConfig.backends();
            LinkedHashMap<String, Set<String>> backendAndIndexNames = new LinkedHashMap<String, Set<String>>();
            HibernateSearchStandaloneRecorder.mergeInto(backendAndIndexNames, this.backendAndIndexNamesForSearchExtensions);
            for (Map.Entry entry : backendConfigs.entrySet()) {
                HibernateSearchStandaloneRecorder.mergeInto(backendAndIndexNames, (String)entry.getKey(), ((HibernateSearchStandaloneRuntimeConfig.ElasticsearchBackendRuntimeConfig)entry.getValue()).indexes().keySet());
            }
            for (Map.Entry entry : backendAndIndexNames.entrySet()) {
                String backendName = (String)entry.getKey();
                Set indexNames = (Set)entry.getValue();
                this.contributeBackendRuntimeProperties(propertyCollector, backendName, indexNames, (HibernateSearchStandaloneRuntimeConfig.ElasticsearchBackendRuntimeConfig)backendConfigs.get(backendName));
            }
        }

        private void contributeBackendRuntimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, Set<String> indexNames, HibernateSearchStandaloneRuntimeConfig.ElasticsearchBackendRuntimeConfig elasticsearchBackendConfig) {
            if (elasticsearchBackendConfig != null) {
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "hosts", elasticsearchBackendConfig.hosts());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "protocol", elasticsearchBackendConfig.protocol().getHibernateSearchString());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "username", elasticsearchBackendConfig.username());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "password", elasticsearchBackendConfig.password());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "connection_timeout", elasticsearchBackendConfig.connectionTimeout().toMillis());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "read_timeout", elasticsearchBackendConfig.readTimeout().toMillis());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "request_timeout", elasticsearchBackendConfig.requestTimeout(), Optional::isPresent, d -> ((Duration)d.get()).toMillis());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "max_connections", elasticsearchBackendConfig.maxConnections());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "max_connections_per_route", elasticsearchBackendConfig.maxConnectionsPerRoute());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "thread_pool.size", elasticsearchBackendConfig.threadPool().size());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "version_check.enabled", elasticsearchBackendConfig.versionCheck().enabled());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "query.shard_failure.ignore", elasticsearchBackendConfig.query().shardFailure().ignore());
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "discovery.enabled", elasticsearchBackendConfig.discovery().enabled());
                if (elasticsearchBackendConfig.discovery().enabled().booleanValue()) {
                    HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "discovery.refresh_interval", elasticsearchBackendConfig.discovery().refreshInterval().getSeconds());
                }
            }
            this.contributeBackendIndexRuntimeProperties(propertyCollector, backendName, null, elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexDefaults());
            for (String indexName : indexNames) {
                HibernateSearchStandaloneRuntimeConfig.ElasticsearchIndexRuntimeConfig indexConfig = elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexes().get(indexName);
                this.contributeBackendIndexRuntimeProperties(propertyCollector, backendName, indexName, indexConfig);
            }
        }

        private void contributeBackendIndexRuntimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, String indexName, HibernateSearchStandaloneRuntimeConfig.ElasticsearchIndexRuntimeConfig indexConfig) {
            if (indexConfig != null) {
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.minimal_required_status", indexConfig.schemaManagement().requiredStatus());
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.minimal_required_status_wait_timeout", indexConfig.schemaManagement().requiredStatusWaitTimeout(), Optional::isPresent, d -> ((Duration)d.get()).toMillis());
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.queue_count", indexConfig.indexing().queueCount());
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.queue_size", indexConfig.indexing().queueSize());
                HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.max_bulk_size", indexConfig.indexing().maxBulkSize());
            }
        }
    }
}

