/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runner.bootstrap.AugmentActionImpl;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.test.ExportUtil;
import io.quarkus.test.InMemoryLogHandler;
import io.quarkus.test.PropertiesAsset;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import org.jboss.logmanager.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.extension.TestInstantiationException;

public class QuarkusUnitTest
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
InvocationInterceptor {
    public static final String THE_BUILD_WAS_EXPECTED_TO_FAIL = "The build was expected to fail";
    private static final Logger rootLogger;
    private Handler[] originalHandlers;
    boolean started = false;
    private Path deploymentDir;
    private Consumer<Throwable> assertException;
    private Supplier<JavaArchive> archiveProducer;
    private List<Consumer<BuildChainBuilder>> buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>();
    private Runnable afterUndeployListener;
    private String logFileName;
    private InMemoryLogHandler inMemoryLogHandler = new InMemoryLogHandler(r -> false);
    private Consumer<List<LogRecord>> assertLogRecords;
    private static final Timer timeoutTimer;
    private volatile TimerTask timeoutTask;
    private Properties customApplicationProperties;
    private Runnable beforeAllCustomizer;
    private Runnable afterAllCustomizer;
    private CuratedApplication curatedApplication;
    private RunningQuarkusApplication runningQuarkusApplication;
    private ClassLoader originalClassLoader;
    private List<AppArtifact> forcedDependencies = Collections.emptyList();
    private boolean useSecureConnection;
    private Class<?> actualTestClass;
    private Object actualTestInstance;
    private String[] commandLineParameters = new String[0];
    private boolean allowTestClassOutsideDeployment;

    public QuarkusUnitTest setExpectedException(Class<? extends Throwable> expectedException) {
        return this.assertException(t -> {
            boolean found = false;
            for (Throwable i = t; i != null; i = i.getCause()) {
                if (!i.getClass().getName().equals(expectedException.getName())) continue;
                found = true;
                break;
            }
            Assertions.assertTrue((boolean)found, (String)("Build failed with wrong exception, expected " + expectedException + " but got " + t));
        });
    }

    public QuarkusUnitTest() {
        this(false);
    }

    public static QuarkusUnitTest withSecuredConnection() {
        return new QuarkusUnitTest(true);
    }

    private QuarkusUnitTest(boolean useSecureConnection) {
        this.useSecureConnection = useSecureConnection;
    }

    public QuarkusUnitTest assertException(Consumer<Throwable> assertException) {
        if (this.assertException != null) {
            throw new IllegalStateException("Don't set the asserted or excepted exception twice to avoid shadowing out the first call.");
        }
        this.assertException = assertException;
        return this;
    }

    public Supplier<JavaArchive> getArchiveProducer() {
        return this.archiveProducer;
    }

    public QuarkusUnitTest setArchiveProducer(Supplier<JavaArchive> archiveProducer) {
        Objects.requireNonNull(archiveProducer);
        this.archiveProducer = archiveProducer;
        return this;
    }

    public QuarkusUnitTest addBuildChainCustomizer(Consumer<BuildChainBuilder> customizer) {
        this.buildChainCustomizers.add(customizer);
        return this;
    }

    public QuarkusUnitTest setLogFileName(String logFileName) {
        this.logFileName = logFileName;
        return this;
    }

    public QuarkusUnitTest setLogRecordPredicate(Predicate<LogRecord> predicate) {
        this.inMemoryLogHandler = new InMemoryLogHandler(predicate);
        return this;
    }

    public List<LogRecord> getLogRecords() {
        return this.inMemoryLogHandler.records;
    }

    public void clearLogRecords() {
        this.inMemoryLogHandler.clearRecords();
    }

    public QuarkusUnitTest assertLogRecords(Consumer<List<LogRecord>> assertLogRecords) {
        if (this.assertLogRecords != null) {
            throw new IllegalStateException("Don't set the a log record assertion twice to avoid shadowing out the first call.");
        }
        this.assertLogRecords = assertLogRecords;
        return this;
    }

    public QuarkusUnitTest setBeforeAllCustomizer(Runnable beforeAllCustomizer) {
        this.beforeAllCustomizer = beforeAllCustomizer;
        return this;
    }

    public QuarkusUnitTest setAfterAllCustomizer(Runnable afterAllCustomizer) {
        this.afterAllCustomizer = afterAllCustomizer;
        return this;
    }

    public QuarkusUnitTest setForcedDependencies(List<AppArtifact> forcedDependencies) {
        this.forcedDependencies = forcedDependencies;
        return this;
    }

    public String[] getCommandLineParameters() {
        return this.commandLineParameters;
    }

    public QuarkusUnitTest setCommandLineParameters(String ... commandLineParameters) {
        this.commandLineParameters = commandLineParameters;
        return this;
    }

    public QuarkusUnitTest setAllowTestClassOutsideDeployment(boolean allowTestClassOutsideDeployment) {
        this.allowTestClassOutsideDeployment = allowTestClassOutsideDeployment;
        return this;
    }

    private void exportArchive(Path deploymentDir, Class<?> testClass) {
        try {
            JavaArchive archive = this.getArchiveProducerOrDefault();
            for (Class<?> c = testClass; c != Object.class; c = c.getSuperclass()) {
                archive.addClass(c);
            }
            if (this.customApplicationProperties != null) {
                archive.add((Asset)new PropertiesAsset(this.customApplicationProperties), "application.properties");
            }
            ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExplodedInto(deploymentDir.toFile());
            ExportUtil.exportToQuarkusDeploymentPath(archive);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create the archive", e);
        }
    }

    private JavaArchive getArchiveProducerOrDefault() {
        if (this.archiveProducer == null) {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        }
        return this.archiveProducer.get();
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runExtensionMethod(invocationContext);
        invocation.skip();
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runExtensionMethod(invocationContext);
        invocation.skip();
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.assertException == null) {
            this.runExtensionMethod(invocationContext);
            invocation.skip();
        } else {
            invocation.proceed();
        }
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.assertException == null) {
            this.runExtensionMethod(invocationContext);
        }
        invocation.skip();
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.assertException == null) {
            this.runExtensionMethod(invocationContext);
        }
        invocation.skip();
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.assertException == null) {
            this.runExtensionMethod(invocationContext);
        }
        invocation.skip();
    }

    private void runExtensionMethod(ReflectiveInvocationContext<Method> invocationContext) throws Throwable {
        Method newMethod = null;
        for (Class<?> c = this.actualTestClass; c != Object.class; c = c.getSuperclass()) {
            try {
                newMethod = c.getDeclaredMethod(((Method)invocationContext.getExecutable()).getName(), ((Method)invocationContext.getExecutable()).getParameterTypes());
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (newMethod == null) {
            throw new RuntimeException("Could not find method " + invocationContext.getExecutable() + " on test class");
        }
        try {
            newMethod.setAccessible(true);
            newMethod.invoke(this.actualTestInstance, invocationContext.getArguments().toArray());
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        block23: {
            ProfileManager.setLaunchMode((LaunchMode)LaunchMode.TEST);
            if (this.beforeAllCustomizer != null) {
                this.beforeAllCustomizer.run();
            }
            this.originalClassLoader = Thread.currentThread().getContextClassLoader();
            this.originalHandlers = rootLogger.getHandlers();
            rootLogger.addHandler((Handler)this.inMemoryLogHandler);
            this.timeoutTask = new TimerTask(){

                @Override
                public void run() {
                    System.err.println("Test has been running for more than 5 minutes, thread dump is:");
                    for (Map.Entry<Thread, StackTraceElement[]> i : Thread.getAllStackTraces().entrySet()) {
                        System.err.println("\n");
                        System.err.println(i.toString());
                        System.err.println("\n");
                        for (StackTraceElement j : i.getValue()) {
                            System.err.println(j);
                        }
                    }
                }
            };
            timeoutTimer.schedule(this.timeoutTask, 300000L);
            if (this.logFileName != null) {
                PropertyTestUtil.setLogFileProperty((String)this.logFileName);
            } else {
                PropertyTestUtil.setLogFileProperty();
            }
            ExtensionContext.Store store = extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
            if (store.get((Object)TestResourceManager.class.getName()) == null) {
                final TestResourceManager manager = new TestResourceManager(extensionContext.getRequiredTestClass());
                manager.init();
                manager.start();
                store.put((Object)TestResourceManager.class.getName(), (Object)new ExtensionContext.Store.CloseableResource(){

                    public void close() throws Throwable {
                        manager.close();
                    }
                });
            }
            final Class testClass = extensionContext.getRequiredTestClass();
            try {
                this.deploymentDir = Files.createTempDirectory("quarkus-unit-test", new FileAttribute[0]);
                this.exportArchive(this.deploymentDir, testClass);
                ArrayList<Consumer<BuildChainBuilder>> customizers = new ArrayList<Consumer<BuildChainBuilder>>(this.buildChainCustomizers);
                try {
                    final Class<BuildItem> buildItem = Class.forName("io.quarkus.arc.deployment.AdditionalBeanBuildItem").asSubclass(BuildItem.class);
                    customizers.add(new Consumer<BuildChainBuilder>(){

                        @Override
                        public void accept(BuildChainBuilder buildChainBuilder) {
                            buildChainBuilder.addBuildStep(new BuildStep(){

                                public void execute(BuildContext context) {
                                    try {
                                        Method factoryMethod = buildItem.getMethod("unremovableOf", Class.class);
                                        context.produce((BuildItem)factoryMethod.invoke(null, testClass));
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }).produces(buildItem).build();
                        }
                    });
                }
                catch (ClassNotFoundException buildItem) {
                    // empty catch block
                }
                Path testLocation = PathTestHelper.getTestClassesLocation((Class)testClass);
                try {
                    QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setApplicationRoot(this.deploymentDir).setMode(QuarkusBootstrap.Mode.TEST).addExcludedPath(testLocation).setProjectRoot(testLocation).setForcedDependencies(this.forcedDependencies.stream().map(d -> new AppDependency(d, "compile")).collect(Collectors.toList()));
                    if (!this.forcedDependencies.isEmpty()) {
                        builder.setDisableClasspathCache(true);
                    }
                    if (!this.allowTestClassOutsideDeployment) {
                        builder.setBaseClassLoader((ClassLoader)QuarkusClassLoader.builder((String)"QuarkusUnitTest ClassLoader", (ClassLoader)this.getClass().getClassLoader(), (boolean)false).addBannedElement(ClassPathElement.fromPath((Path)testLocation)).build());
                    }
                    this.curatedApplication = builder.build().bootstrap();
                    this.runningQuarkusApplication = new AugmentActionImpl(this.curatedApplication, customizers).createInitialRuntimeApplication().run(this.commandLineParameters);
                    Thread.currentThread().setContextClassLoader(this.runningQuarkusApplication.getClassLoader());
                    if (this.assertException != null) {
                        Assertions.fail((String)THE_BUILD_WAS_EXPECTED_TO_FAIL);
                    }
                    this.started = true;
                    System.setProperty("test.url", TestHTTPResourceManager.getUri((RunningQuarkusApplication)this.runningQuarkusApplication));
                    try {
                        this.actualTestClass = Class.forName(testClass.getName(), true, Thread.currentThread().getContextClassLoader());
                        this.actualTestInstance = this.runningQuarkusApplication.instance(this.actualTestClass, new Annotation[0]);
                        Class<?> resM = this.runningQuarkusApplication.getClassLoader().loadClass(TestHTTPResourceManager.class.getName());
                        resM.getDeclaredMethod("inject", Object.class).invoke(null, this.actualTestInstance);
                    }
                    catch (Exception e) {
                        throw new TestInstantiationException("Failed to create test instance", (Throwable)e);
                    }
                    extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)testClass.getName(), this.actualTestInstance);
                }
                catch (Throwable e) {
                    this.started = false;
                    if (this.assertException != null) {
                        if (e instanceof AssertionError && e.getMessage().equals(THE_BUILD_WAS_EXPECTED_TO_FAIL)) {
                            throw e;
                        }
                        if (e instanceof RuntimeException) {
                            Throwable cause = e.getCause();
                            if (cause != null && cause instanceof BuildException) {
                                this.assertException.accept(this.unwrapException(cause.getCause()));
                            } else if (cause != null) {
                                this.assertException.accept(this.unwrapException(cause));
                            } else {
                                this.assertException.accept(e);
                            }
                        } else {
                            this.assertException.accept(e);
                        }
                        break block23;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Throwable unwrapException(Throwable cause) {
        try {
            Class<?> localVer = QuarkusUnitTest.class.getClassLoader().loadClass(cause.getClass().getName());
            if (localVer != cause.getClass()) {
                Constructor<?> ctor = localVer.getConstructor(String.class, Throwable.class);
                return (Throwable)ctor.newInstance(cause.getMessage(), cause.getCause());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cause;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (this.assertLogRecords != null) {
            this.assertLogRecords.accept(this.inMemoryLogHandler.records);
        }
        rootLogger.setHandlers(this.originalHandlers);
        this.inMemoryLogHandler.clearRecords();
        try {
            if (this.runningQuarkusApplication != null) {
                this.runningQuarkusApplication.close();
            }
            if (this.afterUndeployListener != null) {
                this.afterUndeployListener.run();
            }
            if (this.curatedApplication != null) {
                this.curatedApplication.close();
            }
        }
        finally {
            System.clearProperty("test.url");
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
            this.timeoutTask.cancel();
            this.timeoutTask = null;
            if (this.deploymentDir != null) {
                FileUtil.deleteDirectory((Path)this.deploymentDir);
            }
            if (this.afterAllCustomizer != null) {
                this.afterAllCustomizer.run();
            }
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.runningQuarkusApplication != null) {
            this.runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("clearURL", new Class[0]).invoke(null, new Object[0]);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.assertException != null) {
            return;
        }
        if (this.runningQuarkusApplication == null) {
            Field extensionField;
            Optional testClass = context.getTestClass();
            if (testClass.isPresent() && (extensionField = (Field)Arrays.stream(((Class)testClass.get()).getDeclaredFields()).filter(f -> f.isAnnotationPresent(RegisterExtension.class) && QuarkusUnitTest.class.equals(f.getType())).findAny().orElse(null)) != null && !Modifier.isStatic(extensionField.getModifiers())) {
                throw new IllegalStateException("Test application not started - QuarkusUnitTest must be used with a static field: " + extensionField);
            }
            throw new IllegalStateException("Test application not started for an unknown reason");
        }
        this.runningQuarkusApplication.getClassLoader().loadClass(RestAssuredURLManager.class.getName()).getDeclaredMethod("setURL", Boolean.TYPE).invoke(null, this.useSecureConnection);
    }

    public Runnable getAfterUndeployListener() {
        return this.afterUndeployListener;
    }

    public QuarkusUnitTest setAfterUndeployListener(Runnable afterUndeployListener) {
        this.afterUndeployListener = afterUndeployListener;
        return this;
    }

    public QuarkusUnitTest withConfigurationResource(String resourceName) {
        if (this.customApplicationProperties == null) {
            this.customApplicationProperties = new Properties();
        }
        try {
            try (InputStream in = ClassLoader.getSystemResourceAsStream(resourceName);){
                this.customApplicationProperties.load(in);
            }
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load resource: '" + resourceName + "'");
        }
    }

    public QuarkusUnitTest overrideConfigKey(String propertyKey, String propertyValue) {
        if (this.customApplicationProperties == null) {
            this.customApplicationProperties = new Properties();
        }
        this.customApplicationProperties.put(propertyKey, propertyValue);
        return this;
    }

    static {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        rootLogger = (Logger)LogManager.getLogManager().getLogger("");
        timeoutTimer = new Timer("Test thread dump timer");
    }
}

