/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.deployment;

import io.quarkus.kafka.client.deployment.RedpandaBuildTimeConfig;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
public class KafkaDevServicesBuildTimeConfig {
    @ConfigItem
    public Optional<Boolean> enabled = Optional.empty();
    @ConfigItem
    public Optional<Integer> port;
    @ConfigItem(defaultValue="redpanda")
    public Provider provider = Provider.REDPANDA;
    @ConfigItem
    public Optional<String> imageName;
    @ConfigItem(defaultValue="true")
    public boolean shared;
    @ConfigItem(defaultValue="kafka")
    public String serviceName;
    @ConfigItem
    @ConfigDocMapKey(value="topic-name")
    public Map<String, Integer> topicPartitions;
    @ConfigItem(defaultValue="2S")
    public Duration topicPartitionsTimeout;
    @ConfigItem
    @ConfigDocMapKey(value="environment-variable-name")
    public Map<String, String> containerEnv;
    @ConfigItem
    public RedpandaBuildTimeConfig redpanda;

    public static enum Provider {
        REDPANDA("docker.io/redpandadata/redpanda:v24.1.2"),
        STRIMZI("quay.io/strimzi-test-container/test-container:latest-kafka-3.7.0"),
        KAFKA_NATIVE("quay.io/ogunalp/kafka-native:latest");

        private final String defaultImageName;

        private Provider(String imageName) {
            this.defaultImageName = imageName;
        }

        public String getDefaultImageName() {
            return this.defaultImageName;
        }
    }
}

