/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime;

import io.quarkus.arc.DefaultBean;
import io.quarkus.runtime.ApplicationConfig;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.Config;

@Singleton
public class KafkaRuntimeConfigProducer {
    private static final String CONFIG_PREFIX = "kafka";
    private static final String UI_CONFIG_PREFIX = "kafka.ui";
    private static final String GROUP_ID = "group.id";

    @Produces
    @DefaultBean
    @Singleton
    @Identifier(value="default-kafka-broker")
    public Map<String, Object> createKafkaRuntimeConfig(Config config, ApplicationConfig app) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String propertyName : config.getPropertyNames()) {
            String propertyNameLowerCase = propertyName.toLowerCase();
            if (propertyNameLowerCase.startsWith(UI_CONFIG_PREFIX)) {
                config.getOptionalValue(propertyName, String.class).orElse("");
            }
            if (!propertyNameLowerCase.startsWith(CONFIG_PREFIX) || propertyNameLowerCase.startsWith(UI_CONFIG_PREFIX) || propertyNameLowerCase.length() <= CONFIG_PREFIX.length()) continue;
            String effectivePropertyName = propertyNameLowerCase.substring(CONFIG_PREFIX.length() + 1).toLowerCase().replace("_", ".");
            String value = config.getOptionalValue(propertyName, String.class).orElse("");
            result.put(effectivePropertyName, value);
        }
        if (!result.isEmpty() && !result.containsKey(GROUP_ID) && app.name.isPresent()) {
            result.put(GROUP_ID, app.name.get());
        }
        return result;
    }
}

