/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.util.List;
import java.util.stream.Collectors;

public class RemoveDeploymentResourceDecorator
extends Decorator<KubernetesListBuilder> {
    private String name;

    public RemoveDeploymentResourceDecorator(String name) {
        this.name = name;
    }

    public void visit(KubernetesListBuilder builder) {
        List deployments = builder.buildItems().stream().filter(d -> d != null && d.getKind().equals("Deployment") && d.getMetadata().getName().equalsIgnoreCase(this.name)).collect(Collectors.toList());
        builder.removeAllFromItems(deployments);
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }
}

