/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;

@ConfigGroup
public class DebugConfig {
    private static final String PORT_NAME = "debug";
    private static final String JAVA_TOOL_OPTIONS = "JAVA_TOOL_OPTIONS";
    private static final String AGENTLIB_FORMAT = "-agentlib:jdwp=transport=%s,server=y,suspend=%s,address=%s";
    @ConfigItem(defaultValue="false")
    boolean enabled;
    @ConfigItem(defaultValue="dt_socket")
    String transport;
    @ConfigItem(defaultValue="n")
    String suspend;
    @ConfigItem(defaultValue="5005")
    Integer addressPort;

    protected Env buildJavaToolOptionsEnv() {
        return ((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(JAVA_TOOL_OPTIONS)).withValue(String.format(AGENTLIB_FORMAT, this.transport, this.suspend, this.addressPort))).build();
    }

    protected Port buildDebugPort() {
        return ((PortBuilder)((PortBuilder)Port.newBuilder().withName(PORT_NAME)).withContainerPort(this.addressPort)).build();
    }
}

