/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.liquibase.LiquibaseDataSource;
import io.quarkus.liquibase.LiquibaseFactory;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public final class LiquibaseFactoryUtil {
    private LiquibaseFactoryUtil() {
    }

    public static InstanceHandle<LiquibaseFactory> getLiquibaseFactory(String dataSourceName) {
        return Arc.container().instance(LiquibaseFactory.class, new Annotation[]{LiquibaseFactoryUtil.getLiquibaseFactoryQualifier(dataSourceName)});
    }

    public static List<InstanceHandle<LiquibaseFactory>> getActiveLiquibaseFactories() {
        ArrayList<InstanceHandle<LiquibaseFactory>> result = new ArrayList<InstanceHandle<LiquibaseFactory>>();
        for (String datasourceName : ((DataSources)Arc.container().instance(DataSources.class, new Annotation[0]).get()).getActiveDataSourceNames()) {
            InstanceHandle handle = Arc.container().instance(LiquibaseFactory.class, new Annotation[]{LiquibaseFactoryUtil.getLiquibaseFactoryQualifier(datasourceName)});
            if (!handle.isAvailable()) continue;
            result.add((InstanceHandle<LiquibaseFactory>)handle);
        }
        return result;
    }

    public static Annotation getLiquibaseFactoryQualifier(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return Default.Literal.INSTANCE;
        }
        return LiquibaseDataSource.LiquibaseDataSourceLiteral.of(dataSourceName);
    }
}

