/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.devtools.commands.ListPlatforms;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.maven.QuarkusProjectMojoBase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="list-platforms", requiresProject=false)
public class ListPlatformsMojo
extends QuarkusProjectMojoBase {
    @Parameter(property="installed", defaultValue="false")
    protected boolean installed;

    @Override
    public void doExecute(QuarkusProject quarkusProject, MessageWriter log) throws MojoExecutionException {
        if (this.installed) {
            this.getImportedPlatforms().forEach(coords -> {
                StringBuilder buf = new StringBuilder();
                buf.append(coords.getGroupId()).append(":").append(coords.getArtifactId().substring(0, coords.getArtifactId().length() - "-quarkus-platform-descriptor".length())).append("::pom:").append(coords.getVersion());
                log.info(buf.toString());
            });
            return;
        }
        try {
            new ListPlatforms(quarkusProject).execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to list platforms", e);
        }
    }
}

