/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.event.ConnectionPoolListener;
import io.quarkus.arc.Arc;
import io.quarkus.mongodb.metrics.MicrometerConnectionPoolListener;
import io.quarkus.mongodb.metrics.MongoMetricsConnectionPoolListener;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.quarkus.mongodb.runtime.MongoClientConfig;
import io.quarkus.mongodb.runtime.MongoClientSupport;
import io.quarkus.mongodb.runtime.MongoClients;
import io.quarkus.mongodb.runtime.MongodbConfig;
import io.quarkus.mongodb.runtime.dns.MongoDnsClientProvider;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class MongoClientRecorder {
    public Supplier<MongoClientSupport> mongoClientSupportSupplier(final List<String> bsonDiscriminators, final List<Supplier<ConnectionPoolListener>> connectionPoolListenerSuppliers, final boolean disableSslSupport) {
        return new Supplier<MongoClientSupport>(){

            @Override
            public MongoClientSupport get() {
                ArrayList<ConnectionPoolListener> connectionPoolListeners = new ArrayList<ConnectionPoolListener>(connectionPoolListenerSuppliers.size());
                for (Supplier item : connectionPoolListenerSuppliers) {
                    connectionPoolListeners.add((ConnectionPoolListener)item.get());
                }
                return new MongoClientSupport(bsonDiscriminators, connectionPoolListeners, disableSslSupport);
            }
        };
    }

    public Supplier<MongoClient> mongoClientSupplier(String clientName, MongodbConfig mongodbConfig) {
        return new MongoClientSupplier<MongoClient>(mongoClients -> mongoClients.createMongoClient(clientName));
    }

    public Supplier<ReactiveMongoClient> reactiveMongoClientSupplier(String clientName, MongodbConfig mongodbConfig) {
        return new MongoClientSupplier<ReactiveMongoClient>(mongoClients -> mongoClients.createReactiveMongoClient(clientName));
    }

    public RuntimeValue<MongoClient> getClient(String name) {
        return new RuntimeValue((Object)((MongoClient)Arc.container().instance(MongoClient.class, new Annotation[]{this.literal(name)}).get()));
    }

    public RuntimeValue<ReactiveMongoClient> getReactiveClient(String name) {
        return new RuntimeValue((Object)((ReactiveMongoClient)Arc.container().instance(ReactiveMongoClient.class, new Annotation[]{this.literal(name + "reactive")}).get()));
    }

    private AnnotationLiteral literal(String name) {
        if (name.startsWith("<default>")) {
            return Default.Literal.INSTANCE;
        }
        return NamedLiteral.of((String)name);
    }

    public Supplier<ConnectionPoolListener> createMicrometerConnectionPoolListener() {
        return new Supplier<ConnectionPoolListener>(){

            @Override
            public ConnectionPoolListener get() {
                return MicrometerConnectionPoolListener.createMicrometerConnectionPool();
            }
        };
    }

    public Supplier<ConnectionPoolListener> createMPMetricsConnectionPoolListener() {
        return new Supplier<ConnectionPoolListener>(){

            @Override
            public ConnectionPoolListener get() {
                return new MongoMetricsConnectionPoolListener();
            }
        };
    }

    public void performInitialization(MongodbConfig config, RuntimeValue<Vertx> vertx) {
        MongoDnsClientProvider.vertx = (Vertx)vertx.getValue();
        this.initializeDNSLookup(config.defaultMongoClientConfig);
        for (MongoClientConfig mongoClientConfig : config.mongoClientConfigs.values()) {
            this.initializeDNSLookup(mongoClientConfig);
        }
    }

    private void initializeDNSLookup(MongoClientConfig mongoClientConfig) {
        if (mongoClientConfig.connectionString.isEmpty()) {
            return;
        }
        new ConnectionString(mongoClientConfig.connectionString.get());
    }

    static final class MongoClientSupplier<T>
    implements Supplier<T> {
        private final Function<MongoClients, T> producer;

        MongoClientSupplier(Function<MongoClients, T> producer) {
            this.producer = producer;
        }

        @Override
        public T get() {
            MongoClients mongoClients = (MongoClients)Arc.container().instance(MongoClients.class, new Annotation[0]).get();
            return this.producer.apply(mongoClients);
        }
    }
}

